/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.email;

import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u0006\u0010%\u001a\u00020#J\u0006\u0010&\u001a\u00020#J\u0006\u0010'\u001a\u00020#J\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020\rJ\u0006\u0010+\u001a\u00020#J\b\u0010,\u001a\u00020#H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u00178F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u000bR\u0011\u0010 \u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/getmati/mati_sdk/ui/email/EmailSharedVm;", "Landroidx/lifecycle/ViewModel;", "savedState", "Landroidx/lifecycle/SavedStateHandle;", "(Landroidx/lifecycle/SavedStateHandle;)V", "value", "", "codeAttemptCount", "getCodeAttemptCount", "()I", "setCodeAttemptCount", "(I)V", "codeAttemptLocked", "", "getCodeAttemptLocked", "()Z", "coolDown", "", "coolDownUntil", "getCoolDownUntil", "()J", "setCoolDownUntil", "(J)V", "", "lastEmail", "getLastEmail", "()Ljava/lang/String;", "setLastEmail", "(Ljava/lang/String;)V", "resendCount", "getResendCount", "setResendCount", "resendLocked", "getResendLocked", "increaseCodeAttemptsCount", "", "increaseResendCount", "lockCodeAttemptsCount", "lockResendCount", "onCodeSent", "onNewEmailSubmitted", "email", "resendIsAllowed", "resetCodeAttemptsCount", "updateCoolDownValue", "Companion", "mati-sdk_release"})
public final class EmailSharedVm
extends ViewModel {
    private final long coolDown;
    private final SavedStateHandle savedState;
    private static final String ARG_RESEND_COUNT = "ARG_RESEND_COUNT";
    private static final String ARG_CODE_ATTEMPT_COUNT = "ARG_CODE_ATTEMPT_COUNT";
    private static final String ARG_RESEND_BLOCKED_UNTIL = "ARG_LAST_RESEND";
    private static final String ARG_LAST_EMAIL = "ARG_LAST_EMAIL";
    private static final String ARG_COOL_DOWN = "ARG_COOL_DOWN";
    private static final int RESEND_LIMIT = 5;
    private static final int CODE_ATTEMPT_LIMIT = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getLastEmail() {
        return (String)this.savedState.get(ARG_LAST_EMAIL);
    }

    private final void setLastEmail(String value) {
        this.savedState.set(ARG_LAST_EMAIL, (Object)value);
    }

    public final int getResendCount() {
        Integer n = (Integer)this.savedState.get(ARG_RESEND_COUNT);
        if (n == null) {
            n = 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"savedState.get<Int>(ARG_RESEND_COUNT) ?: 0");
        return n;
    }

    private final void setResendCount(int value) {
        if (value < 0 || value > 5) {
            return;
        }
        this.savedState.set(ARG_RESEND_COUNT, (Object)value);
    }

    public final void increaseResendCount() {
        EmailSharedVm emailSharedVm2 = this;
        int n = emailSharedVm2.getResendCount();
        emailSharedVm2.setResendCount(n + 1);
    }

    public final void lockResendCount() {
        this.setResendCount(5);
    }

    public final boolean getResendLocked() {
        return this.getResendCount() == 5;
    }

    public final int getCodeAttemptCount() {
        Integer n = (Integer)this.savedState.get(ARG_CODE_ATTEMPT_COUNT);
        if (n == null) {
            n = 0;
        }
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"savedState.get<Int>(ARG_CODE_ATTEMPT_COUNT) ?: 0");
        return n;
    }

    private final void setCodeAttemptCount(int value) {
        if (value < 0 || value > 5) {
            return;
        }
        this.savedState.set(ARG_CODE_ATTEMPT_COUNT, (Object)value);
    }

    public final void increaseCodeAttemptsCount() {
        EmailSharedVm emailSharedVm2 = this;
        int n = emailSharedVm2.getCodeAttemptCount();
        emailSharedVm2.setCodeAttemptCount(n + 1);
    }

    public final void resetCodeAttemptsCount() {
        this.setCodeAttemptCount(0);
    }

    public final void lockCodeAttemptsCount() {
        this.setCodeAttemptCount(3);
    }

    public final boolean getCodeAttemptLocked() {
        return this.getCodeAttemptCount() == 3;
    }

    public final long getCoolDownUntil() {
        Long l = (Long)this.savedState.get(ARG_RESEND_BLOCKED_UNTIL);
        if (l == null) {
            l = 0L;
        }
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"savedState.get<Long>(ARG\u2026ESEND_BLOCKED_UNTIL) ?: 0");
        return l;
    }

    public final void setCoolDownUntil(long value) {
        this.savedState.set(ARG_RESEND_BLOCKED_UNTIL, (Object)value);
    }

    private final void updateCoolDownValue() {
        this.setCoolDownUntil(System.currentTimeMillis() + this.coolDown);
    }

    public final boolean resendIsAllowed() {
        return System.currentTimeMillis() > this.getCoolDownUntil();
    }

    public final void onNewEmailSubmitted(@NotNull String email2) {
        Intrinsics.checkNotNullParameter((Object)email2, (String)"email");
        this.setLastEmail(email2);
        this.onCodeSent();
    }

    public final void onCodeSent() {
        this.resetCodeAttemptsCount();
        this.increaseResendCount();
        this.updateCoolDownValue();
    }

    public EmailSharedVm(@NotNull SavedStateHandle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
        this.savedState = savedState;
        Object object = this.savedState.get(ARG_COOL_DOWN);
        Intrinsics.checkNotNull((Object)object);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"savedState.get<Long>(ARG_COOL_DOWN)!!");
        this.coolDown = ((Number)object).longValue();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/getmati/mati_sdk/ui/email/EmailSharedVm$Companion;", "", "()V", "ARG_CODE_ATTEMPT_COUNT", "", "ARG_COOL_DOWN", "ARG_LAST_EMAIL", "ARG_RESEND_BLOCKED_UNTIL", "ARG_RESEND_COUNT", "CODE_ATTEMPT_LIMIT", "", "RESEND_LIMIT", "mati-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

