/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.icu.util.ULocale;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J\u001c\u0010\b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J;\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/getmati/mati_sdk/ui/utils/FileUtils;", "", "()V", "DOCUMENTS_DIR", "", "createFileByName", "Ljava/io/File;", "name", "generateFileName", "directory", "getDataColumn", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDocumentCacheDir", "getFileName", "getPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "saveFileFromUri", "", "destinationPath", "writeContentToFile", "mati-sdk_release"})
public final class FileUtils {
    private static final String DOCUMENTS_DIR = "documents";
    @NotNull
    public static final FileUtils INSTANCE;

    @Nullable
    public final String getPath(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"docId");
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                if (StringsKt.equals((String)"primary", (String)type, (boolean)true)) {
                    return Environment.getExternalStorageDirectory().toString() + "/" + split[1];
                }
            } else {
                if (this.isDownloadsDocument(uri)) {
                    String[] contentUriPrefixesToTry;
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    if (id2 != null && StringsKt.startsWith$default((String)id2, (String)"raw:", (boolean)false, (int)2, null)) {
                        String split = id2;
                        int type = 4;
                        boolean $i$f$toTypedArray = false;
                        String string3 = split.substring(type);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        return string3;
                    }
                    String string4 = id2;
                    Intrinsics.checkNotNull((Object)string4);
                    if (StringsKt.startsWith$default((String)string4, (String)"msf:", (boolean)false, (int)2, null)) {
                        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
                        String path2 = null;
                        if (cursor != null) {
                            String document_id;
                            cursor.moveToFirst();
                            String string5 = document_id = cursor.getString(0);
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"document_id");
                            String thisCollection$iv = string5;
                            int n = StringsKt.lastIndexOf$default((CharSequence)document_id, (String)":", (int)0, (boolean)false, (int)6, null) + 1;
                            boolean bl = false;
                            String string6 = thisCollection$iv;
                            if (string6 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                            document_id = string7;
                            cursor.close();
                            cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, "_id = ? ", new String[]{document_id}, null);
                            if (cursor != null) {
                                cursor.moveToFirst();
                                path2 = cursor.getString(cursor.getColumnIndex("_data"));
                                cursor.close();
                            }
                        }
                        Log.d((String)"ContentValues", (String)("getImagePathFromURI " + path2));
                        return path2;
                    }
                    for (String contentUriPrefix : contentUriPrefixesToTry = new String[]{"content://downloads/public_downloads", "content://downloads/my_downloads", "content://downloads/all_downloads"}) {
                        Uri uri2 = Uri.parse((String)contentUriPrefix);
                        Long l = Long.valueOf(id2);
                        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
                        Intrinsics.checkNotNullExpressionValue((Object)ContentUris.withAppendedId((Uri)uri2, (long)l), (String)"ContentUris.withAppended\u2026va.lang.Long.valueOf(id))");
                        try {
                            Uri contentUri;
                            String path3 = this.getDataColumn(context, contentUri, null, null);
                            if (path3 == null) continue;
                            return path3;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String fileName = this.getFileName(context, uri);
                    File cacheDir = this.getDocumentCacheDir(context);
                    File file = this.generateFileName(fileName, cacheDir);
                    String destinationPath = null;
                    if (file != null) {
                        destinationPath = file.getAbsolutePath();
                        this.saveFileFromUri(context, uri, destinationPath);
                    }
                    return destinationPath;
                }
                if (this.isMediaDocument(uri)) {
                    String docId;
                    String string8 = docId = DocumentsContract.getDocumentId((Uri)uri);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"docId");
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string8, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] split = stringArray;
                    String type = split[0];
                    Uri contentUri = null;
                    if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    } else if (Intrinsics.areEqual((Object)"document", (Object)type)) {
                        contentUri = MediaStore.Files.getContentUri((String)"external");
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return this.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if (StringsKt.equals((String)"content", (String)uri.getScheme(), (boolean)true)) {
                return this.getDataColumn(context, uri, null, null);
            }
            if (StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true)) {
                return uri.getPath();
            }
        }
        return this.writeContentToFile(context, uri);
    }

    private final File getDocumentCacheDir(Context context) {
        File dir = new File(context.getCacheDir(), DOCUMENTS_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void saveFileFromUri(Context context, Uri uri, String destinationPath) {
        block14: {
            is = null;
            bos = null;
            try {
                is = context.getContentResolver().openInputStream(uri);
                bos = new BufferedOutputStream(new FileOutputStream(destinationPath, false));
                buf = new byte[1024];
                v0 = is;
                Intrinsics.checkNotNull((Object)v0);
                v0.read(buf);
                do {
                    bos.write(buf);
                } while (is.read(buf) != -1);
                ** try [egrp 1[TRYBLOCK] [0 : 81->95)] { 
            }
            catch (IOException e) {
                e.printStackTrace();
                break block14;
            }
            finally {
                try {
                    v1 = is;
                    if (v1 != null) {
                        v1.close();
                    }
                    v2 = bos;
                    if (v2 != null) {
                        v2.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 1 sources

            {
                is.close();
                bos.close();
            }
lbl20:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
            {
            }
        }
    }

    private final File generateFileName(String name, File directory) {
        String string2 = name;
        if (string2 == null) {
            return null;
        }
        String name2 = string2;
        File file = new File(directory, name2);
        if (file.exists()) {
            String fileName = name2;
            String extension = "";
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)name2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex > 0) {
                String string3 = name2;
                int n = 0;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                fileName = string5;
                string3 = name2;
                n = 0;
                String string6 = string3;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                extension = string7;
            }
            int index = 0;
            while (file.exists()) {
                name2 = fileName + '(' + ++index + ')' + extension;
                file = new File(directory, name2);
            }
        }
        try {
            if (!file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            Log.w((String)"ContentValues", (Throwable)e);
            return null;
        }
        return file;
    }

    private final String getFileName(Context context, Uri uri) {
        String mimeType = context.getContentResolver().getType(uri);
        String filename = null;
        if (mimeType == null && context != null) {
            String path2 = this.getPath(context, uri);
            if (path2 == null) {
                if (Build.VERSION.SDK_INT >= 24) {
                    filename = ULocale.getName((String)uri.toString());
                }
            } else {
                File file = new File(path2);
                filename = file.getName();
            }
        } else {
            Cursor returnCursor = context.getContentResolver().query(uri, null, null, null, null);
            if (returnCursor != null) {
                int nameIndex = returnCursor.getColumnIndex("_display_name");
                returnCursor.moveToFirst();
                filename = returnCursor.getString(nameIndex);
                returnCursor.close();
            }
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                if (uri == null || (cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null)) == null || !cursor.moveToFirst() || cursor.getColumnCount() <= 0) break block4;
                int columnIndex = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(columnIndex);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String writeContentToFile(Context context, Uri uri) {
        File file = null;
        InputStream in = null;
        OutputStream out = null;
        try {
            ContentResolver cR = context.getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            Uri uri2 = uri;
            Intrinsics.checkNotNull((Object)uri2);
            String type = mime.getExtensionFromMimeType(cR.getType(uri2));
            String name = String.valueOf(System.currentTimeMillis()) + "." + type;
            file = new File(context.getCacheDir(), name);
            if (!file.exists()) {
                file.createNewFile();
            }
            if ((in = context.getContentResolver().openInputStream(uri)) != null) {
                out = new FileOutputStream(file, false);
                byte[] buf = new byte[1024];
                int len = 0;
                while (true) {
                    int n = in.read(buf);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    len = it;
                    if (n > 0) {
                        out.write(buf, 0, len);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                OutputStream outputStream = out;
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                InputStream inputStream = in;
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File file2 = file;
        Intrinsics.checkNotNull((Object)file2);
        String string2 = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file!!.absolutePath");
        return string2;
    }

    @NotNull
    public final File createFileByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File dir = new File(Environment.getExternalStorageDirectory().toString() + "/Download/eventsJson/");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, name);
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
    }
}

