/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.graphics.pdf.PdfRenderer;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.core.content.FileProvider;
import coil.Coil;
import coil.ImageLoader;
import coil.request.ImageRequest;
import coil.target.Target;
import com.getmati.mati_sdk.ui.utils.BitmapTransformation;
import com.getmati.mati_sdk.ui.utils.ImageUtilsKt;
import com.getmati.mati_sdk.ui.utils.PdfToImageTransformation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\n\u001a\u00020\u0005*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\tH\u0000\u001a(\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\tH\u0000\u001a\u0014\u0010\u0011\u001a\u00020\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0000\u001a\u0016\u0010\u0016\u001a\u00020\u0013*\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u0001H\u0000\u001a(\u0010\u0018\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u000e\b\u0006\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0080\b\u00f8\u0001\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"MIN_DIMENSION", "", "getSeekableFileDescriptor", "Landroid/os/ParcelFileDescriptor;", "file", "Ljava/io/File;", "rotateAndScaleDown", "Lcom/getmati/mati_sdk/ui/utils/BitmapTransformation;", "srcPath", "", "createTempFile", "Landroid/content/Context;", "fileName", "extension", "createTempFileUri", "Landroid/net/Uri;", "kotlin.jvm.PlatformType", "getImagePath", "loadImageFromFileUrl", "", "Landroid/widget/ImageView;", "url", "loadImageResource", "resId", "loadRemoteImage", "onSuccess", "Lkotlin/Function0;", "Landroid/graphics/Bitmap;", "orientation", "tryConvertPdfToImage", "Lcom/getmati/mati_sdk/ui/utils/PdfToImageTransformation;", "mati-sdk_release"})
public final class ImageUtilsKt {
    public static final int MIN_DIMENSION = 600;

    @NotNull
    public static final String getImagePath(@NotNull Context $this$getImagePath, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)$this$getImagePath, (String)"$this$getImagePath");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return $this$getImagePath.getCacheDir() + '/' + fileName + ".jpg";
    }

    @NotNull
    public static final File createTempFile(@NotNull Context $this$createTempFile, @NotNull String fileName, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$createTempFile, (String)"$this$createTempFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return new File($this$createTempFile.getCacheDir() + '/' + fileName + extension);
    }

    public static /* synthetic */ File createTempFile$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "temp";
        }
        if ((n & 2) != 0) {
            string3 = ".jpg";
        }
        return ImageUtilsKt.createTempFile(context, string2, string3);
    }

    public static final Uri createTempFileUri(@NotNull Context $this$createTempFileUri, @NotNull String fileName, @NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)$this$createTempFileUri, (String)"$this$createTempFileUri");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        StringBuilder stringBuilder = new StringBuilder();
        Context context = $this$createTempFileUri.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        return FileProvider.getUriForFile((Context)$this$createTempFileUri, (String)stringBuilder.append(context.getPackageName()).append(".provider").toString(), (File)ImageUtilsKt.createTempFile($this$createTempFileUri, fileName, extension));
    }

    public static /* synthetic */ Uri createTempFileUri$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "temp";
        }
        if ((n & 2) != 0) {
            string3 = ".jpg";
        }
        return ImageUtilsKt.createTempFileUri(context, string2, string3);
    }

    @NotNull
    public static final BitmapTransformation rotateAndScaleDown(@NotNull String srcPath) {
        BitmapTransformation bitmapTransformation;
        Intrinsics.checkNotNullParameter((Object)srcPath, (String)"srcPath");
        int orientation = new ExifInterface(srcPath).getAttributeInt("Orientation", 0);
        BitmapFactory.Options options = new BitmapFactory.Options();
        boolean bl = false;
        boolean bl2 = false;
        BitmapFactory.Options it = options;
        boolean bl3 = false;
        it.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)srcPath, (BitmapFactory.Options)it);
        int n = it.outHeight;
        int n2 = it.outWidth;
        boolean bl4 = false;
        int sampleSize = Math.min(n, n2) / 600;
        if (sampleSize >= 1) {
            options = new BitmapFactory.Options();
            bl = false;
            bl2 = false;
            it = options;
            String string2 = srcPath;
            boolean bl5 = false;
            $this$apply.inSampleSize = sampleSize;
            Unit unit = Unit.INSTANCE;
            Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
            if (bitmap != null) {
                options = bitmap;
                bl = false;
                bl2 = false;
                it = options;
                boolean bl6 = false;
                bitmapTransformation = new BitmapTransformation.Success(ImageUtilsKt.rotateAndScaleDown((Bitmap)it, orientation));
            } else {
                bitmapTransformation = BitmapTransformation.BitmapDecodingError.INSTANCE;
            }
        } else {
            bitmapTransformation = BitmapTransformation.SmallImageError.INSTANCE;
        }
        return bitmapTransformation;
    }

    @NotNull
    public static final Bitmap rotateAndScaleDown(@NotNull Bitmap $this$rotateAndScaleDown, int orientation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotateAndScaleDown, (String)"$this$rotateAndScaleDown");
        Matrix matrix = new Matrix();
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$apply = matrix;
        boolean bl3 = false;
        int n = $this$rotateAndScaleDown.getHeight();
        int n2 = $this$rotateAndScaleDown.getWidth();
        boolean bl4 = false;
        float scale = (float)600 / (float)Math.min(n, n2);
        $this$apply.setScale(scale, scale);
        switch (orientation) {
            case 6: {
                $this$apply.setRotate(90.0f);
                break;
            }
            case 3: {
                $this$apply.setRotate(180.0f);
                break;
            }
            case 8: {
                $this$apply.setRotate(-90.0f);
                break;
            }
            case 2: {
                $this$apply.setScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                $this$apply.setRotate(180.0f);
                $this$apply.postScale(-1.0f, 1.0f);
                break;
            }
            case 5: {
                $this$apply.setRotate(90.0f);
                $this$apply.postScale(-1.0f, 1.0f);
                break;
            }
            case 7: {
                $this$apply.setRotate(-90.0f);
                $this$apply.postScale(-1.0f, 1.0f);
            }
        }
        Matrix matrix2 = matrix;
        Bitmap result2 = Bitmap.createBitmap((Bitmap)$this$rotateAndScaleDown, (int)0, (int)0, (int)$this$rotateAndScaleDown.getWidth(), (int)$this$rotateAndScaleDown.getHeight(), (Matrix)matrix2, (boolean)true);
        if (Intrinsics.areEqual((Object)$this$rotateAndScaleDown, (Object)result2) ^ true) {
            $this$rotateAndScaleDown.recycle();
        }
        Bitmap bitmap = result2;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"result");
        return bitmap;
    }

    @NotNull
    public static final PdfToImageTransformation tryConvertPdfToImage(@NotNull Context $this$tryConvertPdfToImage, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$tryConvertPdfToImage, (String)"$this$tryConvertPdfToImage");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"pdf") ^ true) {
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
            return new PdfToImageTransformation.NotPdfFile(string2);
        }
        ParcelFileDescriptor parcelFileDescriptor = ImageUtilsKt.getSeekableFileDescriptor(file);
        if (parcelFileDescriptor == null) {
            return PdfToImageTransformation.PdfTransformationError.INSTANCE;
        }
        ParcelFileDescriptor fileDescriptor = parcelFileDescriptor;
        String timeStampPattern = "yyyyMMdd_HHmmss";
        try {
            PdfRenderer renderer = new PdfRenderer(fileDescriptor);
            PdfRenderer.Page page = renderer.openPage(0);
            Resources resources = $this$tryConvertPdfToImage.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"this.resources");
            int n = resources.getDisplayMetrics().widthPixels;
            int n2 = 600;
            int n3 = 0;
            int n4 = Math.max(n, n2);
            PdfRenderer.Page page2 = page;
            Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"page");
            n = n4 / page2.getWidth();
            Resources resources2 = $this$tryConvertPdfToImage.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"this.resources");
            n2 = resources2.getDisplayMetrics().heightPixels;
            n3 = 600;
            boolean bl = false;
            n2 = Math.max(n2, n3) / page.getHeight();
            n3 = 0;
            int scaleAmount = Math.max(n, n2);
            int width = page.getWidth() * scaleAmount;
            int height = page.getHeight() * scaleAmount;
            Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            mBitmap.eraseColor(-1);
            page.render(mBitmap, null, null, 1);
            String timeStamp = new SimpleDateFormat(timeStampPattern).format(new Date());
            String newPathFile = ImageUtilsKt.getImagePath($this$tryConvertPdfToImage, timeStamp + "_pdf.jpg");
            FileOutputStream os = new FileOutputStream(newPathFile);
            mBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)os);
            os.flush();
            os.close();
            page.close();
            renderer.close();
            return new PdfToImageTransformation.Success(newPathFile);
        }
        catch (Exception e) {
            return PdfToImageTransformation.PdfTransformationError.INSTANCE;
        }
    }

    private static final ParcelFileDescriptor getSeekableFileDescriptor(File file) {
        ParcelFileDescriptor fd = null;
        try {
            fd = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return fd;
    }

    public static final void loadRemoteImage(@NotNull ImageView $this$loadRemoteImage, @NotNull String url, @NotNull Function0<Unit> onSuccess) {
        int $i$f$loadRemoteImage = 0;
        Intrinsics.checkNotNullParameter((Object)$this$loadRemoteImage, (String)"$this$loadRemoteImage");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        ImageView $this$load_u24default$iv = $this$loadRemoteImage;
        Context context = $this$load_u24default$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fun ImageView.load(\n    \u2026ri, imageLoader, builder)");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        ImageView $this$loadAny$iv$iv = $this$load_u24default$iv;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        context2 = new ImageRequest.Builder(context2).data((Object)url).target($this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$load = context2;
        boolean bl3 = false;
        Context this_$iv = $this$load;
        boolean $i$f$target = false;
        this_$iv.target(new Target($this$loadRemoteImage, onSuccess){
            final /* synthetic */ ImageView $this_loadRemoteImage$inlined;
            final /* synthetic */ Function0 $onSuccess$inlined;
            {
                this.$this_loadRemoteImage$inlined = imageView;
                this.$onSuccess$inlined = function0;
            }

            public void onStart(@Nullable Drawable placeholder) {
                Drawable it = placeholder;
            }

            public void onError(@Nullable Drawable error) {
                Drawable it = error;
            }

            public void onSuccess(@NotNull Drawable result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                Drawable it = result2;
                boolean bl = false;
                this.$this_loadRemoteImage$inlined.setImageDrawable(it);
                this.$onSuccess$inlined.invoke();
            }
        });
        ImageRequest request$iv$iv = context2.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }

    public static /* synthetic */ void loadRemoteImage$default(ImageView $this$loadRemoteImage, String url, Function0 onSuccess, int n, Object object) {
        if ((n & 2) != 0) {
            onSuccess = loadRemoteImage.1.INSTANCE;
        }
        boolean $i$f$loadRemoteImage = false;
        Intrinsics.checkNotNullParameter((Object)$this$loadRemoteImage, (String)"$this$loadRemoteImage");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)onSuccess, (String)"onSuccess");
        ImageView $this$load_u24default$iv = $this$loadRemoteImage;
        Context context = $this$load_u24default$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fun ImageView.load(\n    \u2026ri, imageLoader, builder)");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        ImageView $this$loadAny$iv$iv = $this$load_u24default$iv;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        context2 = new ImageRequest.Builder(context2).data((Object)url).target($this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$load = context2;
        boolean bl3 = false;
        Context this_$iv = $this$load;
        boolean $i$f$target = false;
        this_$iv.target(new Target($this$loadRemoteImage, onSuccess){
            final /* synthetic */ ImageView $this_loadRemoteImage$inlined;
            final /* synthetic */ Function0 $onSuccess$inlined;
            {
                this.$this_loadRemoteImage$inlined = imageView;
                this.$onSuccess$inlined = function0;
            }

            public void onStart(@Nullable Drawable placeholder) {
                Drawable it = placeholder;
            }

            public void onError(@Nullable Drawable error) {
                Drawable it = error;
            }

            public void onSuccess(@NotNull Drawable result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                Drawable it = result2;
                boolean bl = false;
                this.$this_loadRemoteImage$inlined.setImageDrawable(it);
                this.$onSuccess$inlined.invoke();
            }
        });
        ImageRequest request$iv$iv = context2.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadImageResource(@NotNull ImageView $this$loadImageResource, @DrawableRes int resId) {
        void $this$loadAny$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadImageResource, (String)"$this$loadImageResource");
        ImageView $this$load_u24default$iv = $this$loadImageResource;
        Context context = $this$load_u24default$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fun ImageView.load(\n    \u2026Id, imageLoader, builder)");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        ImageView imageView = $this$load_u24default$iv;
        Integer data$iv$iv = resId;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        context2 = new ImageRequest.Builder(context2).data((Object)data$iv$iv).target((ImageView)$this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$null = context2;
        ImageRequest request$iv$iv = context2.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadImageFromFileUrl(@NotNull ImageView $this$loadImageFromFileUrl, @NotNull String url) {
        void $this$load_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadImageFromFileUrl, (String)"$this$loadImageFromFileUrl");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ImageView imageView = $this$loadImageFromFileUrl;
        File file$iv = new File(url);
        Context context = $this$load_u24default$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fun ImageView.load(\n    \u2026le, imageLoader, builder)");
        Context $this$imageLoader$iv$iv = context;
        boolean $i$f$imageLoader = false;
        ImageLoader imageLoader$iv = Coil.imageLoader((Context)$this$imageLoader$iv$iv);
        boolean $i$f$load = false;
        void $this$loadAny$iv$iv = $this$load_u24default$iv;
        boolean $i$f$loadAny = false;
        Context context2 = $this$loadAny$iv$iv.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        context2 = new ImageRequest.Builder(context2).data((Object)file$iv).target((ImageView)$this$loadAny$iv$iv);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$null = context2;
        ImageRequest request$iv$iv = context2.build();
        imageLoader$iv.enqueue(request$iv$iv);
    }
}

