/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.webkit.MimeTypeMap;
import android.webkit.WebSettings;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import java.io.File;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0007\u00a8\u0006\u0015"}, d2={"Lcom/getmati/mati_sdk/ui/utils/Util;", "", "()V", "dpToPx", "", "context", "Landroid/content/Context;", "dp", "", "getApplicationName", "", "getApplicationVersion", "getMimeTime", "path", "getUserAgent", "isColorDark", "", "hex", "openPdf", "", "filePath", "mati-sdk_release"})
public final class Util {
    @NotNull
    public static final Util INSTANCE;

    @Nullable
    public final String getMimeTime(@NotNull String path2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String string3 = MimeTypeMap.getFileExtensionFromUrl((String)path2);
        if (string3 != null) {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    public static final int dpToPx(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    public final boolean isColorDark(@Nullable String hex) {
        int n;
        int color2 = 0;
        try {
            n = Color.parseColor((String)hex);
        }
        catch (IllegalArgumentException pE) {
            pE.printStackTrace();
            return false;
        }
        color2 = n;
        double darkness = (0.299 * (double)Color.red((int)color2) + 0.587 * (double)Color.green((int)color2) + 0.114 * (double)Color.blue((int)color2)) / (double)255;
        return darkness < 0.58;
    }

    @JvmStatic
    @NotNull
    public static final String getUserAgent(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WebSettings.getDefaultUserAgent((Context)context);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%s %s; Mati SDK %s; %s/%s; Android %s";
        Object[] objectArray = new Object[]{INSTANCE.getApplicationName(context), INSTANCE.getApplicationVersion(context), "3.14.0", Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    @JvmStatic
    public static final void openPdf(@NotNull Context context, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        StringBuilder stringBuilder = new StringBuilder();
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        Uri data = FileProvider.getUriForFile((Context)context, (String)stringBuilder.append(context2.getPackageName()).append(".provider").toString(), (File)new File(filePath));
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(data, "application/pdf");
        intent.setFlags(0x4000000);
        intent.addFlags(1);
        intent.addFlags(0x40000000);
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)context, (CharSequence)"Download an App to open PDF", (int)1).show();
        }
    }

    private final String getApplicationName(Context context) {
        String string2;
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        if (stringId == 0) {
            string2 = ((Object)applicationInfo.nonLocalizedLabel).toString();
        } else {
            String string3 = context.getString(stringId);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(stringId)");
        }
        return string2;
    }

    private final String getApplicationVersion(Context context) {
        String string2;
        try {
            int n;
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = packageInfo.versionName;
            int versionCode = 0;
            if (Build.VERSION.SDK_INT >= 28) {
                PackageInfo packageInfo2 = packageInfo;
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo2, (String)"packageInfo");
                n = (int)packageInfo2.getLongVersionCode();
            } else {
                n = packageInfo.versionCode;
            }
            versionCode = n;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%s (%s)";
            Object[] objectArray = new Object[]{versionName, versionCode};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            string2 = string4;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

