/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.ui.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.media.Image;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getmati/mati_sdk/ui/utils/YuvToRgbConverter;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "inputAllocation", "Landroid/renderscript/Allocation;", "outputAllocation", "pixelCount", "", "rs", "Landroid/renderscript/RenderScript;", "kotlin.jvm.PlatformType", "scriptYuvToRgb", "Landroid/renderscript/ScriptIntrinsicYuvToRGB;", "yuvBuffer", "", "imageToByteArray", "", "image", "Landroid/media/Image;", "outputBuffer", "yuvToRgb", "Landroid/graphics/Bitmap;", "mati-sdk_release"})
public final class YuvToRgbConverter {
    private final RenderScript rs;
    private final ScriptIntrinsicYuvToRGB scriptYuvToRgb;
    private int pixelCount;
    private byte[] yuvBuffer;
    private Allocation inputAllocation;
    private Allocation outputAllocation;

    @NotNull
    public final synchronized Bitmap yuvToRgb(@NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Bitmap output = Bitmap.createBitmap((int)image.getWidth(), (int)image.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (this.yuvBuffer == null) {
            this.pixelCount = image.getCropRect().width() * image.getCropRect().height();
            int pixelSizeBits = ImageFormat.getBitsPerPixel((int)35);
            this.yuvBuffer = new byte[this.pixelCount * pixelSizeBits / 8];
        }
        if (this.yuvBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
        }
        this.imageToByteArray(image, this.yuvBuffer);
        if (this.inputAllocation == null) {
            Type elemType;
            Type type = elemType = new Type.Builder(this.rs, Element.YUV((RenderScript)this.rs)).setYuvFormat(17).create();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"elemType");
            Element element = type.getElement();
            if (this.yuvBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
            }
            Allocation allocation = Allocation.createSized((RenderScript)this.rs, (Element)element, (int)this.yuvBuffer.length);
            Intrinsics.checkNotNullExpressionValue((Object)allocation, (String)"Allocation.createSized(r\u2026.element, yuvBuffer.size)");
            this.inputAllocation = allocation;
        }
        if (this.outputAllocation == null) {
            Allocation allocation = Allocation.createFromBitmap((RenderScript)this.rs, (Bitmap)output);
            Intrinsics.checkNotNullExpressionValue((Object)allocation, (String)"Allocation.createFromBitmap(rs, output)");
            this.outputAllocation = allocation;
        }
        Allocation allocation = this.inputAllocation;
        if (allocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputAllocation");
        }
        if (this.yuvBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
        }
        allocation.copyFrom(this.yuvBuffer);
        Allocation allocation2 = this.inputAllocation;
        if (allocation2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputAllocation");
        }
        this.scriptYuvToRgb.setInput(allocation2);
        Allocation allocation3 = this.outputAllocation;
        if (allocation3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputAllocation");
        }
        this.scriptYuvToRgb.forEach(allocation3);
        Allocation allocation4 = this.outputAllocation;
        if (allocation4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputAllocation");
        }
        allocation4.copyTo(output);
        Bitmap bitmap = output;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"output");
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private final void imageToByteArray(Image image, byte[] outputBuffer) {
        boolean bl = image.getFormat() == 35;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Rect imageCrop = image.getCropRect();
        Image.Plane[] imagePlanes = image.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)imagePlanes, (String)"imagePlanes");
        Image.Plane[] $this$forEachIndexed$iv = imagePlanes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        block5: for (Image.Plane item$iv : $this$forEachIndexed$iv) {
            void plane;
            int n = index$iv++;
            Image.Plane plane2 = item$iv;
            int planeIndex = n;
            boolean bl5 = false;
            int outputStride = 0;
            int outputOffset = 0;
            switch (planeIndex) {
                case 0: {
                    outputStride = 1;
                    outputOffset = 0;
                    break;
                }
                case 1: {
                    outputStride = 2;
                    outputOffset = this.pixelCount + 1;
                    break;
                }
                case 2: {
                    outputStride = 2;
                    outputOffset = this.pixelCount;
                    break;
                }
                default: {
                    continue block5;
                }
            }
            void v1 = plane;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"plane");
            ByteBuffer planeBuffer = v1.getBuffer();
            int rowStride = plane.getRowStride();
            int pixelStride = plane.getPixelStride();
            Rect planeCrop = planeIndex == 0 ? imageCrop : new Rect(imageCrop.left / 2, imageCrop.top / 2, imageCrop.right / 2, imageCrop.bottom / 2);
            int planeWidth = planeCrop.width();
            int planeHeight = planeCrop.height();
            byte[] rowBuffer = new byte[plane.getRowStride()];
            int rowLength = pixelStride == 1 && outputStride == 1 ? planeWidth : (planeWidth - 1) * pixelStride + 1;
            int n2 = 0;
            int n3 = planeHeight;
            while (n2 < n3) {
                void row;
                planeBuffer.position((int)((row + planeCrop.top) * rowStride + planeCrop.left * pixelStride));
                if (pixelStride == 1 && outputStride == 1) {
                    planeBuffer.get(outputBuffer, outputOffset, rowLength);
                    outputOffset += rowLength;
                } else {
                    planeBuffer.get(rowBuffer, 0, rowLength);
                    int n4 = 0;
                    int n5 = planeWidth;
                    while (n4 < n5) {
                        void col;
                        outputBuffer[outputOffset] = rowBuffer[col * pixelStride];
                        outputOffset += outputStride;
                        ++col;
                    }
                }
                ++row;
            }
        }
    }

    public YuvToRgbConverter(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.rs = RenderScript.create((Context)context);
        this.scriptYuvToRgb = ScriptIntrinsicYuvToRGB.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        this.pixelCount = -1;
    }

    public static final /* synthetic */ byte[] access$getYuvBuffer$p(YuvToRgbConverter $this) {
        if ($this.yuvBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"yuvBuffer");
        }
        return $this.yuvBuffer;
    }

    public static final /* synthetic */ void access$setYuvBuffer$p(YuvToRgbConverter $this, byte[] byArray) {
        $this.yuvBuffer = byArray;
    }

    public static final /* synthetic */ Allocation access$getInputAllocation$p(YuvToRgbConverter $this) {
        Allocation allocation = $this.inputAllocation;
        if (allocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"inputAllocation");
        }
        return allocation;
    }

    public static final /* synthetic */ void access$setInputAllocation$p(YuvToRgbConverter $this, Allocation allocation) {
        $this.inputAllocation = allocation;
    }

    public static final /* synthetic */ Allocation access$getOutputAllocation$p(YuvToRgbConverter $this) {
        Allocation allocation = $this.outputAllocation;
        if (allocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputAllocation");
        }
        return allocation;
    }

    public static final /* synthetic */ void access$setOutputAllocation$p(YuvToRgbConverter $this, Allocation allocation) {
        $this.outputAllocation = allocation;
    }
}

