/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.widgets;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.getmati.mati_sdk.R;
import com.getmati.mati_sdk.databinding.CpfEditTextBinding;
import java.util.ArrayList;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002&'B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ2\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00102\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020\u001bH\u0002J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0002J\b\u0010$\u001a\u00020\u001bH\u0002J\b\u0010%\u001a\u00020\u001bH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006("}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State;", "binding", "Lcom/getmati/mati_sdk/databinding/CpfEditTextBinding;", "editTextsList", "Ljava/util/ArrayList;", "Landroid/widget/EditText;", "Lkotlin/collections/ArrayList;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "text", "", "getText", "()Ljava/lang/String;", "configureJumps", "", "etFrom", "etTo", "etBefore", "maxDigits", "hideError", "isDummyData", "", "isValidCPFNumber", "showError", "updateState", "Companion", "State", "mati-sdk_release"})
public final class CpfEditText
extends ConstraintLayout {
    private final MutableStateFlow<State> _state;
    @NotNull
    private final StateFlow<State> state;
    private final CpfEditTextBinding binding;
    private ArrayList<EditText> editTextsList;
    public static final int CPF_NUMBER_LENGTH = 11;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final StateFlow<State> getState() {
        return this.state;
    }

    @NotNull
    public final String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        EditText editText = this.binding.et1;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"binding.et1");
        StringBuilder stringBuilder2 = stringBuilder.append(editText.getText()).append('.');
        EditText editText2 = this.binding.et2;
        Intrinsics.checkNotNullExpressionValue((Object)editText2, (String)"binding.et2");
        StringBuilder stringBuilder3 = stringBuilder2.append(editText2.getText()).append('.');
        EditText editText3 = this.binding.et3;
        Intrinsics.checkNotNullExpressionValue((Object)editText3, (String)"binding.et3");
        StringBuilder stringBuilder4 = stringBuilder3.append(editText3.getText()).append('-');
        EditText editText4 = this.binding.et4;
        Intrinsics.checkNotNullExpressionValue((Object)editText4, (String)"binding.et4");
        return stringBuilder4.append(editText4.getText()).toString();
    }

    private final void configureJumps(EditText etFrom, EditText etTo, EditText etBefore, int maxDigits) {
        TextView $this$doAfterTextChanged$iv = (TextView)etFrom;
        boolean $i$f$doAfterTextChanged = false;
        TextView $this$addTextChangedListener_u24default$iv$iv = $this$doAfterTextChanged$iv;
        boolean $i$f$addTextChangedListener = false;
        TextWatcher textWatcher$iv$iv = new TextWatcher(this, maxDigits, etTo, etBefore){
            final /* synthetic */ CpfEditText this$0;
            final /* synthetic */ int $maxDigits$inlined;
            final /* synthetic */ EditText $etTo$inlined;
            final /* synthetic */ EditText $etBefore$inlined;
            {
                this.this$0 = cpfEditText;
                this.$maxDigits$inlined = n;
                this.$etTo$inlined = editText;
                this.$etBefore$inlined = editText2;
            }

            /*
             * Enabled aggressive block sorting
             */
            public void afterTextChanged(@Nullable Editable s) {
                Editable text = s;
                boolean bl = false;
                Editable editable = text;
                if (editable != null && editable.length() == this.$maxDigits$inlined) {
                    EditText editText = this.$etTo$inlined;
                    if (editText != null) {
                        editText.requestFocus();
                    }
                } else {
                    Editable editable2 = text;
                    if (editable2 != null && editable2.length() == 0) {
                        EditText editText = this.$etBefore$inlined;
                        if (editText != null) {
                            editText.requestFocus();
                        }
                    }
                }
                CpfEditText.access$updateState(this.this$0);
            }

            public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                int n = after;
                int n2 = count;
                int n3 = start;
                CharSequence $noName_0 = text;
            }

            public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                int n = count;
                int n2 = before;
                int n3 = start;
                CharSequence $noName_0 = text;
            }
        };
        $this$addTextChangedListener_u24default$iv$iv.addTextChangedListener(textWatcher$iv$iv);
    }

    static /* synthetic */ void configureJumps$default(CpfEditText cpfEditText, EditText editText, EditText editText2, EditText editText3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            editText2 = null;
        }
        if ((n2 & 4) != 0) {
            editText3 = null;
        }
        if ((n2 & 8) != 0) {
            n = 3;
        }
        cpfEditText.configureJumps(editText, editText2, editText3, n);
    }

    private final void updateState() {
        State state;
        int enteredCpfDigitsCount = 0;
        Iterable $this$forEach$iv = this.editTextsList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditText it = (EditText)element$iv;
            boolean bl = false;
            enteredCpfDigitsCount += it.getText().length();
        }
        switch (enteredCpfDigitsCount) {
            case 0: {
                this.hideError();
                state = State.Empty.INSTANCE;
                break;
            }
            case 11: {
                if (this.isDummyData() || !this.isValidCPFNumber()) {
                    this.showError();
                    state = State.NotComplete.INSTANCE;
                    break;
                }
                this.hideError();
                state = State.Filled.INSTANCE;
                break;
            }
            default: {
                this.hideError();
                state = State.NotComplete.INSTANCE;
            }
        }
        this._state.setValue((Object)state);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidCPFNumber() {
        ArrayList<Integer> cpfArray = new ArrayList<Integer>();
        Iterable $this$forEach$iv = this.editTextsList;
        int $i$f$forEach = 0;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            EditText it = (EditText)element$iv;
            boolean bl = false;
            Object object = it.getText().toString();
            boolean bl2 = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            object = cArray;
            boolean $i$f$forEach2 = false;
            void var10_13 = $this$forEach$iv2;
            int n = ((void)var10_13).length;
            for (int i = 0; i < n; ++i) {
                void element$iv2;
                void it2 = element$iv2 = var10_13[i];
                boolean bl3 = false;
                String string3 = String.valueOf((char)it2);
                boolean bl4 = false;
                cpfArray.add(Integer.parseInt(string3));
            }
        }
        int firstCheckSum = 0;
        $i$f$forEach = 0;
        int n = 8;
        while ($i$f$forEach <= n) {
            void i;
            firstCheckSum += ((Number)cpfArray.get((int)i)).intValue() * (10 - i);
            ++i;
        }
        Integer n2 = (Integer)cpfArray.get(9);
        if (n2 == null || firstCheckSum * 10 % 11 % 10 != n2) {
            return false;
        }
        int secondCheckSum = 0;
        n = 0;
        int n3 = 9;
        while (n <= n3) {
            void i;
            secondCheckSum += ((Number)cpfArray.get((int)i)).intValue() * (11 - i);
            ++i;
        }
        Integer n4 = (Integer)cpfArray.get(10);
        return n4 != null && secondCheckSum * 10 % 11 % 10 == n4;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isDummyData() {
        HashSet<Character> set = new HashSet<Character>();
        Iterable $this$forEach$iv = this.editTextsList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            EditText it = (EditText)element$iv;
            boolean bl = false;
            Object object = it.getText().toString();
            boolean bl2 = false;
            String string2 = object;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string2.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            object = cArray;
            boolean $i$f$forEach2 = false;
            void var10_10 = $this$forEach$iv2;
            int n = ((void)var10_10).length;
            for (int i = 0; i < n; ++i) {
                void element$iv2;
                void it2 = element$iv2 = var10_10[i];
                boolean bl3 = false;
                set.add(Character.valueOf((char)it2));
            }
        }
        return set.size() == 1;
    }

    private final void showError() {
        TextView textView = this.binding.textError;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textError");
        textView.setVisibility(0);
        Iterable $this$forEach$iv = this.editTextsList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditText it = (EditText)element$iv;
            boolean bl = false;
            EditText editText = this.binding.et1;
            Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"binding.et1");
            it.setBackground(ContextCompat.getDrawable((Context)editText.getContext(), (int)R.drawable.bg_et_cpf_error));
        }
    }

    private final void hideError() {
        TextView textView = this.binding.textError;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textError");
        textView.setVisibility(4);
        Iterable $this$forEach$iv = this.editTextsList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditText it = (EditText)element$iv;
            boolean bl = false;
            EditText editText = this.binding.et1;
            Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"binding.et1");
            it.setBackground(ContextCompat.getDrawable((Context)editText.getContext(), (int)R.drawable.bg_et_cpf_normal));
        }
    }

    @JvmOverloads
    public CpfEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this._state = StateFlowKt.MutableStateFlow((Object)State.Empty.INSTANCE);
        this.state = (StateFlow)this._state;
        LayoutInflater.from((Context)context).inflate(R.layout.cpf_edit_text, (ViewGroup)this, true);
        CpfEditTextBinding cpfEditTextBinding = CpfEditTextBinding.bind((View)this);
        Intrinsics.checkNotNullExpressionValue((Object)cpfEditTextBinding, (String)"CpfEditTextBinding.bind(this)");
        this.binding = cpfEditTextBinding;
        Object[] objectArray = new EditText[4];
        EditText editText = this.binding.et1;
        Intrinsics.checkNotNullExpressionValue((Object)editText, (String)"binding.et1");
        objectArray[0] = editText;
        EditText editText2 = this.binding.et2;
        Intrinsics.checkNotNullExpressionValue((Object)editText2, (String)"binding.et2");
        objectArray[1] = editText2;
        EditText editText3 = this.binding.et3;
        Intrinsics.checkNotNullExpressionValue((Object)editText3, (String)"binding.et3");
        objectArray[2] = editText3;
        EditText editText4 = this.binding.et4;
        Intrinsics.checkNotNullExpressionValue((Object)editText4, (String)"binding.et4");
        objectArray[3] = editText4;
        this.editTextsList = CollectionsKt.arrayListOf((Object[])objectArray);
        EditText editText5 = this.binding.et1;
        Intrinsics.checkNotNullExpressionValue((Object)editText5, (String)"binding.et1");
        CpfEditText.configureJumps$default(this, editText5, this.binding.et2, null, 0, 12, null);
        EditText editText6 = this.binding.et2;
        Intrinsics.checkNotNullExpressionValue((Object)editText6, (String)"binding.et2");
        CpfEditText.configureJumps$default(this, editText6, this.binding.et3, this.binding.et1, 0, 8, null);
        EditText editText7 = this.binding.et3;
        Intrinsics.checkNotNullExpressionValue((Object)editText7, (String)"binding.et3");
        CpfEditText.configureJumps$default(this, editText7, this.binding.et4, this.binding.et2, 0, 8, null);
        EditText editText8 = this.binding.et4;
        Intrinsics.checkNotNullExpressionValue((Object)editText8, (String)"binding.et4");
        CpfEditText.configureJumps$default(this, editText8, null, this.binding.et3, 0, 8, null);
    }

    public /* synthetic */ CpfEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CpfEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CpfEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ void access$updateState(CpfEditText $this) {
        $this.updateState();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText$State;", "", "()V", "Empty", "Filled", "NotComplete", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State$Empty;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State$Filled;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State$NotComplete;", "mati-sdk_release"})
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText$State$Empty;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State;", "()V", "mati-sdk_release"})
        public static final class Empty
        extends State {
            @NotNull
            public static final Empty INSTANCE;

            private Empty() {
                super(null);
            }

            static {
                Empty empty;
                INSTANCE = empty = new Empty();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText$State$Filled;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State;", "()V", "mati-sdk_release"})
        public static final class Filled
        extends State {
            @NotNull
            public static final Filled INSTANCE;

            private Filled() {
                super(null);
            }

            static {
                Filled filled;
                INSTANCE = filled = new Filled();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText$State$NotComplete;", "Lcom/getmati/mati_sdk/widgets/CpfEditText$State;", "()V", "mati-sdk_release"})
        public static final class NotComplete
        extends State {
            @NotNull
            public static final NotComplete INSTANCE;

            private NotComplete() {
                super(null);
            }

            static {
                NotComplete notComplete;
                INSTANCE = notComplete = new NotComplete();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/getmati/mati_sdk/widgets/CpfEditText$Companion;", "", "()V", "CPF_NUMBER_LENGTH", "", "mati-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

