/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.widgets;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.LinearLayout;
import android.widget.Space;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewGroupKt;
import com.getmati.mati_sdk.widgets.PassCodeView;
import com.getmati.mati_sdk.widgets.PassCodeView$symbolSubviews$;
import com.getmati.mati_sdk.widgets.PassCodeViewKt;
import com.getmati.mati_sdk.widgets.PassCodeViewStyleUtils;
import com.getmati.mati_sdk.widgets.SymbolView;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 92\u00020\u0001:\u00039:;B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\"2\b\b\u0001\u0010&\u001a\u00020\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\"H\u0014J\b\u0010-\u001a\u00020(H\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020(2\u0006\u0010*\u001a\u000203H\u0017J\b\u00104\u001a\u00020\"H\u0002J\u0006\u00105\u001a\u00020\"J\b\u00106\u001a\u00020\"H\u0002J\b\u00107\u001a\u00020\"H\u0002J\f\u00108\u001a\u00020(*\u00020+H\u0002R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0016@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006<"}, d2={"Lcom/getmati/mati_sdk/widgets/PassCodeView;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "enteredCode", "getEnteredCode", "()Ljava/lang/String;", "setEnteredCode", "(Ljava/lang/String;)V", "onChangeListener", "Lcom/getmati/mati_sdk/widgets/PassCodeView$OnChangeListener;", "getOnChangeListener", "()Lcom/getmati/mati_sdk/widgets/PassCodeView$OnChangeListener;", "setOnChangeListener", "(Lcom/getmati/mati_sdk/widgets/PassCodeView$OnChangeListener;)V", "Lcom/getmati/mati_sdk/widgets/PassCodeView$Style;", "style", "getStyle$mati_sdk_release", "()Lcom/getmati/mati_sdk/widgets/PassCodeView$Style;", "setStyle$mati_sdk_release", "(Lcom/getmati/mati_sdk/widgets/PassCodeView$Style;)V", "symbolSubviews", "Lkotlin/sequences/Sequence;", "Lcom/getmati/mati_sdk/widgets/SymbolView;", "getSymbolSubviews", "()Lkotlin/sequences/Sequence;", "appendSymbol", "", "symbol", "", "changeColor", "id", "handleKeyEvent", "", "keyCode", "event", "Landroid/view/KeyEvent;", "onAttachedToWindow", "onCheckIsTextEditor", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onTouchEvent", "Landroid/view/MotionEvent;", "removeLastSymbol", "reset", "setupSymbolSubviews", "updateState", "isDigitKey", "Companion", "OnChangeListener", "Style", "mati-sdk_release"})
public final class PassCodeView
extends LinearLayout {
    @NotNull
    private String enteredCode;
    @Nullable
    private OnChangeListener onChangeListener;
    @NotNull
    private Style style;
    public static final int DEFAULT_CODE_LENGTH = 4;
    private static final long KEYBOARD_AUTO_SHOW_DELAY = 500L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getEnteredCode() {
        return this.enteredCode;
    }

    public final void setEnteredCode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean bl = value.length() <= PassCodeViewKt.getCodeLength(this);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "enteredCode=" + value + " is longer than " + PassCodeViewKt.getCodeLength(this);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        this.enteredCode = value;
        OnChangeListener onChangeListener = this.onChangeListener;
        if (onChangeListener != null) {
            onChangeListener.onCodeChange(value, value.length() == PassCodeViewKt.getCodeLength(this));
        }
        this.updateState();
    }

    @Nullable
    public final OnChangeListener getOnChangeListener() {
        return this.onChangeListener;
    }

    public final void setOnChangeListener(@Nullable OnChangeListener onChangeListener) {
        this.onChangeListener = onChangeListener;
    }

    @NotNull
    public final Style getStyle$mati_sdk_release() {
        return this.style;
    }

    public final void setStyle$mati_sdk_release(@NotNull Style value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (Intrinsics.areEqual((Object)this.style, (Object)value)) {
            return;
        }
        this.style = value;
        this.removeAllViews();
        this.updateState();
    }

    private final Sequence<SymbolView> getSymbolSubviews() {
        Sequence $this$filterIsInstance$iv = ViewGroupKt.getChildren((ViewGroup)this);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)symbolSubviews$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateState() {
        String viewCode2;
        boolean isViewCodeOutdated;
        boolean codeLengthChanged;
        boolean bl = codeLengthChanged = PassCodeViewKt.getCodeLength(this) != SequencesKt.count(this.getSymbolSubviews());
        if (codeLengthChanged) {
            this.setupSymbolSubviews();
        }
        if (isViewCodeOutdated = Intrinsics.areEqual((Object)this.enteredCode, (Object)(viewCode2 = SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map(this.getSymbolSubviews(), (Function1)updateState.viewCode.1.INSTANCE)), (CharSequence)"", null, null, (int)0, null, null, (int)62, null))) ^ true) {
            Sequence<SymbolView> $this$forEachIndexed$iv = this.getSymbolSubviews();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void view;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SymbolView symbolView = (SymbolView)((Object)item$iv);
                int index = n;
                boolean bl3 = false;
                view.setSymbol(StringsKt.getOrNull((CharSequence)this.enteredCode, (int)index));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupSymbolSubviews() {
        this.removeAllViews();
        int n = 0;
        int n2 = PassCodeViewKt.getCodeLength(this);
        while (n < n2) {
            void i;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            SymbolView symbolView = new SymbolView(context, this.style.getSymbolViewStyle());
            this.addView(symbolView);
            if (i < PassCodeViewKt.getCodeLength(this) + -1) {
                Space space = new Space(this.getContext());
                boolean bl = false;
                boolean bl2 = false;
                Space $this$apply = space;
                boolean bl3 = false;
                $this$apply.setLayoutParams(new ViewGroup.LayoutParams(this.style.getSymbolsSpacing(), 0));
                Space space2 = space;
                this.addView((View)space2);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onAttachedToWindow() {
        void $this$postDelayed$iv;
        super.onAttachedToWindow();
        this.setOnKeyListener(new View.OnKeyListener(this){
            final /* synthetic */ PassCodeView this$0;

            public final boolean onKey(View $noName_0, int keyCode, KeyEvent event) {
                KeyEvent keyEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)keyEvent, (String)"event");
                return PassCodeView.access$handleKeyEvent(this.this$0, keyCode, keyEvent);
            }
            {
                this.this$0 = passCodeView;
            }
        });
        PassCodeView passCodeView = this;
        long delayInMillis$iv = 500L;
        boolean $i$f$postDelayed = false;
        Runnable runnable$iv = new Runnable(this){
            final /* synthetic */ PassCodeView this$0;
            {
                this.this$0 = passCodeView;
            }

            public final void run() {
                boolean bl = false;
                this.this$0.requestFocus();
                PassCodeViewKt.showKeyboard((View)this.this$0);
            }
        };
        $this$postDelayed$iv.postDelayed(runnable$iv, delayInMillis$iv);
    }

    private final boolean handleKeyEvent(int keyCode, KeyEvent event) {
        boolean bl;
        if (event.getAction() != 0) {
            bl = false;
        } else if (this.isDigitKey(event)) {
            char enteredSymbol = event.getKeyCharacterMap().getNumber(keyCode);
            this.appendSymbol(enteredSymbol);
            bl = true;
        } else if (event.getKeyCode() == 67) {
            this.removeLastSymbol();
            bl = true;
        } else if (event.getKeyCode() == 66) {
            PassCodeViewKt.hideKeyboard((View)this);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDigitKey(KeyEvent $this$isDigitKey) {
        int n = $this$isDigitKey.getKeyCode();
        return 7 <= n && 16 >= n;
    }

    private final void appendSymbol(char symbol) {
        if (this.enteredCode.length() == PassCodeViewKt.getCodeLength(this)) {
            return;
        }
        this.setEnteredCode(this.enteredCode + symbol);
    }

    private final void removeLastSymbol() {
        CharSequence charSequence = this.enteredCode;
        int n = 0;
        if (charSequence.length() == 0) {
            return;
        }
        charSequence = this.enteredCode;
        n = 0;
        int n2 = this.enteredCode.length() - 1;
        boolean bl = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)charSequence2).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        this.setEnteredCode(string2);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 0 && this.requestFocus()) {
            PassCodeViewKt.showKeyboard((View)this);
        }
        return super.onTouchEvent(event);
    }

    public boolean onCheckIsTextEditor() {
        return true;
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkNotNullParameter((Object)outAttrs, (String)"outAttrs");
        boolean bl = false;
        boolean bl2 = false;
        EditorInfo $this$with = outAttrs;
        boolean bl3 = false;
        $this$with.inputType = 2;
        $this$with.imeOptions = 6;
        return (InputConnection)new BaseInputConnection((View)this, false);
    }

    public final void reset() {
        this.setEnteredCode("");
    }

    public final void changeColor(@ColorRes int id2) {
        int color2 = ContextCompat.getColor((Context)this.getContext(), (int)id2);
        PassCodeViewKt.setSymbolTextColor(this, color2);
        PassCodeViewKt.setSymbolBorderColor(this, color2);
    }

    @JvmOverloads
    public PassCodeView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.enteredCode = "";
        this.style = PassCodeViewStyleUtils.INSTANCE.getDefault(context);
        this.setOrientation(0);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setStyle$mati_sdk_release(attrs == null ? PassCodeViewStyleUtils.INSTANCE.getDefault(context) : PassCodeViewStyleUtils.INSTANCE.getFromAttributes(attrs, context));
        this.updateState();
        if (this.isInEditMode()) {
            int n = PassCodeViewKt.getCodeLength(this);
            boolean bl = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl2 = false;
                PassCodeView passCodeView = this;
                passCodeView.setEnteredCode(passCodeView.enteredCode + "0");
            }
        }
    }

    public /* synthetic */ PassCodeView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public PassCodeView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PassCodeView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$handleKeyEvent(PassCodeView $this, int keyCode, KeyEvent event) {
        return $this.handleKeyEvent(keyCode, event);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/getmati/mati_sdk/widgets/PassCodeView$OnChangeListener;", "", "onCodeChange", "", "code", "", "isComplete", "", "mati-sdk_release"})
    public static interface OnChangeListener {
        public void onCodeChange(@NotNull String var1, boolean var2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/getmati/mati_sdk/widgets/PassCodeView$Style;", "", "codeLength", "", "symbolsSpacing", "symbolViewStyle", "Lcom/getmati/mati_sdk/widgets/SymbolView$Style;", "(IILcom/getmati/mati_sdk/widgets/SymbolView$Style;)V", "getCodeLength", "()I", "getSymbolViewStyle", "()Lcom/getmati/mati_sdk/widgets/SymbolView$Style;", "getSymbolsSpacing", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "mati-sdk_release"})
    public static final class Style {
        private final int codeLength;
        private final int symbolsSpacing;
        @NotNull
        private final SymbolView.Style symbolViewStyle;

        public final int getCodeLength() {
            return this.codeLength;
        }

        public final int getSymbolsSpacing() {
            return this.symbolsSpacing;
        }

        @NotNull
        public final SymbolView.Style getSymbolViewStyle() {
            return this.symbolViewStyle;
        }

        public Style(int codeLength, int symbolsSpacing, @NotNull SymbolView.Style symbolViewStyle) {
            Intrinsics.checkNotNullParameter((Object)symbolViewStyle, (String)"symbolViewStyle");
            this.codeLength = codeLength;
            this.symbolsSpacing = symbolsSpacing;
            this.symbolViewStyle = symbolViewStyle;
        }

        public final int component1() {
            return this.codeLength;
        }

        public final int component2() {
            return this.symbolsSpacing;
        }

        @NotNull
        public final SymbolView.Style component3() {
            return this.symbolViewStyle;
        }

        @NotNull
        public final Style copy(int codeLength, int symbolsSpacing, @NotNull SymbolView.Style symbolViewStyle) {
            Intrinsics.checkNotNullParameter((Object)symbolViewStyle, (String)"symbolViewStyle");
            return new Style(codeLength, symbolsSpacing, symbolViewStyle);
        }

        public static /* synthetic */ Style copy$default(Style style, int n, int n2, SymbolView.Style style2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = style.codeLength;
            }
            if ((n3 & 2) != 0) {
                n2 = style.symbolsSpacing;
            }
            if ((n3 & 4) != 0) {
                style2 = style.symbolViewStyle;
            }
            return style.copy(n, n2, style2);
        }

        @NotNull
        public String toString() {
            return "Style(codeLength=" + this.codeLength + ", symbolsSpacing=" + this.symbolsSpacing + ", symbolViewStyle=" + this.symbolViewStyle + ")";
        }

        public int hashCode() {
            SymbolView.Style style = this.symbolViewStyle;
            return (Integer.hashCode(this.codeLength) * 31 + Integer.hashCode(this.symbolsSpacing)) * 31 + (style != null ? ((Object)style).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Style)) break block3;
                    Style style = (Style)object;
                    if (this.codeLength != style.codeLength || this.symbolsSpacing != style.symbolsSpacing || !Intrinsics.areEqual((Object)this.symbolViewStyle, (Object)style.symbolViewStyle)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/getmati/mati_sdk/widgets/PassCodeView$Companion;", "", "()V", "DEFAULT_CODE_LENGTH", "", "KEYBOARD_AUTO_SHOW_DELAY", "", "mati-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

