/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.widgets;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.getmati.mati_sdk.R;
import com.getmati.mati_sdk.widgets.PassCodeView;
import com.getmati.mati_sdk.widgets.PassCodeViewKt;
import com.getmati.mati_sdk.widgets.SymbolView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/getmati/mati_sdk/widgets/PassCodeViewStyleUtils;", "", "()V", "defaultStyle", "Lcom/getmati/mati_sdk/widgets/PassCodeView$Style;", "getDefault", "context", "Landroid/content/Context;", "getFromAttributes", "attrs", "Landroid/util/AttributeSet;", "mati-sdk_release"})
public final class PassCodeViewStyleUtils {
    private static PassCodeView.Style defaultStyle;
    @NotNull
    public static final PassCodeViewStyleUtils INSTANCE;

    @NotNull
    public final PassCodeView.Style getDefault(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (defaultStyle == null) {
            Resources resources = context.getResources();
            SymbolView.Style symbolViewStyle = new SymbolView.Style(resources.getDimensionPixelSize(R.dimen.symbol_view_width), resources.getDimensionPixelSize(R.dimen.symbol_view_height), PassCodeViewKt.getThemeColor(context, R.attr.colorSurface), PassCodeViewKt.getThemeColor(context, R.attr.colorPrimary), resources.getDimensionPixelSize(R.dimen.symbol_view_stroke_width), resources.getDimension(R.dimen.symbol_view_corner_radius), PassCodeViewKt.getThemeColor(context, R.attr.colorOnSurface), resources.getDimensionPixelSize(R.dimen.symbol_view_text_size), R.font.lato_regular);
            defaultStyle = new PassCodeView.Style(4, resources.getDimensionPixelSize(R.dimen.symbols_spacing), symbolViewStyle);
        }
        PassCodeView.Style style = defaultStyle;
        Intrinsics.checkNotNull((Object)style);
        return style;
    }

    @NotNull
    public final PassCodeView.Style getFromAttributes(@NotNull AttributeSet attrs, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PassCodeView.Style defaultStyle = this.getDefault(context);
        SymbolView.Style defaultSymbolStyle = defaultStyle.getSymbolViewStyle();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PassCodeView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026eable.PassCodeView, 0, 0)");
        TypedArray typedArray2 = typedArray;
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$with = typedArray2;
        boolean bl3 = false;
        int symbolWidth = $this$with.getDimensionPixelSize(R.styleable.PassCodeView_symbol_width, defaultSymbolStyle.getWidth());
        int symbolHeight = $this$with.getDimensionPixelSize(R.styleable.PassCodeView_symbol_height, defaultSymbolStyle.getHeight());
        int symbolBackgroundColor = $this$with.getColor(R.styleable.PassCodeView_symbol_background_color, defaultSymbolStyle.getBackgroundColor());
        int symbolBorderColor = $this$with.getColor(R.styleable.PassCodeView_symbol_border_color, defaultSymbolStyle.getBorderColor());
        int symbolBorderWidth = $this$with.getDimensionPixelSize(R.styleable.PassCodeView_symbol_border_width, defaultSymbolStyle.getBorderWidth());
        int symbolTextColor = $this$with.getColor(R.styleable.PassCodeView_symbol_text_color, defaultSymbolStyle.getTextColor());
        int symbolTextSize = $this$with.getDimensionPixelSize(R.styleable.PassCodeView_symbol_text_size, defaultSymbolStyle.getTextSize());
        int symbolFontFamily = $this$with.getResourceId(R.styleable.PassCodeView_symbol_font_family, defaultSymbolStyle.getFontFamily());
        float cornerRadius2 = $this$with.getDimension(R.styleable.PassCodeView_symbol_border_corner_radius, defaultSymbolStyle.getBorderCornerRadius());
        int codeLength = $this$with.getInt(R.styleable.PassCodeView_pass_code_length, defaultStyle.getCodeLength());
        int symbolsSpacingPx = $this$with.getDimensionPixelSize(R.styleable.PassCodeView_symbols_spacing, defaultStyle.getSymbolsSpacing());
        $this$with.recycle();
        return new PassCodeView.Style(codeLength, symbolsSpacingPx, new SymbolView.Style(symbolWidth, symbolHeight, symbolBackgroundColor, symbolBorderColor, symbolBorderWidth, cornerRadius2, symbolTextColor, symbolTextSize, symbolFontFamily));
    }

    private PassCodeViewStyleUtils() {
    }

    static {
        PassCodeViewStyleUtils passCodeViewStyleUtils;
        INSTANCE = passCodeViewStyleUtils = new PassCodeViewStyleUtils();
    }
}

