/*
 * Decompiled with CFR 0.152.
 */
package com.getmati.mati_sdk.widgets;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.FontRes;
import androidx.annotation.Px;
import androidx.core.content.res.ResourcesCompat;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0001\u0018\u00002\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u001d\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J0\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0014J\u0018\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u000fH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/getmati/mati_sdk/widgets/SymbolView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "style", "Lcom/getmati/mati_sdk/widgets/SymbolView$Style;", "(Landroid/content/Context;Lcom/getmati/mati_sdk/widgets/SymbolView$Style;)V", "backgroundPaint", "Landroid/graphics/Paint;", "backgroundRect", "Landroid/graphics/RectF;", "borderPaint", "cornerRadius", "", "desiredH", "", "desiredW", "value", "", "symbol", "getSymbol", "()Ljava/lang/Character;", "setSymbol", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "textPaint", "textSize", "Landroid/util/Size;", "textSizePx", "calculateTextSize", "(Ljava/lang/Character;)Landroid/util/Size;", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "Style", "mati-sdk_release"})
@SuppressLint(value={"ViewConstructor"})
public final class SymbolView
extends View {
    @Nullable
    private Character symbol;
    private final int desiredW;
    private final int desiredH;
    private final int textSizePx;
    private final float cornerRadius;
    private final RectF backgroundRect;
    private Paint backgroundPaint;
    private Paint borderPaint;
    private final Paint textPaint;
    private Size textSize;

    @Nullable
    public final Character getSymbol() {
        return this.symbol;
    }

    public final void setSymbol(@Nullable Character value) {
        this.symbol = value;
        this.textSize = this.calculateTextSize(this.symbol);
        this.invalidate();
    }

    private final Size calculateTextSize(Character symbol) {
        Size size;
        Character c = symbol;
        if (c != null) {
            Character c2 = c;
            boolean bl = false;
            boolean bl2 = false;
            char it = c2.charValue();
            boolean bl3 = false;
            Rect textBounds = new Rect();
            this.textPaint.getTextBounds(String.valueOf(it), 0, 1, textBounds);
            size = new Size(textBounds.width(), textBounds.height());
        } else {
            size = new Size(0, 0);
        }
        return size;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = View.resolveSizeAndState((int)this.desiredW, (int)widthMeasureSpec, (int)0);
        int h = View.resolveSizeAndState((int)this.desiredH, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        float borderWidthHalf;
        super.onLayout(changed, left, top, right, bottom);
        this.backgroundRect.left = borderWidthHalf = this.borderPaint.getStrokeWidth() / (float)2;
        this.backgroundRect.top = borderWidthHalf;
        this.backgroundRect.right = (float)this.getMeasuredWidth() - borderWidthHalf;
        this.backgroundRect.bottom = (float)this.getMeasuredHeight() - borderWidthHalf;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        canvas.drawRoundRect(this.backgroundRect, this.cornerRadius, this.cornerRadius, this.backgroundPaint);
        canvas.drawRoundRect(this.backgroundRect, this.cornerRadius, this.cornerRadius, this.borderPaint);
        Object object = this.symbol;
        if (object == null || (object = String.valueOf(((Character)object).charValue())) == null) {
            object = "";
        }
        canvas.drawText((String)object, this.backgroundRect.width() / (float)2 + this.borderPaint.getStrokeWidth() / (float)2, this.backgroundRect.height() / (float)2 + (float)(this.textSize.getHeight() / 2) + this.borderPaint.getStrokeWidth() / (float)2, this.textPaint);
    }

    public SymbolView(@NotNull Context context, @NotNull Style style) {
        Paint $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        super(context);
        this.backgroundRect = new RectF();
        this.desiredW = style.getWidth();
        this.desiredH = style.getHeight();
        this.textSizePx = style.getTextSize();
        this.cornerRadius = style.getBorderCornerRadius();
        this.textSize = this.calculateTextSize(this.symbol);
        Paint paint2 = new Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint3 = paint2;
        SymbolView symbolView = this;
        boolean bl3 = false;
        $this$apply.setColor(style.getBackgroundColor());
        $this$apply.setStyle(Paint.Style.FILL);
        Unit unit = Unit.INSTANCE;
        symbolView.backgroundPaint = paint2;
        paint2 = new Paint();
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        symbolView = this;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setColor(style.getBorderColor());
        $this$apply.setStyle(Paint.Style.STROKE);
        $this$apply.setStrokeWidth((float)style.getBorderWidth());
        unit = Unit.INSTANCE;
        symbolView.borderPaint = paint2;
        paint2 = new Paint();
        bl = false;
        bl2 = false;
        $this$apply = paint2;
        symbolView = this;
        boolean bl5 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setColor(style.getTextColor());
        $this$apply.setTextSize((float)this.textSizePx);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        $this$apply.setTypeface(ResourcesCompat.getFont((Context)context, (int)style.getFontFamily()));
        unit = Unit.INSTANCE;
        symbolView.textPaint = paint2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B]\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0001\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003Jc\u0010\"\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u00032\b\b\u0003\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u00032\b\b\u0003\u0010\u000b\u001a\u00020\u00032\b\b\u0003\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/getmati/mati_sdk/widgets/SymbolView$Style;", "", "width", "", "height", "backgroundColor", "borderColor", "borderWidth", "borderCornerRadius", "", "textColor", "textSize", "fontFamily", "(IIIIIFIII)V", "getBackgroundColor", "()I", "getBorderColor", "getBorderCornerRadius", "()F", "getBorderWidth", "getFontFamily", "getHeight", "getTextColor", "getTextSize", "getWidth", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "mati-sdk_release"})
    public static final class Style {
        private final int width;
        private final int height;
        private final int backgroundColor;
        private final int borderColor;
        private final int borderWidth;
        private final float borderCornerRadius;
        private final int textColor;
        private final int textSize;
        private final int fontFamily;

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getBackgroundColor() {
            return this.backgroundColor;
        }

        public final int getBorderColor() {
            return this.borderColor;
        }

        public final int getBorderWidth() {
            return this.borderWidth;
        }

        public final float getBorderCornerRadius() {
            return this.borderCornerRadius;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final int getTextSize() {
            return this.textSize;
        }

        public final int getFontFamily() {
            return this.fontFamily;
        }

        public Style(@Px int width, @Px int height, @ColorInt int backgroundColor, @ColorInt int borderColor, @Px int borderWidth, float borderCornerRadius, @ColorInt int textColor, @Px int textSize, @FontRes int fontFamily) {
            this.width = width;
            this.height = height;
            this.backgroundColor = backgroundColor;
            this.borderColor = borderColor;
            this.borderWidth = borderWidth;
            this.borderCornerRadius = borderCornerRadius;
            this.textColor = textColor;
            this.textSize = textSize;
            this.fontFamily = fontFamily;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        public final int component3() {
            return this.backgroundColor;
        }

        public final int component4() {
            return this.borderColor;
        }

        public final int component5() {
            return this.borderWidth;
        }

        public final float component6() {
            return this.borderCornerRadius;
        }

        public final int component7() {
            return this.textColor;
        }

        public final int component8() {
            return this.textSize;
        }

        public final int component9() {
            return this.fontFamily;
        }

        @NotNull
        public final Style copy(@Px int width, @Px int height, @ColorInt int backgroundColor, @ColorInt int borderColor, @Px int borderWidth, float borderCornerRadius, @ColorInt int textColor, @Px int textSize, @FontRes int fontFamily) {
            return new Style(width, height, backgroundColor, borderColor, borderWidth, borderCornerRadius, textColor, textSize, fontFamily);
        }

        public static /* synthetic */ Style copy$default(Style style, int n, int n2, int n3, int n4, int n5, float f, int n6, int n7, int n8, int n9, Object object) {
            if ((n9 & 1) != 0) {
                n = style.width;
            }
            if ((n9 & 2) != 0) {
                n2 = style.height;
            }
            if ((n9 & 4) != 0) {
                n3 = style.backgroundColor;
            }
            if ((n9 & 8) != 0) {
                n4 = style.borderColor;
            }
            if ((n9 & 0x10) != 0) {
                n5 = style.borderWidth;
            }
            if ((n9 & 0x20) != 0) {
                f = style.borderCornerRadius;
            }
            if ((n9 & 0x40) != 0) {
                n6 = style.textColor;
            }
            if ((n9 & 0x80) != 0) {
                n7 = style.textSize;
            }
            if ((n9 & 0x100) != 0) {
                n8 = style.fontFamily;
            }
            return style.copy(n, n2, n3, n4, n5, f, n6, n7, n8);
        }

        @NotNull
        public String toString() {
            return "Style(width=" + this.width + ", height=" + this.height + ", backgroundColor=" + this.backgroundColor + ", borderColor=" + this.borderColor + ", borderWidth=" + this.borderWidth + ", borderCornerRadius=" + this.borderCornerRadius + ", textColor=" + this.textColor + ", textSize=" + this.textSize + ", fontFamily=" + this.fontFamily + ")";
        }

        public int hashCode() {
            return (((((((Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height)) * 31 + Integer.hashCode(this.backgroundColor)) * 31 + Integer.hashCode(this.borderColor)) * 31 + Integer.hashCode(this.borderWidth)) * 31 + Float.hashCode(this.borderCornerRadius)) * 31 + Integer.hashCode(this.textColor)) * 31 + Integer.hashCode(this.textSize)) * 31 + Integer.hashCode(this.fontFamily);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Style)) break block3;
                    Style style = (Style)object;
                    if (this.width != style.width || this.height != style.height || this.backgroundColor != style.backgroundColor || this.borderColor != style.borderColor || this.borderWidth != style.borderWidth || Float.compare(this.borderCornerRadius, style.borderCornerRadius) != 0 || this.textColor != style.textColor || this.textSize != style.textSize || this.fontFamily != style.fontFamily) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

