/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api;

import com.gettyimages.api.Constants;
import com.gettyimages.api.Credentials;
import com.gettyimages.api.Filters.AgeOfPeople;
import com.gettyimages.api.Filters.Compositions;
import com.gettyimages.api.Filters.EditorialSegment;
import com.gettyimages.api.Filters.EditorialVideoType;
import com.gettyimages.api.Filters.Ethnicity;
import com.gettyimages.api.Filters.FileType;
import com.gettyimages.api.Filters.FrameRate;
import com.gettyimages.api.Filters.GraphicalStyles;
import com.gettyimages.api.Filters.LicenseModel;
import com.gettyimages.api.Filters.NumberOfPeople;
import com.gettyimages.api.Filters.Orientation;
import com.gettyimages.api.Filters.ProductType;
import com.gettyimages.api.SdkException;
import com.gettyimages.api.WebHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;

public abstract class AbstractApiRequest<T> {
    protected String baseUrl;
    protected Credentials credentials;
    protected String method;
    protected String path;
    protected HttpEntity body;
    protected Map<String, Object> queryParams = new HashMap<String, Object>();
    protected Map<String, String> headers = new HashMap<String, String>();

    public AbstractApiRequest(Credentials credentials, String baseUrl) {
        this.credentials = credentials;
        this.baseUrl = baseUrl;
    }

    protected String executeAsync() throws SdkException {
        this.queryParams.forEach((k, v) -> {
            if (v instanceof List) {
                String result = String.join((CharSequence)",", (List)v);
                this.queryParams.put((String)k, result);
            } else if (v instanceof Integer) {
                this.queryParams.put((String)k, String.valueOf(v));
            } else if (v instanceof Boolean) {
                this.queryParams.put((String)k, String.valueOf(v));
            } else if (v instanceof EnumSet) {
                StringBuilder sb = new StringBuilder();
                for (Object item : (EnumSet)v) {
                    sb.append(item);
                    sb.append(",");
                }
                String result = sb.substring(0, sb.length() - 1);
                this.queryParams.put((String)k, result);
            }
        });
        WebHelper helper = new WebHelper(this.credentials, this.baseUrl);
        switch (this.method) {
            case "GET": {
                return helper.Get(this.queryParams, this.path, this.headers);
            }
            case "POST": {
                return helper.PostQuery(this.queryParams, this.path, this.body, this.headers);
            }
            case "PUT": {
                return helper.PutQuery(this.queryParams, this.path, this.body, this.headers);
            }
            case "DELETE": {
                return helper.DeleteQuery(this.queryParams, this.path, this.headers);
            }
        }
        throw new SdkException("No appropriate HTTP method found for this request.");
    }

    public void addAgeOfPeople(EnumSet<AgeOfPeople> ageOfPeople) {
        EnumSet values = this.queryParams.containsKey(Constants.AgeOfPeopleParameterName) ? (EnumSet)this.queryParams.get(Constants.AgeOfPeopleParameterName) : EnumSet.noneOf(AgeOfPeople.class);
        for (AgeOfPeople item : ageOfPeople) {
            values.add(item);
        }
        this.queryParams.put(Constants.AgeOfPeopleParameterName, values);
    }

    public void addArtists(Iterable<String> values) {
        List assets = this.queryParams.containsKey(Constants.ArtistParameterName) ? (List)this.queryParams.get(Constants.ArtistParameterName) : new ArrayList();
        for (String item : values) {
            assets.add(item);
        }
        this.queryParams.put(Constants.ArtistParameterName, assets);
    }

    public void addCollectionCodes(Iterable<String> values) {
        List assets = this.queryParams.containsKey(Constants.CollectionCodesParameterName) ? (List)this.queryParams.get(Constants.CollectionCodesParameterName) : new ArrayList();
        for (String item : values) {
            assets.add(item);
        }
        this.queryParams.put(Constants.CollectionCodesParameterName, assets);
    }

    public void addCompositions(EnumSet<Compositions> compositions) {
        EnumSet values = this.queryParams.containsKey(Constants.CompositionsParameterName) ? (EnumSet)this.queryParams.get(Constants.CompositionsParameterName) : EnumSet.noneOf(Compositions.class);
        for (Compositions item : compositions) {
            values.add(item);
        }
        this.queryParams.put(Constants.CompositionsParameterName, values);
    }

    public void addEditorialSegments(EnumSet<EditorialSegment> editorialSegments) {
        EnumSet values = this.queryParams.containsKey(Constants.EditorialSegmentsParameterName) ? (EnumSet)this.queryParams.get(Constants.EditorialSegmentsParameterName) : EnumSet.noneOf(EditorialSegment.class);
        for (EditorialSegment item : editorialSegments) {
            values.add(item);
        }
        this.queryParams.put(Constants.EditorialSegmentsParameterName, values);
    }

    public void addEditorialVideoTypes(EnumSet<EditorialVideoType> editorialVideoTypes) {
        EnumSet values = this.queryParams.containsKey(Constants.EditorialVideoTypeParameterName) ? (EnumSet)this.queryParams.get(Constants.EditorialVideoTypeParameterName) : EnumSet.noneOf(EditorialVideoType.class);
        for (EditorialVideoType item : editorialVideoTypes) {
            values.add(item);
        }
        this.queryParams.put(Constants.EditorialVideoTypeParameterName, values);
    }

    public void addEntityUris(Iterable<String> values) {
        List assets = this.queryParams.containsKey(Constants.EntityUriParameterName) ? (List)this.queryParams.get(Constants.EntityUriParameterName) : new ArrayList();
        for (String item : values) {
            String i = String.valueOf(item);
            assets.add(i);
        }
        this.queryParams.put(Constants.EntityUriParameterName, assets);
    }

    public void addEthnicity(EnumSet<Ethnicity> ethnicity) {
        EnumSet values = this.queryParams.containsKey(Constants.EthnicityParameterName) ? (EnumSet)this.queryParams.get(Constants.EthnicityParameterName) : EnumSet.noneOf(Ethnicity.class);
        for (Ethnicity item : ethnicity) {
            values.add(item);
        }
        this.queryParams.put(Constants.EthnicityParameterName, values);
    }

    public void addEventIds(Iterable<Integer> values) {
        List assets = this.queryParams.containsKey(Constants.EventIdsParameterName) ? (List)this.queryParams.get(Constants.EventIdsParameterName) : new ArrayList();
        for (Integer item : values) {
            String i = String.valueOf(item);
            assets.add(i);
        }
        this.queryParams.put(Constants.EventIdsParameterName, assets);
    }

    public void addResponseFields(Iterable<String> values) {
        List assets = this.queryParams.containsKey(Constants.FieldsString) ? (List)this.queryParams.get(Constants.FieldsString) : new ArrayList();
        for (String item : values) {
            assets.add(item);
        }
        this.queryParams.put(Constants.FieldsString, assets);
    }

    public void addFileTypes(EnumSet<FileType> fileTypes) {
        EnumSet values = this.queryParams.containsKey(Constants.FileTypesParameterName) ? (EnumSet)this.queryParams.get(Constants.FileTypesParameterName) : EnumSet.noneOf(FileType.class);
        for (FileType item : fileTypes) {
            values.add(item);
        }
        this.queryParams.put(Constants.FileTypesParameterName, values);
    }

    public void addFrameRates(EnumSet<FrameRate> frameRates) {
        EnumSet values = this.queryParams.containsKey(Constants.FrameRateParameterName) ? (EnumSet)this.queryParams.get(Constants.FrameRateParameterName) : EnumSet.noneOf(FrameRate.class);
        for (FrameRate item : frameRates) {
            values.add(item);
        }
        this.queryParams.put(Constants.FrameRateParameterName, values);
    }

    public void addGraphicalStyles(EnumSet<GraphicalStyles> graphicalStyles) {
        EnumSet values = this.queryParams.containsKey(Constants.GraphicalStylesString) ? (EnumSet)this.queryParams.get(Constants.GraphicalStylesString) : EnumSet.noneOf(GraphicalStyles.class);
        for (GraphicalStyles item : graphicalStyles) {
            values.add(item);
        }
        this.queryParams.put(Constants.GraphicalStylesString, values);
    }

    public void addKeywordIds(Iterable<Integer> values) {
        List assets = this.queryParams.containsKey(Constants.KeywordIdsParameterName) ? (List)this.queryParams.get(Constants.KeywordIdsParameterName) : new ArrayList();
        for (Integer item : values) {
            String i = String.valueOf(item);
            assets.add(i);
        }
        this.queryParams.put(Constants.KeywordIdsParameterName, assets);
    }

    public void addLicenseModels(EnumSet<LicenseModel> licenseModels) {
        EnumSet values = this.queryParams.containsKey(Constants.LicenseModelsParameterName) ? (EnumSet)this.queryParams.get(Constants.LicenseModelsParameterName) : EnumSet.noneOf(LicenseModel.class);
        for (LicenseModel item : licenseModels) {
            values.add(item);
        }
        this.queryParams.put(Constants.LicenseModelsParameterName, values);
    }

    public void addNumberOfPeople(EnumSet<NumberOfPeople> numberOfPeople) {
        EnumSet values = this.queryParams.containsKey(Constants.NumberOfPeopleParameterName) ? (EnumSet)this.queryParams.get(Constants.NumberOfPeopleParameterName) : EnumSet.noneOf(NumberOfPeople.class);
        for (NumberOfPeople item : numberOfPeople) {
            values.add(item);
        }
        this.queryParams.put(Constants.NumberOfPeopleParameterName, values);
    }

    public void addOrientations(EnumSet<Orientation> orientations) {
        EnumSet values = this.queryParams.containsKey(Constants.OrientationsParameterName) ? (EnumSet)this.queryParams.get(Constants.OrientationsParameterName) : EnumSet.noneOf(Orientation.class);
        for (Orientation item : orientations) {
            values.add(item);
        }
        this.queryParams.put(Constants.OrientationsParameterName, values);
    }

    public void addProductTypes(EnumSet<ProductType> productTypes) {
        EnumSet values = this.queryParams.containsKey(Constants.ProductTypesParameterName) ? (EnumSet)this.queryParams.get(Constants.ProductTypesParameterName) : EnumSet.noneOf(ProductType.class);
        for (ProductType item : productTypes) {
            values.add(item);
        }
        this.queryParams.put(Constants.ProductTypesParameterName, values);
    }

    public void addSpecificPeople(Iterable<String> values) {
        List assets = this.queryParams.containsKey(Constants.SpecificPeopleParameterName) ? (List)this.queryParams.get(Constants.SpecificPeopleParameterName) : new ArrayList();
        for (String item : values) {
            assets.add(item);
        }
        this.queryParams.put(Constants.SpecificPeopleParameterName, assets);
    }
}

