/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api;

import com.gettyimages.api.Credentials;
import com.gettyimages.api.CustomRequest.CustomRequest;
import com.gettyimages.api.Downloads.DownloadImages;
import com.gettyimages.api.Downloads.DownloadVideos;
import com.gettyimages.api.Images.Images;
import com.gettyimages.api.Search.SearchImages;
import com.gettyimages.api.Search.SearchImagesCreative;
import com.gettyimages.api.Search.SearchImagesEditorial;
import com.gettyimages.api.Search.SearchVideos;
import com.gettyimages.api.Search.SearchVideosCreative;
import com.gettyimages.api.Search.SearchVideosEditorial;
import com.gettyimages.api.Videos.Videos;

public class ApiClient {
    public static String Version = "2.1.1";
    private String Slash = "/";
    private Credentials credentials;
    private static String baseUrl = "https://api.gettyimages.com/v3";

    private ApiClient(String apiKey, String apiSecret) {
        this.credentials = Credentials.GetInstance(apiKey, apiSecret, this.GetOAuthBaseUrl());
    }

    private ApiClient(String apiKey, String apiSecret, String userName, String userPassword) {
        this.credentials = Credentials.GetInstance(apiKey, apiSecret, userName, userPassword, this.GetOAuthBaseUrl());
    }

    public static ApiClient GetApiClientWithClientCredentials(String apiKey, String apiSecret) {
        return new ApiClient(apiKey, apiSecret);
    }

    public static ApiClient GetApiClientWithResourceOwnerCredentials(String apiKey, String apiSecret, String userName, String password) {
        return new ApiClient(apiKey, apiSecret, userName, password);
    }

    private String GetOAuthBaseUrl() {
        String oAuthBaseUrl = baseUrl.substring(0, baseUrl.lastIndexOf(this.Slash));
        return oAuthBaseUrl;
    }

    public Images images() {
        return Images.GetInstance(this.credentials, baseUrl);
    }

    public Videos videos() {
        return Videos.GetInstance(this.credentials, baseUrl);
    }

    public SearchImages searchimages() {
        return SearchImages.GetInstance(this.credentials, baseUrl);
    }

    public SearchImagesCreative searchimagescreative() {
        return SearchImagesCreative.GetInstance(this.credentials, baseUrl);
    }

    public SearchImagesEditorial searchimageseditorial() {
        return SearchImagesEditorial.GetInstance(this.credentials, baseUrl);
    }

    public SearchVideos searchvideos() {
        return SearchVideos.GetInstance(this.credentials, baseUrl);
    }

    public SearchVideosCreative searchvideoscreative() {
        return SearchVideosCreative.GetInstance(this.credentials, baseUrl);
    }

    public SearchVideosEditorial searchvideoseditorial() {
        return SearchVideosEditorial.GetInstance(this.credentials, baseUrl);
    }

    public DownloadVideos downloadvideos() {
        return DownloadVideos.GetInstance(this.credentials, baseUrl);
    }

    public DownloadImages downloadimages() {
        return DownloadImages.GetInstance(this.credentials, baseUrl);
    }

    public CustomRequest customrequest() {
        return CustomRequest.GetInstance(this.credentials, baseUrl);
    }
}

