/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api;

import com.gettyimages.api.CredentialType;
import com.gettyimages.api.HttpClientErrorException;
import com.gettyimages.api.HttpSystemErrorException;
import com.gettyimages.api.SdkException;
import com.gettyimages.api.StringHelper;
import com.gettyimages.api.Token;
import com.gettyimages.api.WebHelper;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class Credentials {
    private String ClientIdKey = "client_id";
    private String ClientSecretKey = "client_secret";
    private String UsernameKey = "username";
    private String PasswordKey = "password";
    private String ClientCredentialsValue = "client_credentials";
    private String GrantTypeKey = "grant_type";
    private String Oauth2TokenPath = "/oauth2/token";
    private String RefreshTokenKey = "refresh_token";
    private String baseUrl;
    private Token accessToken;
    public String ApiKey;
    public String ApiSecret;
    public CredentialType CredentialType;
    public String RefreshToken;
    public String UserName;
    public String UserPassword;

    private Credentials(String apiKey, String apiSecret, String baseUrl) {
        this.baseUrl = baseUrl;
        this.CredentialType = com.gettyimages.api.CredentialType.ClientCredentials;
        this.ApiKey = apiKey;
        this.ApiSecret = apiSecret;
    }

    private Credentials(String apiKey, String apiSecret, String refreshToken, String baseUrl) {
        this.baseUrl = baseUrl;
        this.CredentialType = com.gettyimages.api.CredentialType.RefreshToken;
        this.ApiKey = apiKey;
        this.ApiSecret = apiSecret;
        this.RefreshToken = refreshToken;
    }

    private Credentials(String apiKey, String apiSecret, String userName, String userPassword, String baseUrl) {
        this.baseUrl = baseUrl;
        this.CredentialType = com.gettyimages.api.CredentialType.ResourceOwner;
        this.ApiKey = apiKey;
        this.ApiSecret = apiSecret;
        this.UserName = userName;
        this.UserPassword = userPassword;
    }

    public static Credentials GetInstance(String apiKey, String apiSecret, String baseUrl) {
        return new Credentials(apiKey, apiSecret, baseUrl);
    }

    public static Credentials GetInstance(String apiKey, String apiSecret, String refreshToken, String baseUrl) {
        return new Credentials(apiKey, apiSecret, refreshToken, baseUrl);
    }

    public static Credentials GetInstance(String apiKey, String apiSecret, String userName, String userPassword, String baseUrl) {
        return new Credentials(apiKey, apiSecret, userName, userPassword, baseUrl);
    }

    public Token GetAccessToken() throws SdkException {
        block8: {
            block7: {
                Calendar now;
                block6: {
                    now = Calendar.getInstance();
                    now.add(12, 5);
                    if (this.CredentialType == com.gettyimages.api.CredentialType.ClientCredentials) break block6;
                    if (this.CredentialType == com.gettyimages.api.CredentialType.ResourceOwner) break block6;
                    if (this.CredentialType != com.gettyimages.api.CredentialType.RefreshToken) break block7;
                }
                if (this.accessToken == null || this.accessToken.getExpiration().compareTo(now.getTime()) < 0) break block8;
            }
            return this.accessToken;
        }
        WebHelper helper = new WebHelper(this, this.baseUrl);
        String response = this.PostForm(this.GetCredentialsDictionary(), this.Oauth2TokenPath);
        try {
            JSONObject json = new JSONObject(response);
            this.accessToken = new Token();
            this.accessToken.setTokenString(json.getString("access_token"));
            if (this.CredentialType == com.gettyimages.api.CredentialType.ResourceOwner) {
                this.accessToken.setRefreshTokenString(json.getString("refresh_token"));
            }
            Calendar expiration = Calendar.getInstance();
            expiration.add(13, json.getInt("expires_in"));
            this.accessToken.setExpiration(expiration.getTime());
            return this.accessToken;
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new HttpSystemErrorException((Exception)((Object)e));
        }
    }

    public Map<String, String> GetCredentialsDictionary() {
        Hashtable<String, String> dict = new Hashtable<String, String>();
        if (!StringHelper.isNullOrEmpty(this.ApiKey)) {
            dict.put(this.ClientIdKey, this.ApiKey);
        }
        if (!StringHelper.isNullOrEmpty(this.ApiSecret)) {
            dict.put(this.ClientSecretKey, this.ApiSecret);
        }
        if (!StringHelper.isNullOrEmpty(this.UserName)) {
            dict.put(this.UsernameKey, this.UserName);
        }
        if (!StringHelper.isNullOrEmpty(this.UserPassword)) {
            dict.put(this.PasswordKey, this.UserPassword);
        }
        if (!StringHelper.isNullOrEmpty(this.RefreshToken)) {
            dict.put(this.RefreshTokenKey, this.RefreshToken);
        }
        switch (this.CredentialType) {
            case ClientCredentials: {
                dict.put(this.GrantTypeKey, this.ClientCredentialsValue);
                break;
            }
            case ResourceOwner: {
                dict.put(this.GrantTypeKey, this.PasswordKey);
                break;
            }
            case RefreshToken: {
                dict.put(this.GrantTypeKey, this.RefreshTokenKey);
            }
        }
        return dict;
    }

    public String PostForm(Map<String, String> formParameters, String path) throws SdkException {
        try {
            URL url = new URL(this.baseUrl + path);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url.toString());
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : formParameters.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey().toString(), entry.getValue().toString()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 400 && statusCode <= 499) {
                throw new HttpClientErrorException(statusLine);
            }
            if (statusCode >= 500 && statusCode <= 599) {
                throw new HttpSystemErrorException(statusLine);
            }
            HttpEntity responseEntity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)responseEntity);
            return content;
        }
        catch (SdkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpSystemErrorException(e);
        }
    }
}

