/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api.Downloads;

import com.gettyimages.api.AbstractApiRequest;
import com.gettyimages.api.Constants;
import com.gettyimages.api.Credentials;
import com.gettyimages.api.Filters.FileType;
import com.gettyimages.api.Filters.ProductType;
import com.gettyimages.api.SdkException;

public class DownloadImages
extends AbstractApiRequest {
    private String MustSpecifyAtLeastOneImageIdMessage = "Must specify at least one image id.";
    private String DownloadsPathString = "/downloads/images/";
    private String assetId;

    private DownloadImages(Credentials credentials, String baseUrl) {
        super(credentials, baseUrl);
    }

    public static DownloadImages GetInstance(Credentials credentials, String baseUrl) {
        return new DownloadImages(credentials, baseUrl);
    }

    @Override
    public String executeAsync() throws SdkException {
        if (this.assetId == null || this.assetId.length() == 0) {
            throw new SdkException(this.MustSpecifyAtLeastOneImageIdMessage);
        }
        this.queryParams.put(Constants.AutoDownloadParameterName, false);
        this.method = "POST";
        this.path = this.DownloadsPathString + this.assetId;
        return super.executeAsync();
    }

    public DownloadImages withId(String value) {
        this.assetId = value;
        return this;
    }

    public DownloadImages withAcceptLanguage(String value) {
        this.headers.put(Constants.AcceptLanguageString, value);
        return this;
    }

    public DownloadImages withFileType(FileType value) {
        this.queryParams.put(Constants.FileTypeParameterName, value);
        return this;
    }

    public DownloadImages withHeight(String value) {
        this.queryParams.put(Constants.HeightParameterName, value);
        return this;
    }

    public DownloadImages withProductId(Integer value) {
        this.queryParams.put(Constants.ProductIdParameterName, value);
        return this;
    }

    public DownloadImages withProductType(ProductType value) {
        this.queryParams.put(Constants.ProductTypeParameterName, value);
        return this;
    }
}

