/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api.Images;

import com.gettyimages.api.AbstractApiRequest;
import com.gettyimages.api.Constants;
import com.gettyimages.api.Credentials;
import com.gettyimages.api.SdkException;
import java.util.ArrayList;
import java.util.List;

public class Images
extends AbstractApiRequest {
    private String MustSpecifyAtLeastOneImageIdMessage = "Must specify at least one image id.";
    private String ImagesPath = "/images";
    private List<String> imageIds = new ArrayList<String>();

    private Images(Credentials credentials, String baseUrl) {
        super(credentials, baseUrl);
    }

    public static Images GetInstance(Credentials credentials, String baseUrl) {
        return new Images(credentials, baseUrl);
    }

    @Override
    public String executeAsync() throws SdkException {
        if (this.imageIds.isEmpty()) {
            throw new SdkException(this.MustSpecifyAtLeastOneImageIdMessage);
        }
        this.method = "GET";
        this.path = this.ImagesPath;
        if (this.imageIds.size() > 1) {
            this.queryParams.put(Constants.IdsParameterName, this.imageIds);
        } else {
            String id = String.join((CharSequence)",", this.imageIds);
            this.path = this.ImagesPath + "/" + id;
        }
        return super.executeAsync();
    }

    public Images withId(String val) {
        this.imageIds.add(val);
        return this;
    }

    public Images withIds(List<String> ids) {
        this.imageIds.addAll(ids);
        return this;
    }

    public Images withAcceptLanguage(String value) {
        this.headers.put(Constants.AcceptLanguageString, value);
        return this;
    }

    public Images withResponseFields(Iterable<String> values) {
        this.addResponseFields(values);
        return this;
    }
}

