/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api.Videos;

import com.gettyimages.api.AbstractApiRequest;
import com.gettyimages.api.Constants;
import com.gettyimages.api.Credentials;
import com.gettyimages.api.SdkException;
import java.util.ArrayList;
import java.util.List;

public class Videos
extends AbstractApiRequest {
    private String MustSpecifyAtLeastOneImageIdMessage = "Must specify at least one image id.";
    private String VideosPath = "/videos";
    private List<String> videoIds = new ArrayList<String>();

    private Videos(Credentials credentials, String baseUrl) {
        super(credentials, baseUrl);
    }

    public static Videos GetInstance(Credentials credentials, String baseUrl) {
        return new Videos(credentials, baseUrl);
    }

    @Override
    public String executeAsync() throws SdkException {
        if (this.videoIds.isEmpty()) {
            throw new SdkException(this.MustSpecifyAtLeastOneImageIdMessage);
        }
        this.method = "GET";
        this.path = this.VideosPath;
        if (this.videoIds.size() > 1) {
            this.queryParams.put(Constants.IdsParameterName, this.videoIds);
        } else {
            String id = String.join((CharSequence)",", this.videoIds);
            this.path = this.VideosPath + "/" + id;
        }
        return super.executeAsync();
    }

    public Videos withId(String val) {
        this.videoIds.add(val);
        return this;
    }

    public Videos withIds(List<String> ids) {
        this.videoIds.addAll(ids);
        return this;
    }

    public Videos withAcceptLanguage(String value) {
        this.headers.put(Constants.AcceptLanguageString, value);
        return this;
    }

    public Videos withResponseFields(Iterable<String> values) {
        this.addResponseFields(values);
        return this;
    }
}

