/*
 * Decompiled with CFR 0.152.
 */
package com.gettyimages.api;

import com.gettyimages.api.ApiClient;
import com.gettyimages.api.Credentials;
import com.gettyimages.api.SdkException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class WebHelper {
    protected String baseUrl;
    protected Credentials credentials;

    public WebHelper(Credentials credentials, String baseUrl) {
        this.credentials = credentials;
        this.baseUrl = baseUrl;
    }

    public String Get(Map queryParams, String path, Map headers) throws SdkException {
        try {
            String query = this.BuildQuery(queryParams);
            URL url = new URL(this.baseUrl + path + "?" + query);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpGet httpGet = new HttpGet(url.toString());
            this.addHeaders((HttpRequest)httpGet);
            headers.forEach((k, v) -> httpGet.addHeader(String.valueOf(k), String.valueOf(v)));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)responseEntity);
            return content;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "{null}";
    }

    public String PostQuery(Map queryParams, String path, HttpEntity body, Map headers) throws SdkException {
        try {
            String query = this.BuildQuery(queryParams);
            URL url = new URL(this.baseUrl + path + "?" + query);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url.toString());
            this.addHeaders((HttpRequest)httpPost);
            headers.forEach((k, v) -> httpPost.addHeader(String.valueOf(k), String.valueOf(v)));
            if (body != null) {
                httpPost.addHeader("content-type", "application/json");
                httpPost.setEntity(body);
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String content = EntityUtils.toString((HttpEntity)responseEntity);
            return content;
        }
        catch (MalformedURLException ex) {
            String string = ex.toString();
        }
        catch (IOException ex) {
            String string = ex.toString();
        }
        return null;
    }

    public String PutQuery(Map queryParams, String path, HttpEntity body, Map headers) throws SdkException {
        try {
            HttpResponse response;
            HttpEntity responseEntity;
            String query = this.BuildQuery(queryParams);
            URL url = new URL(this.baseUrl + path + "?" + query);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPut httpPut = new HttpPut(url.toString());
            this.addHeaders((HttpRequest)httpPut);
            headers.forEach((k, v) -> httpPut.addHeader(String.valueOf(k), String.valueOf(v)));
            if (body != null) {
                httpPut.addHeader("content-type", "application/json");
                httpPut.setEntity(body);
            }
            String content = (responseEntity = (response = httpClient.execute((HttpUriRequest)httpPut)).getEntity()) != null ? EntityUtils.toString((HttpEntity)responseEntity) : "{}";
            return content;
        }
        catch (MalformedURLException ex) {
            String string = ex.toString();
        }
        catch (IOException ex) {
            String string = ex.toString();
        }
        return null;
    }

    public String DeleteQuery(Map queryParams, String path, Map headers) throws SdkException {
        try {
            String query = this.BuildQuery(queryParams);
            URL url = new URL(this.baseUrl + path + "?" + query);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpDelete httpDelete = new HttpDelete(url.toString());
            this.addHeaders((HttpRequest)httpDelete);
            headers.forEach((k, v) -> httpDelete.addHeader(String.valueOf(k), String.valueOf(v)));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpDelete);
            HttpEntity responseEntity = response.getEntity();
            String content = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity) : "{}";
            return content;
        }
        catch (MalformedURLException ex) {
            String string = ex.toString();
        }
        catch (IOException ex) {
            String string = ex.toString();
        }
        return null;
    }

    private void addHeaders(HttpRequest request) throws SdkException {
        switch (this.credentials.CredentialType) {
            case ApiKey: {
                request.addHeader("Api-Key", this.credentials.ApiKey);
                break;
            }
            case ClientCredentials: 
            case ResourceOwner: {
                request.addHeader("Api-Key", this.credentials.ApiKey);
                request.addHeader("Authorization", "Bearer " + this.credentials.GetAccessToken().getTokenString());
            }
        }
        request.addHeader("User-Agent", this.getUserAgent());
    }

    private String getUserAgent() {
        String httpAgentString = "";
        Properties properties = System.getProperties();
        String httpAgent = System.getProperty("http.agent");
        if (httpAgent != null) {
            httpAgentString = httpAgent.replace(")", "").replace(" (", "; ");
        } else {
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            String javaVersion = System.getProperty("java.version");
            httpAgentString = String.format("%s; %s; Java %s", osName, osArch, javaVersion);
        }
        String userAgentString = String.format("GettyImagesSDK/%s (%s)", ApiClient.Version, httpAgentString);
        return userAgentString;
    }

    private String BuildQuery(Map<?, ?> queryParams) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : queryParams.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(String.format("%s=%s", WebHelper.urlEncodeUTF8(entry.getKey().toString()), WebHelper.urlEncodeUTF8(entry.getValue().toString())));
        }
        return sb.toString();
    }

    static String urlEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

