/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.buffer;

import com.gettyio.core.util.Time;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class ChunkPool {
    private final long totalMemory;
    private final ReentrantLock lock = new ReentrantLock();
    private final int tinySize = 128;
    private final Deque<ByteBuffer> tinyFree = new ArrayDeque<ByteBuffer>();
    private final int smallSize = 512;
    private final Deque<ByteBuffer> smallFree = new ArrayDeque<ByteBuffer>();
    private final int mediumSize = 1024;
    private final Deque<ByteBuffer> mediumFree = new ArrayDeque<ByteBuffer>();
    private final int largeSize = 2048;
    private final Deque<ByteBuffer> largeFree = new ArrayDeque<ByteBuffer>();
    private final Deque<Condition> waiters = new ArrayDeque<Condition>();
    private long availableMemory;
    private final Time time;
    private boolean direct;

    public ChunkPool(long memory, Time time, boolean direct) {
        this.totalMemory = memory;
        this.availableMemory = memory;
        this.time = time;
        this.direct = direct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size, long maxTimeToBlockMs) throws InterruptedException, TimeoutException {
        if ((long)size > this.totalMemory) {
            throw new IllegalArgumentException("Attempt to allocate " + size + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
        }
        this.lock.lock();
        try {
            int freeListSize;
            if (size <= 128) {
                size = 128;
                if (!this.tinyFree.isEmpty()) {
                    ByteBuffer byteBuffer = this.tinyFree.pollFirst();
                    return byteBuffer;
                }
            }
            if (size > 128 && size <= 512) {
                size = 512;
                if (!this.smallFree.isEmpty()) {
                    ByteBuffer byteBuffer = this.smallFree.pollFirst();
                    return byteBuffer;
                }
            }
            if (size > 512 && size <= 1024) {
                size = 1024;
                if (!this.mediumFree.isEmpty()) {
                    ByteBuffer byteBuffer = this.mediumFree.pollFirst();
                    return byteBuffer;
                }
            }
            if (size > 1024 && size <= 2048) {
                size = 2048;
                if (!this.largeFree.isEmpty()) {
                    ByteBuffer byteBuffer = this.largeFree.pollFirst();
                    return byteBuffer;
                }
            }
            if (this.availableMemory + (long)(freeListSize = this.tinySize * this.tinyFree.size() + this.smallSize * this.smallFree.size() + this.mediumSize * this.mediumFree.size() + this.largeSize * this.largeFree.size()) >= (long)size) {
                this.freeUp(size);
                this.availableMemory -= (long)size;
                this.lock.unlock();
                ByteBuffer byteBuffer = this.direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
                return byteBuffer;
            }
            int accumulated = 0;
            ByteBuffer buffer = null;
            Condition moreMemory = this.lock.newCondition();
            long remainingTimeToBlockNs = TimeUnit.MILLISECONDS.toNanos(maxTimeToBlockMs);
            this.waiters.addLast(moreMemory);
            while (accumulated < size) {
                long timeNs;
                boolean waitingTimeElapsed;
                long startWaitNs = this.time.nanoseconds();
                try {
                    waitingTimeElapsed = !moreMemory.await(remainingTimeToBlockNs, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    this.waiters.remove(moreMemory);
                    throw e;
                }
                finally {
                    long endWaitNs = this.time.nanoseconds();
                    timeNs = Math.max(0L, endWaitNs - startWaitNs);
                }
                if (waitingTimeElapsed) {
                    this.waiters.remove(moreMemory);
                    throw new TimeoutException("Failed to allocate memory within the configured max blocking time " + maxTimeToBlockMs + " ms.");
                }
                remainingTimeToBlockNs -= timeNs;
                if (accumulated == 0 && size <= this.tinySize && !this.tinyFree.isEmpty()) {
                    buffer = this.tinyFree.pollFirst();
                    accumulated = size;
                    continue;
                }
                if (accumulated == 0 && size <= this.smallSize && !this.smallFree.isEmpty()) {
                    buffer = this.smallFree.pollFirst();
                    accumulated = size;
                    continue;
                }
                if (accumulated == 0 && size <= this.mediumSize && !this.mediumFree.isEmpty()) {
                    buffer = this.mediumFree.pollFirst();
                    accumulated = size;
                    continue;
                }
                if (accumulated == 0 && size <= this.largeSize && !this.largeFree.isEmpty()) {
                    buffer = this.largeFree.pollFirst();
                    accumulated = size;
                    continue;
                }
                this.freeUp(size - accumulated);
                int got = (int)Math.min((long)(size - accumulated), this.availableMemory);
                this.availableMemory -= (long)got;
                accumulated += got;
            }
            Condition removed = this.waiters.removeFirst();
            if (removed != moreMemory) {
                throw new IllegalStateException("Wrong condition: this shouldn't happen.");
            }
            if (!(this.availableMemory <= 0L && this.tinyFree.isEmpty() && this.smallFree.isEmpty() && this.mediumFree.isEmpty() && this.largeFree.isEmpty() || this.waiters.isEmpty())) {
                this.waiters.peekFirst().signal();
            }
            this.lock.unlock();
            if (buffer == null) {
                ByteBuffer byteBuffer = this.direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
                return byteBuffer;
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void freeUp(int size) {
        while (!(this.largeFree.isEmpty() && this.mediumFree.isEmpty() && this.smallFree.isEmpty() && this.tinyFree.isEmpty() || this.availableMemory >= (long)size)) {
            if (!this.largeFree.isEmpty()) {
                this.availableMemory += (long)this.largeFree.pollLast().capacity();
                continue;
            }
            if (!this.mediumFree.isEmpty()) {
                this.availableMemory += (long)this.mediumFree.pollLast().capacity();
                continue;
            }
            if (!this.smallFree.isEmpty()) {
                this.availableMemory += (long)this.smallFree.pollLast().capacity();
                continue;
            }
            if (this.tinyFree.isEmpty()) continue;
            this.availableMemory += (long)this.tinyFree.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size) {
        this.lock.lock();
        try {
            buffer.clear();
            if (size == 128 && size == buffer.capacity()) {
                this.tinyFree.add(buffer);
            } else if (size == 512 && size == buffer.capacity()) {
                this.smallFree.add(buffer);
            } else if (size == 1024 && size == buffer.capacity()) {
                this.mediumFree.add(buffer);
            } else if (size == 2048 && size == buffer.capacity()) {
                this.largeFree.add(buffer);
            } else {
                this.availableMemory += (long)size;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        if (null == buffer) {
            return;
        }
        this.deallocate(buffer, buffer.capacity());
    }

    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory + (long)(this.tinySize * this.tinyFree.size()) + (long)(this.smallSize * this.smallFree.size()) + (long)(this.mediumSize * this.mediumFree.size()) + (long)(this.largeSize * this.largeFree.size());
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        if (this.waiters != null) {
            this.waiters.clear();
        }
        if (this.tinyFree != null) {
            this.tinyFree.clear();
        }
        if (this.smallFree != null) {
            this.smallFree.clear();
        }
        if (this.mediumFree != null) {
            this.mediumFree.clear();
        }
        if (this.largeFree != null) {
            this.largeFree.clear();
        }
    }

    public long totalMemory() {
        return this.totalMemory;
    }

    Deque<Condition> waiters() {
        return this.waiters;
    }
}

