/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.channel.starter;

import com.gettyio.core.buffer.ChunkPool;
import com.gettyio.core.channel.AioChannel;
import com.gettyio.core.channel.SocketChannel;
import com.gettyio.core.channel.config.ClientConfig;
import com.gettyio.core.channel.internal.ReadCompletionHandler;
import com.gettyio.core.channel.internal.WriteCompletionHandler;
import com.gettyio.core.channel.starter.AioStarter;
import com.gettyio.core.channel.starter.ConnectHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import com.gettyio.core.pipeline.ChannelPipeline;
import com.gettyio.core.util.ThreadPool;
import com.gettyio.core.util.Time;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ThreadFactory;

public class AioClientStarter
extends AioStarter {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(AioClientStarter.class);
    private ClientConfig clientConfig = new ClientConfig();
    private SocketChannel aioChannel;

    public AioClientStarter(String host, int port) {
        this.clientConfig.setHost(host);
        this.clientConfig.setPort(port);
    }

    public AioClientStarter(ClientConfig clientConfig) {
        if (null == clientConfig.getHost() || "".equals(clientConfig.getHost())) {
            throw new NullPointerException("The connection host is null.");
        }
        if (0 == clientConfig.getPort()) {
            throw new NullPointerException("The connection port is null.");
        }
        this.clientConfig = clientConfig;
    }

    public AioClientStarter channelInitializer(ChannelPipeline channelPipeline) {
        this.channelPipeline = channelPipeline;
        return this;
    }

    public final void start() throws Exception {
        try {
            this.start0(null);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            throw new Exception(e);
        }
    }

    public final void start(ConnectHandler connectHandler) {
        try {
            this.start0(connectHandler);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            connectHandler.onFailed(e);
            return;
        }
    }

    private void start0(ConnectHandler connectHandler) throws Exception {
        if (this.channelPipeline == null) {
            throw new NullPointerException("The ChannelPipeline is null.");
        }
        this.workerThreadPool = new ThreadPool(0, 1);
        this.chunkPool = new ChunkPool(this.clientConfig.getClientChunkSize().intValue(), new Time(), this.clientConfig.isDirect());
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable target) {
                return new Thread(target);
            }
        });
        this.startTcp(this.asynchronousChannelGroup, connectHandler);
    }

    private void startTcp(AsynchronousChannelGroup asynchronousChannelGroup, final ConnectHandler connectHandler) throws Exception {
        final AsynchronousSocketChannel socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
        if (this.clientConfig.getSocketOptions() != null) {
            for (Map.Entry<SocketOption<Object>, Object> entry : this.clientConfig.getSocketOptions().entrySet()) {
                socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
            }
        }
        socketChannel.connect(new InetSocketAddress(this.clientConfig.getHost(), this.clientConfig.getPort()), socketChannel, new CompletionHandler<Void, AsynchronousSocketChannel>(){

            @Override
            public void completed(Void result, AsynchronousSocketChannel attachment) {
                LOGGER.info("connect aio server success");
                AioClientStarter.this.aioChannel = new AioChannel(socketChannel, AioClientStarter.this.clientConfig, new ReadCompletionHandler(AioClientStarter.this.workerThreadPool), new WriteCompletionHandler(), AioClientStarter.this.chunkPool, AioClientStarter.this.channelPipeline);
                if (null != connectHandler) {
                    if (null != AioClientStarter.this.aioChannel.getSslHandler()) {
                        AioClientStarter.this.aioChannel.setSslHandshakeCompletedListener(new IHandshakeCompletedListener(){

                            @Override
                            public void onComplete() {
                                LOGGER.info("Ssl Handshake Completed");
                                connectHandler.onCompleted(AioClientStarter.this.aioChannel);
                            }
                        });
                    } else {
                        connectHandler.onCompleted(AioClientStarter.this.aioChannel);
                    }
                }
                AioClientStarter.this.aioChannel.starRead();
            }

            @Override
            public void failed(Throwable exc, AsynchronousSocketChannel attachment) {
                LOGGER.error("connect server error", exc);
                if (null != connectHandler) {
                    connectHandler.onFailed(exc);
                }
            }
        });
    }

    public final void shutdown() {
        this.showdown0(false);
    }

    private void showdown0(boolean flag) {
        if (this.aioChannel != null) {
            this.aioChannel.close(flag);
            this.aioChannel = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
            this.asynchronousChannelGroup = null;
        }
        LOGGER.info("getty shutdown at " + new Date());
    }

    @Deprecated
    public SocketChannel getAioChannel() {
        if (this.aioChannel != null) {
            if (this.aioChannel.getSslHandler() != null) {
                if (this.aioChannel.getSslHandler().getSslService().getSsl().isHandshakeCompleted()) {
                    return this.aioChannel;
                }
                this.aioChannel.close();
                throw new RuntimeException("The SSL handshcke is not yet complete");
            }
            return this.aioChannel;
        }
        throw new NullPointerException("AioChannel was null");
    }
}

