/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl;

import com.gettyio.core.handler.ssl.SslConfig;
import com.gettyio.core.handler.ssl.sslfacade.DefaultTaskHandler;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.handler.ssl.sslfacade.ISSLFacade;
import com.gettyio.core.handler.ssl.sslfacade.ISSLListener;
import com.gettyio.core.handler.ssl.sslfacade.ISessionClosedListener;
import com.gettyio.core.handler.ssl.sslfacade.SSLFacade;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslService {
    private static String PROTOCOL = "TLSv1.2";
    private SSLContext sslContext;
    private SslConfig config;
    private ISSLFacade ssl;

    public SslService(SslConfig config) {
        this.config = config;
        this.init(config);
    }

    public SslService(SslConfig config, String protocolVersion) {
        PROTOCOL = protocolVersion;
        this.config = config;
        this.init(config);
    }

    private void init(SslConfig config) {
        try {
            TrustManager[] trustManagers;
            KeyManager[] keyManagers = null;
            if (config.getKeyFile() != null) {
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(new FileInputStream(config.getKeyFile()), config.getKeystorePassword().toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, config.getKeyPassword().toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            if (config.getTrustFile() != null) {
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(new FileInputStream(config.getTrustFile()), config.getTrustPassword().toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            } else {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            }
            this.sslContext = SSLContext.getInstance(PROTOCOL);
            this.sslContext.init(keyManagers, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createSSLFacade(IHandshakeCompletedListener handshakeCompletedListener2, ISSLListener SSLListener2, ISessionClosedListener sessionClosedListener2) {
        this.ssl = new SSLFacade(this.sslContext, this.config.isClientMode(), this.config.isClientAuth(), new DefaultTaskHandler());
        this.ssl.setHandshakeCompletedListener(handshakeCompletedListener2);
        this.ssl.setSSLListener(SSLListener2);
        this.ssl.setCloseListener(sessionClosedListener2);
    }

    public void beginHandshake(IHandshakeCompletedListener handshakeCompletedListener2) {
        try {
            if (null != handshakeCompletedListener2) {
                this.ssl.setHandshakeCompletedListener(handshakeCompletedListener2);
            }
            this.ssl.beginHandshake();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void beginHandshake() {
        try {
            this.ssl.beginHandshake();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ISSLFacade getSsl() {
        return this.ssl;
    }
}

