/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl.sslfacade;

import com.gettyio.core.handler.ssl.sslfacade.AppendableBuffer;
import com.gettyio.core.handler.ssl.sslfacade.BufferType;
import com.gettyio.core.handler.ssl.sslfacade.BufferUtils;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;

class Buffers {
    private ByteBuffer _peerApp;
    private ByteBuffer _myApp;
    private ByteBuffer _peerNet;
    private ByteBuffer _myNet;
    private final AppendableBuffer _unwrapCache;
    private final SSLSession _session;

    public Buffers(SSLSession session) {
        this._session = session;
        this.allocate();
        this._unwrapCache = new AppendableBuffer();
    }

    private void debug(String msg) {
        System.out.println("[Buffers]" + msg);
        System.out.flush();
    }

    ByteBuffer get(BufferType t) {
        ByteBuffer result = null;
        switch (t) {
            case IN_PLAIN: {
                result = this._peerApp;
                break;
            }
            case IN_CIPHER: {
                result = this._peerNet;
                break;
            }
            case OUT_PLAIN: {
                result = this._myApp;
                break;
            }
            case OUT_CIPHER: {
                result = this._myNet;
            }
        }
        return result;
    }

    void grow(BufferType t) {
        switch (t) {
            case IN_PLAIN: {
                this.assign(t, this.grow(t, this._session.getApplicationBufferSize()));
                break;
            }
            case IN_CIPHER: {
                this.assign(t, this.grow(t, this._session.getPacketBufferSize()));
                break;
            }
            case OUT_PLAIN: {
                break;
            }
            case OUT_CIPHER: {
                this.assign(t, this.grow(t, this._session.getPacketBufferSize()));
            }
        }
    }

    ByteBuffer grow(BufferType b, int recommendedBufferSize) {
        ByteBuffer originalBuffer = this.get(b);
        ByteBuffer newBuffer = ByteBuffer.allocate(recommendedBufferSize);
        this.debug("grow buffer " + originalBuffer + " to " + newBuffer);
        BufferUtils.copy(originalBuffer, newBuffer);
        return newBuffer;
    }

    void prepareForUnwrap(ByteBuffer data) {
        this.clear(BufferType.IN_CIPHER, BufferType.IN_PLAIN);
        if (data != null) {
            ByteBuffer newBuffer = this.growIfNecessary(BufferType.IN_CIPHER, data.limit());
            newBuffer.put(data);
            newBuffer.flip();
        }
    }

    void prepareForWrap(ByteBuffer data) {
        this.clear(BufferType.OUT_PLAIN, BufferType.OUT_CIPHER);
        if (data != null) {
            ByteBuffer newBuffer = this.growIfNecessary(BufferType.OUT_PLAIN, data.limit());
            newBuffer.put(data);
            newBuffer.flip();
        }
    }

    ByteBuffer prependCached(ByteBuffer data) {
        if (data == null) {
            return this._unwrapCache.get();
        }
        ByteBuffer result = this._unwrapCache.append(data);
        result.rewind();
        return result;
    }

    void cache(ByteBuffer data) {
        if (data != null) {
            this._unwrapCache.set(data);
        }
    }

    void clearCache() {
        this._unwrapCache.clear();
    }

    boolean isCacheEmpty() {
        return !this._unwrapCache.hasRemaining();
    }

    private void allocate() {
        int applicationBufferSize = this._session.getApplicationBufferSize();
        int packetBufferSize = this._session.getPacketBufferSize();
        this._peerApp = ByteBuffer.allocate(applicationBufferSize);
        this._myApp = ByteBuffer.allocate(applicationBufferSize);
        this._peerNet = ByteBuffer.allocate(packetBufferSize);
        this._myNet = ByteBuffer.allocate(packetBufferSize);
    }

    private void clear(BufferType source, BufferType destination) {
        this.get(source).clear();
        this.get(destination).clear();
    }

    private void assign(BufferType t, ByteBuffer b) {
        switch (t) {
            case IN_PLAIN: {
                this._peerApp = b;
                break;
            }
            case IN_CIPHER: {
                this._peerNet = b;
                break;
            }
            case OUT_PLAIN: {
                this._myApp = b;
                break;
            }
            case OUT_CIPHER: {
                this._myNet = b;
            }
        }
    }

    private void resetSize(BufferType t, int size) {
        ByteBuffer newBuffer = ByteBuffer.allocate(size);
        BufferUtils.copy(this.get(t), newBuffer);
        this.assign(t, newBuffer);
    }

    private ByteBuffer growIfNecessary(BufferType t, int size) {
        ByteBuffer b = this.get(t);
        if (b.position() + size > b.capacity()) {
            this.resetSize(t, b.limit() + size);
        }
        return this.get(t);
    }
}

