/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl.sslfacade;

import com.gettyio.core.handler.ssl.sslfacade.Buffers;
import com.gettyio.core.handler.ssl.sslfacade.Handshaker;
import com.gettyio.core.handler.ssl.sslfacade.IHandshakeCompletedListener;
import com.gettyio.core.handler.ssl.sslfacade.ISSLFacade;
import com.gettyio.core.handler.ssl.sslfacade.ISSLListener;
import com.gettyio.core.handler.ssl.sslfacade.ISessionClosedListener;
import com.gettyio.core.handler.ssl.sslfacade.ITaskHandler;
import com.gettyio.core.handler.ssl.sslfacade.SSLLog;
import com.gettyio.core.handler.ssl.sslfacade.Worker;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLFacade
implements ISSLFacade {
    private static final String TAG = "SSLFascade";
    private Handshaker _handshaker;
    private IHandshakeCompletedListener _hcl;
    private final Worker _worker;
    private boolean _clientMode;

    public SSLFacade(SSLContext context, boolean client, boolean clientAuthRequired, ITaskHandler taskHandler) {
        String who = client ? "client" : "server";
        SSLEngine engine = this.makeSSLEngine(context, client, clientAuthRequired);
        engine.setEnabledProtocols(new String[]{context.getProtocol()});
        Buffers buffers = new Buffers(engine.getSession());
        this._worker = new Worker(who, engine, buffers);
        this._handshaker = new Handshaker(client, this._worker, taskHandler);
        this._clientMode = client;
    }

    private void debug(String message, String ... args) {
        SSLLog.debug(TAG, message, args);
    }

    @Override
    public boolean isClientMode() {
        return this._clientMode;
    }

    @Override
    public void setHandshakeCompletedListener(IHandshakeCompletedListener hcl) {
        this._hcl = hcl;
        this.attachCompletionListener();
    }

    @Override
    public void setSSLListener(ISSLListener l) {
        this._worker.setSSLListener(l);
    }

    @Override
    public void setCloseListener(ISessionClosedListener l) {
        this._worker.setSessionClosedListener(l);
    }

    @Override
    public void beginHandshake() throws SSLException {
        this._handshaker.begin();
    }

    @Override
    public boolean isHandshakeCompleted() {
        return this._handshaker == null || this._handshaker.isFinished();
    }

    @Override
    public void encrypt(ByteBuffer plainData) throws SSLException {
        this._worker.wrap(plainData);
    }

    @Override
    public void decrypt(ByteBuffer encryptedData) throws SSLException {
        SSLEngineResult result = this._worker.unwrap(encryptedData);
        this.debug("decrypt: unwrap result=" + result, new String[0]);
        this._handshaker.handleUnwrapResult(result);
    }

    @Override
    public void close() {
        this._worker.close(true);
    }

    @Override
    public boolean isCloseCompleted() {
        return this._worker.isCloseCompleted();
    }

    @Override
    public void terminate() {
        this._worker.close(false);
    }

    private void attachCompletionListener() {
        this._handshaker.addCompletedListener(new IHandshakeCompletedListener(){

            @Override
            public void onComplete() {
                if (SSLFacade.this._hcl != null) {
                    SSLFacade.this._hcl.onComplete();
                    SSLFacade.this._hcl = null;
                }
            }
        });
    }

    private SSLEngine makeSSLEngine(SSLContext context, boolean client, boolean clientAuthRequired) {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        engine.setNeedClientAuth(clientAuthRequired);
        return engine;
    }
}

