/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.handler.ssl.sslfacade;

import com.gettyio.core.handler.ssl.sslfacade.BufferType;
import com.gettyio.core.handler.ssl.sslfacade.BufferUtils;
import com.gettyio.core.handler.ssl.sslfacade.Buffers;
import com.gettyio.core.handler.ssl.sslfacade.ISSLListener;
import com.gettyio.core.handler.ssl.sslfacade.ISessionClosedListener;
import com.gettyio.core.handler.ssl.sslfacade.SSLLog;
import com.gettyio.core.handler.ssl.sslfacade.defaulthandlers.DefaultOnCloseListener;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

class Worker {
    private static final String TAG = "Worker";
    private final SSLEngine _engine;
    private final Buffers _buffers;
    private ISSLListener _sslListener;
    private ISessionClosedListener _sessionClosedListener = new DefaultOnCloseListener();
    private String who;

    Worker(String debugTag, SSLEngine engine, Buffers buffers) {
        this._engine = engine;
        this._buffers = buffers;
        this.who = "[Worker:" + debugTag + "]";
    }

    private void debug(String msg, String ... args) {
        SSLLog.debug(TAG, msg, args);
    }

    void setSessionClosedListener(ISessionClosedListener scl) {
        this._sessionClosedListener = scl;
    }

    void beginHandshake() throws SSLException {
        this._engine.beginHandshake();
    }

    SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this._engine.getHandshakeStatus();
    }

    Runnable getDelegatedTask() {
        return this._engine.getDelegatedTask();
    }

    SSLEngineResult wrap(ByteBuffer plainData) throws SSLException {
        this._buffers.prepareForWrap(plainData);
        SSLEngineResult result = this.doWrap();
        this.emitWrappedData(result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                throw new RuntimeException("BUFFER_UNDERFLOW while wrapping!");
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.OUT_CIPHER);
                if (plainData == null || !plainData.hasRemaining()) break;
                plainData.position(result.bytesConsumed());
                ByteBuffer remainingData = BufferUtils.slice(plainData);
                this.wrap(remainingData);
                break;
            }
            case OK: {
                break;
            }
            case CLOSED: {
                this._sessionClosedListener.onSessionClosed();
            }
        }
        return result;
    }

    SSLEngineResult unwrap(ByteBuffer encryptedData) throws SSLException {
        ByteBuffer allEncryptedData = this._buffers.prependCached(encryptedData);
        this._buffers.prepareForUnwrap(allEncryptedData);
        SSLEngineResult result = this.doUnwrap();
        this.debug("unwrap: doUnwrap result: " + result, new String[0]);
        allEncryptedData.position(result.bytesConsumed());
        ByteBuffer unprocessedEncryptedData = BufferUtils.slice(allEncryptedData);
        this.emitPlainData(result);
        switch (result.getStatus()) {
            case BUFFER_UNDERFLOW: {
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
            case BUFFER_OVERFLOW: {
                this._buffers.grow(BufferType.IN_PLAIN);
                if (unprocessedEncryptedData == null) {
                    throw new RuntimeException("Worker.unwrap had buffer_overflow but all data was consumed!!");
                }
                this.unwrap(unprocessedEncryptedData);
                break;
            }
            case OK: {
                if (unprocessedEncryptedData == null) {
                    this._buffers.clearCache();
                    break;
                }
                this._buffers.cache(unprocessedEncryptedData);
                break;
            }
        }
        if (!this._buffers.isCacheEmpty() && result.getStatus() == SSLEngineResult.Status.OK && result.bytesConsumed() > 0) {
            this.debug("Still data in cahce", new String[0]);
            result = this.unwrap(ByteBuffer.allocate(0));
        }
        return result;
    }

    void setSSLListener(ISSLListener SSLListener2) {
        this._sslListener = SSLListener2;
    }

    void handleEnOfSession(SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this._sessionClosedListener.onSessionClosed();
        }
    }

    void close(boolean properly) {
        this._engine.closeOutbound();
        try {
            if (properly) {
                this.wrap(null);
            }
            this._engine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    boolean isCloseCompleted() {
        return this._engine.isOutboundDone();
    }

    boolean pendingUnwrap() {
        return !this._buffers.isCacheEmpty();
    }

    private void emitWrappedData(SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalCipherBuffer = this._buffers.get(BufferType.OUT_CIPHER);
            this._sslListener.onWrappedData(Worker.makeExternalBuffer(internalCipherBuffer));
        }
    }

    private void emitPlainData(SSLEngineResult result) {
        if (result.bytesProduced() > 0) {
            ByteBuffer internalPlainBuffer = this._buffers.get(BufferType.IN_PLAIN);
            this._sslListener.onPlainData(Worker.makeExternalBuffer(internalPlainBuffer));
        }
    }

    private SSLEngineResult doWrap() throws SSLException {
        ByteBuffer plainText = this._buffers.get(BufferType.OUT_PLAIN);
        ByteBuffer cipherText = this._buffers.get(BufferType.OUT_CIPHER);
        this.debug("Wrap buffer: " + plainText + " into buffer: " + cipherText, new String[0]);
        return this._engine.wrap(plainText, cipherText);
    }

    private SSLEngineResult doUnwrap() throws SSLException {
        ByteBuffer cipherText = this._buffers.get(BufferType.IN_CIPHER);
        ByteBuffer plainText = this._buffers.get(BufferType.IN_PLAIN);
        this.debug("doUnwrap: on buffer " + cipherText, new String[0]);
        return this._engine.unwrap(cipherText, plainText);
    }

    private static ByteBuffer makeExternalBuffer(ByteBuffer internalBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(internalBuffer.position());
        internalBuffer.flip();
        BufferUtils.copy(internalBuffer, newBuffer);
        return newBuffer;
    }
}

