/*
 * Decompiled with CFR 0.152.
 */
package com.gettyio.core.util;

import com.gettyio.core.logging.InternalLogger;
import com.gettyio.core.logging.InternalLoggerFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(DateTimeUtil.class);

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = df.format(new Date());
        return time;
    }

    public static String getCurrentDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(new Date());
        return time;
    }

    public static Long getCurrentLongTime() {
        Long time = System.currentTimeMillis();
        return time;
    }

    public static String convertDateToString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(date);
    }

    public static String convertLongToString(Long date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df.format(new Date(date));
    }

    public static Date convertStringToDate(String time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return df.parse(time);
        }
        catch (ParseException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public static String getSpecifiedDayBefore(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd HH:mm:ss").parse(specifiedDay);
        }
        catch (ParseException e) {
            LOGGER.error(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
        return dayBefore;
    }

    public static String getSpecifiedDayAfter(String specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = null;
        try {
            date = new SimpleDateFormat("yy-MM-dd HH:mm:ss").parse(specifiedDay);
        }
        catch (ParseException e) {
            LOGGER.error(e);
        }
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + 1);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
        return dayAfter;
    }

    public static String getSpecifiedDayBefore(Date specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = specifiedDay;
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        String dayBefore = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
        return dayBefore;
    }

    public static String getSpecifiedDayAfter(Date specifiedDay) {
        Calendar c = Calendar.getInstance();
        Date date = specifiedDay;
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + 1);
        String dayAfter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(c.getTime());
        return dayAfter;
    }

    public static Long getTimesMorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }
}

