/*
 * Decompiled with CFR 0.152.
 */
package com.ggasoftware.indigo;

import com.ggasoftware.indigo.IndigoException;
import com.ggasoftware.indigo.IndigoLib;
import com.ggasoftware.indigo.IndigoObject;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indigo {
    public static final int ABS = 1;
    public static final int OR = 2;
    public static final int AND = 3;
    public static final int EITHER = 4;
    public static final int UP = 5;
    public static final int DOWN = 6;
    public static final int CIS = 7;
    public static final int TRANS = 8;
    public static final int CHAIN = 9;
    public static final int RING = 10;
    public static final int ALLENE = 11;
    public static final int SINGLET = 101;
    public static final int DOUBLET = 102;
    public static final int TRIPLET = 103;
    public static final int RC_NOT_CENTER = -1;
    public static final int RC_UNMARKED = 0;
    public static final int RC_CENTER = 1;
    public static final int RC_UNCHANGED = 2;
    public static final int RC_MADE_OR_BROKEN = 4;
    public static final int RC_ORDER_CHANGED = 8;
    public static final int OS_WINDOWS = 1;
    public static final int OS_MACOS = 2;
    public static final int OS_LINUX = 3;
    public static final int OS_SOLARIS = 4;
    private boolean _session_released = false;
    private static int _os = 0;
    private static String _dllpath = "";
    private static IndigoLib _lib = null;
    private String _path;
    private long _sid;

    public Indigo(String path) {
        this._path = path;
        Indigo.loadIndigo(path);
        this._sid = _lib.indigoAllocSessionId();
    }

    public Indigo() {
        this(null);
    }

    public static int checkResult(Object obj, int result) {
        if (result < 0) {
            throw new IndigoException(obj, _lib.indigoGetLastError());
        }
        return result;
    }

    public static int checkResult(Object obj, Object obj2, int result) {
        if (result < 0) {
            throw new IndigoException(new Object[]{obj, obj2}, _lib.indigoGetLastError());
        }
        return result;
    }

    public static float checkResultFloat(Object obj, float result) {
        if (result < 0.0f) {
            throw new IndigoException(obj, _lib.indigoGetLastError());
        }
        return result;
    }

    public static String checkResultString(Object obj, Pointer result) {
        if (result == Pointer.NULL) {
            throw new IndigoException(obj, _lib.indigoGetLastError());
        }
        return result.getString(0L, false);
    }

    public static Pointer checkResultPointer(Object obj, Pointer result) {
        if (result == Pointer.NULL) {
            throw new IndigoException(obj, _lib.indigoGetLastError());
        }
        return result;
    }

    public static int[] toIntArray(Collection<Integer> collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] res = new int[collection.size()];
        int i = 0;
        for (Integer x : collection) {
            res[i++] = x;
        }
        return res;
    }

    public static float[] toFloatArray(Collection<Float> collection) {
        if (collection == null) {
            return new float[0];
        }
        float[] res = new float[collection.size()];
        int i = 0;
        for (Float x : collection) {
            res[i++] = x.floatValue();
        }
        return res;
    }

    private static String getHashString(InputStream input) throws NoSuchProviderException, NoSuchAlgorithmException, IOException {
        int nRead;
        String res = "";
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.reset();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = input.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        algorithm.update(buffer.toByteArray());
        byte[] hashArray = algorithm.digest();
        String tmp = "";
        for (int i = 0; i < hashArray.length; ++i) {
            tmp = Integer.toHexString(0xFF & hashArray[i]);
            res = tmp.length() == 1 ? res + "0" + tmp : res + tmp;
        }
        return res;
    }

    public static String extractFromJar(Class cls, String path, String filename) {
        String p;
        File dllfile;
        InputStream stream = cls.getResourceAsStream(path + "/" + filename);
        if (stream == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = stream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream is1 = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream is2 = new ByteArrayInputStream(baos.toByteArray());
            baos.close();
            String streamHashString = Indigo.getHashString(is1);
            ((InputStream)is1).close();
            String tmpdir_path = System.getProperty("java.io.tmpdir") + File.separator + "indigo" + streamHashString;
            File tmpdir = new File(tmpdir_path);
            if (!tmpdir.exists() && !tmpdir.mkdir()) {
                return null;
            }
            dllfile = new File(tmpdir.getAbsoluteFile() + File.separator + filename);
            if (!dllfile.exists()) {
                FileOutputStream outstream = new FileOutputStream(dllfile);
                byte[] buf = new byte[4096];
                while ((len = is2.read(buf)) > 0) {
                    outstream.write(buf, 0, len);
                }
                outstream.close();
                ((InputStream)is2).close();
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchProviderException e) {
            return null;
        }
        try {
            p = dllfile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
        String fullpath = p;
        return fullpath;
    }

    private static String getPathToBinary(String path, String filename) {
        if (path == null) {
            String res = Indigo.extractFromJar(Indigo.class, "/" + _dllpath, filename);
            if (res != null) {
                return res;
            }
            path = "lib";
        }
        path = path + File.separator + _dllpath + File.separator + filename;
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return path;
        }
    }

    private static synchronized void loadIndigo(String path) {
        if (_lib != null) {
            return;
        }
        if (_os == 3 || _os == 4) {
            _lib = (IndigoLib)Native.loadLibrary((String)Indigo.getPathToBinary(path, "libindigo.so"), IndigoLib.class);
        } else if (_os == 2) {
            _lib = (IndigoLib)Native.loadLibrary((String)Indigo.getPathToBinary(path, "libindigo.dylib"), IndigoLib.class);
        } else {
            if (new File(Indigo.getPathToBinary(path, "msvcr100.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcr100.dll"));
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (new File(Indigo.getPathToBinary(path, "msvcp100.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcp100.dll"));
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (new File(Indigo.getPathToBinary(path, "msvcr110.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcr110.dll"));
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (new File(Indigo.getPathToBinary(path, "msvcp110.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcp110.dll"));
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (new File(Indigo.getPathToBinary(path, "msvcr120.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcr120.dll"));
                }
                catch (UnsatisfiedLinkError e) {
                    // empty catch block
                }
            }
            if (new File(Indigo.getPathToBinary(path, "msvcp120.dll")).exists()) {
                try {
                    System.load(Indigo.getPathToBinary(path, "msvcp120.dll"));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            _lib = (IndigoLib)Native.loadLibrary((String)Indigo.getPathToBinary(path, "indigo.dll"), IndigoLib.class);
        }
    }

    public static String getPlatformDependentPath() {
        return _dllpath;
    }

    public boolean sessionReleased() {
        return this._session_released;
    }

    public static IndigoLib getLibrary() {
        return _lib;
    }

    public static int getOs() {
        String namestr = System.getProperty("os.name");
        if (namestr.matches("^Windows.*")) {
            return 1;
        }
        if (namestr.matches("^Mac OS.*")) {
            return 2;
        }
        if (namestr.matches("^Linux.*")) {
            return 3;
        }
        if (namestr.matches("^SunOS.*")) {
            return 4;
        }
        throw new Error("Operating system not recognized");
    }

    private static String getDllPath() {
        String path = "";
        switch (_os) {
            case 1: {
                path = path + "Win";
                break;
            }
            case 3: {
                path = path + "Linux";
                break;
            }
            case 4: {
                path = path + "Sun";
                break;
            }
            case 2: {
                path = path + "Mac";
                break;
            }
            default: {
                throw new Error("OS not set");
            }
        }
        path = path + "/";
        if (_os == 2) {
            String version = System.getProperty("os.version");
            int minorVersion = Integer.parseInt(version.split("\\.")[1]);
            Integer usingVersion = null;
            for (int i = minorVersion; i >= 5; --i) {
                if (Indigo.class.getResourceAsStream("/" + path + "10." + i + "/libindigo.dylib") == null) continue;
                usingVersion = i;
                break;
            }
            if (usingVersion == null) {
                throw new Error("Indigo cannot find native libraries for Mac OS X 10." + minorVersion);
            }
            path = path + "10." + usingVersion;
        } else if (_os == 4) {
            String model = System.getProperty("sun.arch.data.model");
            path = model.equals("32") ? path + "sparc32" : path + "sparc64";
        } else {
            String archstr = System.getProperty("os.arch");
            if (archstr.equals("x86") || archstr.equals("i386")) {
                path = path + "x86";
            } else if (archstr.equals("x86_64") || archstr.equals("amd64")) {
                path = path + "x64";
            } else {
                throw new Error("architecture not recognized");
            }
        }
        return path;
    }

    public String version() {
        return _lib.indigoVersion();
    }

    public int countReferences() {
        this.setSessionID();
        return Indigo.checkResult(this, _lib.indigoCountReferences());
    }

    public void setSessionID() {
        _lib.indigoSetSessionId(this._sid);
    }

    public void setOption(String option, String value) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOption(option, value));
    }

    public void setOption(String option, int value) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionInt(option, value));
    }

    public void setOption(String option, int x, int y) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionXY(option, x, y));
    }

    public void setOption(String option, float r, float g, float b) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionColor(option, r, g, b));
    }

    public void setOption(String option, boolean value) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionBool(option, value ? 1 : 0));
    }

    public void setOption(String option, float value) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionFloat(option, value));
    }

    public void setOption(String option, double value) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetOptionFloat(option, (float)value));
    }

    public IndigoObject writeFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoWriteFile(filename)));
    }

    public IndigoObject writeBuffer() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoWriteBuffer()));
    }

    public IndigoObject createMolecule() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateMolecule()));
    }

    public IndigoObject createQueryMolecule() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateQueryMolecule()));
    }

    public IndigoObject loadMolecule(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadMoleculeFromString(str)));
    }

    public IndigoObject loadMolecule(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadMoleculeFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadMoleculeFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadMoleculeFromFile(path)));
    }

    public IndigoObject loadQueryMolecule(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryMoleculeFromString(str)));
    }

    public IndigoObject loadQueryMolecule(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryMoleculeFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadQueryMoleculeFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryMoleculeFromFile(path)));
    }

    public IndigoObject loadSmarts(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadSmartsFromString(str)));
    }

    public IndigoObject loadSmarts(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadSmartsFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadSmartsFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadSmartsFromFile(path)));
    }

    public IndigoObject loadReaction(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionFromString(str)));
    }

    public IndigoObject loadReaction(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadReactionFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionFromFile(path)));
    }

    public IndigoObject loadQueryReaction(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryReactionFromString(str)));
    }

    public IndigoObject loadQueryReaction(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryReactionFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadQueryReactionFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadQueryReactionFromFile(path)));
    }

    public IndigoObject loadReactionSmarts(String str) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionSmartsFromString(str)));
    }

    public IndigoObject loadReactionSmarts(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionSmartsFromBuffer(buf, buf.length)));
    }

    public IndigoObject loadReactionSmartsFromFile(String path) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadReactionSmartsFromFile(path)));
    }

    public IndigoObject createReaction() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateReaction()));
    }

    public IndigoObject createQueryReaction() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateQueryReaction()));
    }

    public IndigoObject exactMatch(IndigoObject obj1, IndigoObject obj2, String flags) {
        IndigoObject[] parent;
        int match;
        this.setSessionID();
        if (flags == null) {
            flags = "";
        }
        if ((match = Indigo.checkResult(this, parent = new IndigoObject[]{obj1, obj2}, _lib.indigoExactMatch(obj1.self, obj2.self, flags))) == 0) {
            return null;
        }
        return new IndigoObject(this, match, parent);
    }

    public IndigoObject exactMatch(IndigoObject obj1, IndigoObject obj2) {
        return this.exactMatch(obj1, obj2, "");
    }

    public void setTautomerRule(int id, String beg, String end) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoSetTautomerRule(id, beg, end));
    }

    public void removeTautomerRule(int id) {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoRemoveTautomerRule(id));
    }

    public void clearTautomerRules() {
        this.setSessionID();
        Indigo.checkResult(this, _lib.indigoClearTautomerRules());
    }

    public float similarity(IndigoObject obj1, IndigoObject obj2) {
        return this.similarity(obj1, obj2, "");
    }

    public float similarity(IndigoObject obj1, IndigoObject obj2, String metrics) {
        if (metrics == null) {
            metrics = "";
        }
        this.setSessionID();
        Object[] guard = new Object[]{this, obj1, obj2};
        return Indigo.checkResultFloat(guard, _lib.indigoSimilarity(obj1.self, obj2.self, metrics));
    }

    public int commonBits(IndigoObject fingerprint1, IndigoObject fingerprint2) {
        this.setSessionID();
        Object[] guard = new Object[]{this, fingerprint1, fingerprint2};
        return Indigo.checkResult(guard, _lib.indigoCommonBits(fingerprint1.self, fingerprint2.self));
    }

    public IndigoObject unserialize(byte[] data) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoUnserialize(data, data.length)));
    }

    public IndigoObject createArray() {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateArray()));
    }

    public IndigoObject iterateSDFile(String filename) {
        this.setSessionID();
        int result = Indigo.checkResult(this, _lib.indigoIterateSDFile(filename));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result);
    }

    public IndigoObject iterateRDFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoIterateRDFile(filename)));
    }

    public IndigoObject iterateSmilesFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoIterateSmilesFile(filename)));
    }

    public IndigoObject iterateCMLFile(String filename) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoIterateCMLFile(filename)));
    }

    public IndigoObject substructureMatcher(IndigoObject target, String mode) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, target, _lib.indigoSubstructureMatcher(target.self, mode)), target);
    }

    public IndigoObject substructureMatcher(IndigoObject target) {
        return this.substructureMatcher(target, "");
    }

    public IndigoObject extractCommonScaffold(IndigoObject structures, String options) {
        this.setSessionID();
        int res = Indigo.checkResult(this, structures, _lib.indigoExtractCommonScaffold(structures.self, options));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject extractCommonScaffold(Collection<IndigoObject> structures, String options) {
        return this.extractCommonScaffold(this.toIndigoArray(structures), options);
    }

    @Deprecated
    public IndigoObject decomposeMolecules(IndigoObject scaffold, IndigoObject structures) {
        this.setSessionID();
        Object[] guard = new Object[]{this, scaffold, structures};
        int res = Indigo.checkResult(guard, _lib.indigoDecomposeMolecules(scaffold.self, structures.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    @Deprecated
    public IndigoObject decomposeMolecules(IndigoObject scaffold, Collection<IndigoObject> structures) {
        return this.decomposeMolecules(scaffold, this.toIndigoArray(structures));
    }

    public IndigoObject createDecomposer(IndigoObject scaffold) {
        this.setSessionID();
        Object[] guard = new Object[]{this, scaffold};
        int res = Indigo.checkResult(guard, _lib.indigoCreateDecomposer(scaffold.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject reactionProductEnumerate(IndigoObject reaction, IndigoObject monomers) {
        this.setSessionID();
        Object[] guard = new Object[]{this, reaction, monomers};
        int res = Indigo.checkResult(guard, _lib.indigoReactionProductEnumerate(reaction.self, monomers.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public IndigoObject reactionProductEnumerate(IndigoObject reaction, Iterable<Iterable> monomers) {
        this.setSessionID();
        Object[] guard = new Object[]{this, reaction, monomers};
        IndigoObject monomersArrayArray = this.createArray();
        for (Iterable iter : monomers) {
            IndigoObject monomersArray = this.createArray();
            for (IndigoObject monomer : iter) {
                monomersArray.arrayAdd(monomer);
            }
            monomersArrayArray.arrayAdd(monomersArray);
        }
        int res = Indigo.checkResult(guard, _lib.indigoReactionProductEnumerate(reaction.self, monomersArrayArray.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this, res);
    }

    public void transform(IndigoObject reaction, IndigoObject monomer) {
        this.setSessionID();
        Object[] guard = new Object[]{this, reaction, monomer};
        Indigo.checkResult(guard, _lib.indigoTransform(reaction.self, monomer.self));
    }

    public IndigoObject createSaver(IndigoObject output, String format) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, output, _lib.indigoCreateSaver(output.self, format)), output);
    }

    public IndigoObject createFileSaver(String filename, String format) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoCreateFileSaver(filename, format)));
    }

    public void dbgBreakpoint() {
        this.setSessionID();
        _lib.indigoDbgBreakpoint();
    }

    public IndigoObject toIndigoArray(Collection<IndigoObject> coll) {
        this.setSessionID();
        IndigoObject arr = this.createArray();
        for (IndigoObject obj : coll) {
            arr.arrayAdd(obj);
        }
        return arr;
    }

    public String getUserSpecifiedPath() {
        return this._path;
    }

    public long getSid() {
        return this._sid;
    }

    public IndigoObject loadBuffer(byte[] buf) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadBuffer(buf, buf.length)));
    }

    public IndigoObject loadString(String string) {
        this.setSessionID();
        return new IndigoObject(this, Indigo.checkResult(this, _lib.indigoLoadString(string)));
    }

    public IndigoObject iterateSDF(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, _lib.indigoIterateSDF(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateRDF(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, _lib.indigoIterateRDF(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateCML(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, _lib.indigoIterateCML(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    public IndigoObject iterateSmiles(IndigoObject reader) {
        this.setSessionID();
        int result = Indigo.checkResult(this, _lib.indigoIterateSmiles(reader.self));
        if (result == 0) {
            return null;
        }
        return new IndigoObject(this, result, reader);
    }

    protected void finalize() throws Throwable {
        if (!this.sessionReleased()) {
            _lib.indigoReleaseSessionId(this._sid);
            this._session_released = true;
        }
        super.finalize();
    }

    static {
        _os = Indigo.getOs();
        _dllpath = Indigo.getDllPath();
    }
}

