/*
 * Decompiled with CFR 0.152.
 */
package com.ggasoftware.indigo;

import com.ggasoftware.indigo.Indigo;
import com.ggasoftware.indigo.IndigoException;
import com.ggasoftware.indigo.IndigoLib;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndigoObject
implements Iterator<IndigoObject>,
Iterable<IndigoObject> {
    public int self;
    protected Indigo dispatcher;
    private Object parent;
    protected IndigoLib _lib;

    public IndigoObject(Indigo dispatcher, int id) {
        this.dispatcher = dispatcher;
        this.self = id;
        this._lib = Indigo.getLibrary();
    }

    public IndigoObject(Indigo dispatcher, int id, Object parent) {
        this.dispatcher = dispatcher;
        this.self = id;
        this.parent = parent;
        this._lib = Indigo.getLibrary();
    }

    public Indigo getIndigo() {
        return this.dispatcher;
    }

    public void dispose() {
        if (this.self >= 0) {
            this.dispatcher.setSessionID();
            this._lib.indigoFree(this.self);
            this.self = -1;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.dispatcher.sessionReleased()) {
            this.dispose();
        }
        super.finalize();
    }

    public IndigoObject clone() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoClone(this.self)));
    }

    public String molfile() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoMolfile(this.self));
    }

    public void saveMolfile(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSaveMolfileToFile(this.self, filename));
    }

    public String cml() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoCml(this.self));
    }

    public void saveCml(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSaveCmlToFile(this.self, filename));
    }

    public byte[] mdlct() {
        this.dispatcher.setSessionID();
        IndigoObject buf = this.dispatcher.writeBuffer();
        Indigo.checkResult(this, this._lib.indigoSaveMDLCT(this.self, buf.self));
        return buf.toBuffer();
    }

    public void addReactant(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this._lib.indigoAddReactant(this.self, molecule.self));
    }

    public void addProduct(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this._lib.indigoAddProduct(this.self, molecule.self));
    }

    public void addCatalyst(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this._lib.indigoAddCatalyst(this.self, molecule.self));
    }

    public int countReactants() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountReactants(this.self));
    }

    public int countProducts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountProducts(this.self));
    }

    public int countCatalysts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountCatalysts(this.self));
    }

    public int countMolecules() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountMolecules(this.self));
    }

    public IndigoObject iterateAttachmentPoints(int order) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateAttachmentPoints(this.self, order)), this);
    }

    public IndigoObject iterateReactants() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateReactants(this.self)), this);
    }

    public IndigoObject iterateProducts() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateProducts(this.self)), this);
    }

    public IndigoObject iterateCatalysts() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateCatalysts(this.self)), this);
    }

    public IndigoObject iterateMolecules() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateMolecules(this.self)), this);
    }

    public String rxnfile() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoRxnfile(this.self));
    }

    public void saveRxnfile(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSaveRxnfileToFile(this.self, filename));
    }

    public void automap() {
        this.automap("");
    }

    public void automap(String mode) {
        if (mode == null) {
            mode = "";
        }
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAutomap(this.self, mode));
    }

    public int atomMappingNumber(IndigoObject reaction_atom) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, reaction_atom, this._lib.indigoGetAtomMappingNumber(this.self, reaction_atom.self));
    }

    public void setAtomMappingNumber(IndigoObject reaction_atom, int number) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, reaction_atom, this._lib.indigoSetAtomMappingNumber(this.self, reaction_atom.self, number));
    }

    public void clearAAM() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearAAM(this.self));
    }

    public void correctReactingCenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoCorrectReactingCenters(this.self));
    }

    public IndigoObject iterateAtoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateAtoms(this.self)), this);
    }

    public IndigoObject iteratePseudoatoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIteratePseudoatoms(this.self)), this);
    }

    public IndigoObject iterateRSites() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateRSites(this.self)), this);
    }

    public IndigoObject iterateStereocenters() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateStereocenters(this.self)), this);
    }

    public IndigoObject iterateAlleneCenters() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateAlleneCenters(this.self)), this);
    }

    public IndigoObject iterateRGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateRGroups(this.self)), this);
    }

    public IndigoObject iterateRGroupFragments() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateRGroupFragments(this.self)), this);
    }

    public int countAttachmentPoints() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountAttachmentPoints(this.self));
    }

    public boolean isPseudoatom() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIsPseudoatom(this.self)) == 1;
    }

    public boolean isRSite() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIsRSite(this.self)) == 1;
    }

    public int stereocenterType() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoStereocenterType(this.self));
    }

    public int stereocenterGroup() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoStereocenterGroup(this.self));
    }

    public int[] stereocenterPyramid() {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this._lib.indigoStereocenterPyramid(this.self));
        return ptr.getIntArray(0L, 4);
    }

    public void changeStereocenterType(int type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoChangeStereocenterType(this.self, type));
    }

    public void setStereocenterGroup(int group) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetStereocenterGroup(this.self, group));
    }

    public int singleAllowedRGroup() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoSingleAllowedRGroup(this.self));
    }

    public String symbol() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoSymbol(this.self));
    }

    public int degree() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoDegree(this.self));
    }

    public Integer charge() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this._lib.indigoGetCharge(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int reactingCenter(IndigoObject bond) {
        this.dispatcher.setSessionID();
        IntByReference res = new IntByReference();
        if (Indigo.checkResult(this, bond, this._lib.indigoGetReactingCenter(this.self, bond.self, res)) == 1) {
            return res.getValue();
        }
        throw new IndigoException(this, "reactingCenter(): unexpected result");
    }

    public void setReactingCenter(IndigoObject bond, int type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, bond, this._lib.indigoSetReactingCenter(this.self, bond.self, type));
    }

    public Integer explicitValence() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this._lib.indigoGetExplicitValence(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public Integer radicalElectrons() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this._lib.indigoGetRadicalElectrons(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public Integer radical() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this._lib.indigoGetRadical(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int atomicNumber() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoAtomicNumber(this.self));
    }

    public int isotope() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIsotope(this.self));
    }

    public int valence() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoValence(this.self));
    }

    public Integer countHydrogens() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this._lib.indigoCountHydrogens(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int countImplicitHydrogens() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountImplicitHydrogens(this.self));
    }

    public void resetCharge() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoResetCharge(this.self));
    }

    public void resetExplicitValence() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoResetExplicitValence(this.self));
    }

    public void resetRadical() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoResetRadical(this.self));
    }

    public void resetIsotope() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoResetIsotope(this.self));
    }

    public void setAttachmentPoint(int order) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetAttachmentPoint(this.self, order));
    }

    public void clearAttachmentPoints() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearAttachmentPoints(this.self));
    }

    public void removeConstraints(String type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRemoveConstraints(this.self, type));
    }

    public void addConstraint(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAddConstraint(this.self, type, value));
    }

    public void addConstraintNot(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAddConstraintNot(this.self, type, value));
    }

    public void addConstraintOr(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAddConstraintOr(this.self, type, value));
    }

    public void resetStereo() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoResetStereo(this.self));
    }

    public void invertStereo() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoInvertStereo(this.self));
    }

    public int countAtoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountAtoms(this.self));
    }

    public int countBonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountBonds(this.self));
    }

    public int countPseudoatoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountPseudoatoms(this.self));
    }

    public int countRSites() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountRSites(this.self));
    }

    public IndigoObject iterateBonds() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateBonds(this.self)), this);
    }

    public int bondOrder() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoBondOrder(this.self));
    }

    public int bondStereo() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoBondStereo(this.self));
    }

    public int topology() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoTopology(this.self));
    }

    public IndigoObject iterateNeighbors() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateNeighbors(this.self)), this);
    }

    public IndigoObject bond() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoBond(this.self)));
    }

    public IndigoObject getAtom(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetAtom(this.self, idx)), this);
    }

    public IndigoObject getMolecule(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetMolecule(this.self, idx)), this);
    }

    public IndigoObject getBond(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetBond(this.self, idx)), this);
    }

    public IndigoObject source() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoSource(this.self)));
    }

    public IndigoObject destination() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoDestination(this.self)));
    }

    public void clearCisTrans() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearCisTrans(this.self));
    }

    public void clearStereocenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearStereocenters(this.self));
    }

    public void clearAlleneCenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearAlleneCenters(this.self));
    }

    public int countStereocenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountStereocenters(this.self));
    }

    public int countAlleneCenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountAlleneCenters(this.self));
    }

    public int resetSymmetricCisTrans() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoResetSymmetricCisTrans(this.self));
    }

    public int resetSymmetricStereocenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoResetSymmetricStereocenters(this.self));
    }

    public int markEitherCisTrans() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoMarkEitherCisTrans(this.self));
    }

    public int markStereobonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoMarkStereobonds(this.self));
    }

    public int validateChirality() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoValidateChirality(this.self));
    }

    public IndigoObject addAtom(String symbol) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAddAtom(this.self, symbol)), this);
    }

    public IndigoObject resetAtom(String symbol) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoResetAtom(this.self, symbol)), this);
    }

    public IndigoObject addRSite(String name) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAddRSite(this.self, name)), this);
    }

    public IndigoObject setRSite(String name) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoSetRSite(this.self, name)), this);
    }

    public void setCharge(int charge) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetCharge(this.self, charge));
    }

    public void setRadical(int radical) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetRadical(this.self, radical));
    }

    public void setExplicitValence(int valence) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetExplicitValence(this.self, valence));
    }

    public void setIsotope(int isotope) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetIsotope(this.self, isotope));
    }

    public void setImplicitHCount(int hcount) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetImplicitHCount(this.self, hcount));
    }

    public IndigoObject addBond(IndigoObject atom, int order) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAddBond(this.self, atom.self, order)), atom);
    }

    public void setBondOrder(int order) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetBondOrder(this.self, order));
    }

    public IndigoObject merge(IndigoObject other) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, other, this._lib.indigoMerge(this.self, other.self)), this);
    }

    public void highlight() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoHighlight(this.self));
    }

    public void unhighlight() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoUnhighlight(this.self));
    }

    public boolean isHighlighted() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIsHighlighted(this.self)) == 1;
    }

    public int countComponents() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountComponents(this.self));
    }

    public int componentIndex() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoComponentIndex(this.self));
    }

    public IndigoObject iterateComponents() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateComponents(this.self)), this);
    }

    public IndigoObject component(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoComponent(this.self, index)), this);
    }

    public int countSSSR() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountSSSR(this.self));
    }

    public IndigoObject iterateSSSR() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateSSSR(this.self)), this);
    }

    public IndigoObject iterateSubtrees(int min_vertices, int max_vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateSubtrees(this.self, min_vertices, max_vertices)), this);
    }

    public IndigoObject iterateRings(int min_vertices, int max_vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateRings(this.self, min_vertices, max_vertices)), this);
    }

    public IndigoObject iterateEdgeSubmolecules(int min_edges, int max_edges) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateEdgeSubmolecules(this.self, min_edges, max_edges)), this);
    }

    public int countHeavyAtoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountHeavyAtoms(this.self));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String grossFormula() {
        this.dispatcher.setSessionID();
        int gf = -1;
        try {
            String result;
            gf = Indigo.checkResult(this, this._lib.indigoGrossFormula(this.self));
            String string = result = Indigo.checkResultString(this, this._lib.indigoToString(gf));
            return string;
        }
        finally {
            this._lib.indigoFree(gf);
        }
    }

    public float molecularWeight() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultFloat(this, this._lib.indigoMolecularWeight(this.self));
    }

    public float mostAbundantMass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultFloat(this, this._lib.indigoMostAbundantMass(this.self));
    }

    public float monoisotopicMass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultFloat(this, this._lib.indigoMonoisotopicMass(this.self));
    }

    public String canonicalSmiles() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoCanonicalSmiles(this.self));
    }

    public String layeredCode() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoLayeredCode(this.self));
    }

    public boolean hasCoord() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoHasCoord(this.self)) == 1;
    }

    public boolean hasZCoord() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoHasZCoord(this.self)) == 1;
    }

    public boolean isChiral() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIsChiral(this.self)) == 1;
    }

    public float[] xyz() {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this._lib.indigoXYZ(this.self));
        return ptr.getFloatArray(0L, 3);
    }

    public void setXYZ(float x, float y, float z) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetXYZ(this.self, x, y, z));
    }

    public void setXYZ(float[] xyz) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetXYZ(this.self, xyz[0], xyz[1], xyz[2]));
    }

    public int countSuperatoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountSuperatoms(this.self));
    }

    public int countDataSGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountDataSGroups(this.self));
    }

    public int countRepeatingUnits() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountRepeatingUnits(this.self));
    }

    public int countMultipleGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountMultipleGroups(this.self));
    }

    public int countGenericSGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountGenericSGroups(this.self));
    }

    public IndigoObject iterateSuperatoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateSuperatoms(this.self)), this);
    }

    public IndigoObject iterateDataSGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateDataSGroups(this.self)), this);
    }

    public IndigoObject iterateRepeatingUnits() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateRepeatingUnits(this.self)), this);
    }

    public IndigoObject iterateMultipleGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateMultipleGroups(this.self)), this);
    }

    public IndigoObject iterateGenericSGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateGenericSGroups(this.self)), this);
    }

    public IndigoObject getDataSGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetDataSGroup(this.self, index)), this);
    }

    public IndigoObject getSuperatom(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetSuperatom(this.self, index)), this);
    }

    public IndigoObject getGenericSGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetGenericSGroup(this.self, index)), this);
    }

    public IndigoObject getMultipleGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetMultipleGroup(this.self, index)), this);
    }

    public IndigoObject getRepeatingUnit(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetRepeatingUnit(this.self, index)), this);
    }

    public String description() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoDescription(this.self));
    }

    public String data() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoData(this.self));
    }

    public IndigoObject addDataSGroup(int[] atoms, int[] bonds, String description, String data) {
        this.dispatcher.setSessionID();
        if (description == null) {
            description = "";
        }
        if (data == null) {
            data = "";
        }
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAddDataSGroup(this.self, atoms.length, atoms, bonds.length, bonds, description, data)), this);
    }

    public IndigoObject addDataSGroup(Collection<Integer> atoms, Collection<Integer> bonds, String description, String data) {
        return this.addDataSGroup(Indigo.toIntArray(atoms), Indigo.toIntArray(bonds), description, data);
    }

    public void addStereocenter(int type, int v1, int v2, int v3) {
        this.addStereocenter(type, v1, v2, v3, -1);
    }

    public void addStereocenter(int type, int v1, int v2, int v3, int v4) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAddStereocenter(this.self, type, v1, v2, v3, v4));
    }

    public void setDataSGroupXY(float x, float y) {
        this.setDataSGroupXY(x, y, "");
    }

    public void setDataSGroupXY(float x, float y, String options) {
        this.dispatcher.setSessionID();
        if (options == null) {
            options = "";
        }
        Indigo.checkResult(this, this._lib.indigoSetDataSGroupXY(this.self, x, y, options));
    }

    public IndigoObject createSubmolecule(int[] vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoCreateSubmolecule(this.self, vertices.length, vertices)));
    }

    public IndigoObject createSubmolecule(Collection<Integer> vertices) {
        return this.createSubmolecule(Indigo.toIntArray(vertices));
    }

    public IndigoObject getSubmolecule(int[] vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoGetSubmolecule(this.self, vertices.length, vertices)));
    }

    public IndigoObject getSubmolecule(Collection<Integer> vertices) {
        return this.getSubmolecule(Indigo.toIntArray(vertices));
    }

    public IndigoObject createEdgeSubmolecule(int[] vertices, int[] edges) {
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoCreateEdgeSubmolecule(this.self, vertices.length, vertices, edges.length, edges)));
    }

    public IndigoObject createEdgeSubmolecule(Collection<Integer> vertices, Collection<Integer> edges) {
        return this.createEdgeSubmolecule(Indigo.toIntArray(vertices), Indigo.toIntArray(edges));
    }

    public void removeAtoms(int[] vertices) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRemoveAtoms(this.self, vertices.length, vertices));
    }

    public void removeAtoms(Collection<Integer> vertices) {
        this.removeAtoms(Indigo.toIntArray(vertices));
    }

    public void removeBonds(int[] bonds) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRemoveBonds(this.self, bonds.length, bonds));
    }

    public void removeBonds(Collection<Integer> bonds) {
        this.removeBonds(Indigo.toIntArray(bonds));
    }

    public float alignAtoms(int[] atom_ids, float[] desired_xyz) {
        if (atom_ids.length * 3 != desired_xyz.length) {
            throw new IndigoException(this, "desired_xyz[] must be exactly 3 times bigger than atom_ids[]");
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResultFloat(this, this._lib.indigoAlignAtoms(this.self, atom_ids.length, atom_ids, desired_xyz));
    }

    public float alignAtoms(Collection<Integer> atom_ids, Collection<Float> desired_xyz) {
        return this.alignAtoms(Indigo.toIntArray(atom_ids), Indigo.toFloatArray(desired_xyz));
    }

    public void aromatize() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAromatize(this.self));
    }

    public void dearomatize() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoDearomatize(this.self));
    }

    public void foldHydrogens() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoFoldHydrogens(this.self));
    }

    public void unfoldHydrogens() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoUnfoldHydrogens(this.self));
    }

    public void layout() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoLayout(this.self));
    }

    public String smiles() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoSmiles(this.self));
    }

    public String name() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoName(this.self));
    }

    public void setName(String name) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetName(this.self, name));
    }

    public byte[] serialize() {
        PointerByReference ptr = new PointerByReference();
        IntByReference size = new IntByReference();
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSerialize(this.self, ptr, size));
        Pointer p = ptr.getValue();
        return p.getByteArray(0L, size.getValue());
    }

    public boolean hasProperty(String prop) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoHasProperty(this.self, prop)) == 1;
    }

    public String getProperty(String prop) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoGetProperty(this.self, prop));
    }

    public void setProperty(String prop, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoSetProperty(this.self, prop, value));
    }

    public void removeProperty(String prop) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRemoveProperty(this.self, prop));
    }

    public IndigoObject iterateProperties() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateProperties(this.self)), this);
    }

    public void clearProperties() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClearProperties(this.self));
    }

    public String checkBadValence() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoCheckBadValence(this.self));
    }

    public String checkAmbiguousH() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoCheckAmbiguousH(this.self));
    }

    public IndigoObject fingerprint() {
        return this.fingerprint("");
    }

    public IndigoObject fingerprint(String type) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoFingerprint(this.self, type)));
    }

    public int countBits() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCountBits(this.self));
    }

    public String rawData() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoRawData(this.self));
    }

    public int tell() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoTell(this.self));
    }

    public void sdfAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this._lib.indigoSdfAppend(this.self, item.self));
    }

    public void smilesAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this._lib.indigoSmilesAppend(this.self, item.self));
    }

    public void rdfHeader() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRdfHeader(this.self));
    }

    public void rdfAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this._lib.indigoRdfAppend(this.self, item.self));
    }

    public void cmlHeader() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoCmlHeader(this.self));
    }

    public void cmlAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this._lib.indigoCmlAppend(this.self, item.self));
    }

    public void cmlFooter() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoCmlFooter(this.self));
    }

    public IndigoObject iterateArray() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateArray(this.self)), this);
    }

    public int count() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoCount(this.self));
    }

    public void clear() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClear(this.self));
    }

    public int arrayAdd(IndigoObject other) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, other, this._lib.indigoArrayAdd(this.self, other.self));
    }

    public IndigoObject at(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAt(this.self, idx)), this);
    }

    public void ignoreAtom(IndigoObject atom) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, atom, this._lib.indigoIgnoreAtom(this.self, atom.self));
    }

    public void unignoreAtom(IndigoObject atom) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, atom, this._lib.indigoUnignoreAtom(this.self, atom.self));
    }

    public void unignoreAllAtoms() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoUnignoreAllAtoms(this.self));
    }

    public IndigoObject match(IndigoObject query) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query, this._lib.indigoMatch(this.self, query.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public int countMatches(IndigoObject query) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, query, this._lib.indigoCountMatches(this.self, query.self));
    }

    public int countMatchesWithLimit(IndigoObject query, int embeddings_limit) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, query, this._lib.indigoCountMatchesWithLimit(this.self, query.self, embeddings_limit));
    }

    public IndigoObject iterateMatches(IndigoObject query) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, query, this._lib.indigoIterateMatches(this.self, query.self)), this);
    }

    public IndigoObject highlightedTarget() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoHighlightedTarget(this.self)));
    }

    public IndigoObject mapAtom(IndigoObject query_atom) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_atom, this._lib.indigoMapAtom(this.self, query_atom.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject mapMolecule(IndigoObject query_reaction_molecule) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_reaction_molecule, this._lib.indigoMapMolecule(this.self, query_reaction_molecule.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject mapBond(IndigoObject query_bond) {
        Object[] guard = new Object[]{this, query_bond};
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_bond, this._lib.indigoMapBond(this.self, query_bond.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject allScaffolds() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoAllScaffolds(this.self)));
    }

    public IndigoObject decomposedMoleculeScaffold() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoDecomposedMoleculeScaffold(this.self)));
    }

    @Deprecated
    public IndigoObject iterateDecomposedMolecules() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoIterateDecomposedMolecules(this.self)), this);
    }

    public IndigoObject decomposedMoleculeHighlighted() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoDecomposedMoleculeHighlighted(this.self)));
    }

    public IndigoObject decomposedMoleculeWithRGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this._lib.indigoDecomposedMoleculeWithRGroups(this.self)));
    }

    public IndigoObject decomposeMolecule(IndigoObject mol) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, this._lib.indigoDecomposeMolecule(this.self, mol.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject iterateDecompositions() {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, this._lib.indigoIterateDecompositions(this.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public void addDecomposition(IndigoObject q_match) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoAddDecomposition(this.self, q_match.self));
    }

    @Override
    public Iterator<IndigoObject> iterator() {
        return this;
    }

    @Override
    public void remove() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoRemove(this.self));
    }

    public void close() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoClose(this.self));
    }

    @Override
    public IndigoObject next() throws NoSuchElementException {
        this.dispatcher.setSessionID();
        int next = Indigo.checkResult(this, this._lib.indigoNext(this.self));
        if (next == 0) {
            throw new NoSuchElementException("iterator has ended");
        }
        return new IndigoObject(this.dispatcher, next, this);
    }

    @Override
    public boolean hasNext() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoHasNext(this.self)) == 1;
    }

    public int index() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoIndex(this.self));
    }

    public String toString() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoToString(this.self));
    }

    public byte[] toBuffer() {
        PointerByReference ptr = new PointerByReference();
        IntByReference size = new IntByReference();
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this._lib.indigoToBuffer(this.self, ptr, size));
        Pointer p = ptr.getValue();
        return p.getByteArray(0L, size.getValue());
    }

    public int[] symmetryClasses() {
        IntByReference count = new IntByReference();
        this.dispatcher.setSessionID();
        Pointer p = Indigo.checkResultPointer(this, this._lib.indigoSymmetryClasses(this.self, count));
        return p.getIntArray(0L, count.getValue());
    }

    public void append(IndigoObject obj) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, obj, this._lib.indigoAppend(this.self, obj.self));
    }

    public void optimize() {
        this.optimize(null);
    }

    public void optimize(String options) {
        this.dispatcher.setSessionID();
        if (options == null) {
            options = "";
        }
        Indigo.checkResult(this, this._lib.indigoOptimize(this.self, options));
    }

    public boolean normalize() {
        return this.normalize(null);
    }

    public boolean normalize(String options) {
        this.dispatcher.setSessionID();
        if (options == null) {
            options = "";
        }
        return Indigo.checkResult(this, this._lib.indigoNormalize(this.self, options)) == 1;
    }

    public int expandAbbreviations() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this._lib.indigoExpandAbbreviations(this.self));
    }

    public String dbgInternalType() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this._lib.indigoDbgInternalType(this.self));
    }
}

