/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.msg;

import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.IllegalFunctionRequest;
import com.ghgande.j2mod.modbus.msg.MaskWriteRegisterRequest;
import com.ghgande.j2mod.modbus.msg.ModbusMessageImpl;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.msg.ReadCoilsRequest;
import com.ghgande.j2mod.modbus.msg.ReadCommEventCounterRequest;
import com.ghgande.j2mod.modbus.msg.ReadCommEventLogRequest;
import com.ghgande.j2mod.modbus.msg.ReadExceptionStatusRequest;
import com.ghgande.j2mod.modbus.msg.ReadFIFOQueueRequest;
import com.ghgande.j2mod.modbus.msg.ReadFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputDiscretesRequest;
import com.ghgande.j2mod.modbus.msg.ReadInputRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadMEIRequest;
import com.ghgande.j2mod.modbus.msg.ReadMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.ReadSerialDiagnosticsRequest;
import com.ghgande.j2mod.modbus.msg.ReadWriteMultipleRequest;
import com.ghgande.j2mod.modbus.msg.ReportSlaveIDRequest;
import com.ghgande.j2mod.modbus.msg.WriteCoilRequest;
import com.ghgande.j2mod.modbus.msg.WriteFileRecordRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleCoilsRequest;
import com.ghgande.j2mod.modbus.msg.WriteMultipleRegistersRequest;
import com.ghgande.j2mod.modbus.msg.WriteSingleRegisterRequest;
import com.ghgande.j2mod.modbus.net.AbstractModbusListener;

public abstract class ModbusRequest
extends ModbusMessageImpl {
    public static ModbusRequest createModbusRequest(int functionCode) {
        ModbusRequest request;
        switch (functionCode) {
            case 1: {
                request = new ReadCoilsRequest();
                break;
            }
            case 2: {
                request = new ReadInputDiscretesRequest();
                break;
            }
            case 3: {
                request = new ReadMultipleRegistersRequest();
                break;
            }
            case 4: {
                request = new ReadInputRegistersRequest();
                break;
            }
            case 5: {
                request = new WriteCoilRequest();
                break;
            }
            case 6: {
                request = new WriteSingleRegisterRequest();
                break;
            }
            case 15: {
                request = new WriteMultipleCoilsRequest();
                break;
            }
            case 16: {
                request = new WriteMultipleRegistersRequest();
                break;
            }
            case 7: {
                request = new ReadExceptionStatusRequest();
                break;
            }
            case 8: {
                request = new ReadSerialDiagnosticsRequest();
                break;
            }
            case 11: {
                request = new ReadCommEventCounterRequest();
                break;
            }
            case 12: {
                request = new ReadCommEventLogRequest();
                break;
            }
            case 17: {
                request = new ReportSlaveIDRequest();
                break;
            }
            case 20: {
                request = new ReadFileRecordRequest();
                break;
            }
            case 21: {
                request = new WriteFileRecordRequest();
                break;
            }
            case 22: {
                request = new MaskWriteRegisterRequest();
                break;
            }
            case 23: {
                request = new ReadWriteMultipleRequest();
                break;
            }
            case 24: {
                request = new ReadFIFOQueueRequest();
                break;
            }
            case 43: {
                request = new ReadMEIRequest();
                break;
            }
            default: {
                request = new IllegalFunctionRequest(functionCode);
            }
        }
        return request;
    }

    public abstract ModbusResponse getResponse();

    public abstract ModbusResponse createResponse(AbstractModbusListener var1);

    public ModbusResponse createExceptionResponse(int code) {
        return this.updateResponseWithHeader(new ExceptionResponse(this.getFunctionCode(), code), true);
    }

    ModbusResponse updateResponseWithHeader(ModbusResponse response) {
        return this.updateResponseWithHeader(response, false);
    }

    ModbusResponse updateResponseWithHeader(ModbusResponse response, boolean ignoreFunctionCode) {
        response.setHeadless(this.isHeadless());
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        if (!ignoreFunctionCode) {
            response.setFunctionCode(this.getFunctionCode());
        }
        return response;
    }
}

