/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.properties;

import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MethodProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MetricTag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="bucket4j")
@Validated
public class Bucket4JBootProperties {
    public static final String PROPERTY_PREFIX = "bucket4j";
    @NotNull
    private Boolean enabled = true;
    private String cacheToUse;
    @Valid
    private List<MethodProperties> methods = new ArrayList<MethodProperties>();
    private boolean filterConfigCachingEnabled = false;
    @NotBlank
    private String filterConfigCacheName = "filterConfigCache";
    @Valid
    private List<Bucket4JConfiguration> filters = new ArrayList<Bucket4JConfiguration>();
    @Valid
    private List<MetricTag> defaultMetricTags = new ArrayList<MetricTag>();

    @AssertTrue(message="FilterConfiguration caching is enabled, but not all filters have an identifier configured")
    public @AssertTrue(message="FilterConfiguration caching is enabled, but not all filters have an identifier configured") boolean isValidFilterIds() {
        return !this.filterConfigCachingEnabled || this.filters.stream().noneMatch(filter -> filter.getId() == null);
    }

    public static String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getCacheToUse() {
        return this.cacheToUse;
    }

    public List<MethodProperties> getMethods() {
        return this.methods;
    }

    public boolean isFilterConfigCachingEnabled() {
        return this.filterConfigCachingEnabled;
    }

    public String getFilterConfigCacheName() {
        return this.filterConfigCacheName;
    }

    public List<Bucket4JConfiguration> getFilters() {
        return this.filters;
    }

    public List<MetricTag> getDefaultMetricTags() {
        return this.defaultMetricTags;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setCacheToUse(String cacheToUse) {
        this.cacheToUse = cacheToUse;
    }

    public void setMethods(List<MethodProperties> methods) {
        this.methods = methods;
    }

    public void setFilterConfigCachingEnabled(boolean filterConfigCachingEnabled) {
        this.filterConfigCachingEnabled = filterConfigCachingEnabled;
    }

    public void setFilterConfigCacheName(String filterConfigCacheName) {
        this.filterConfigCacheName = filterConfigCacheName;
    }

    public void setFilters(List<Bucket4JConfiguration> filters) {
        this.filters = filters;
    }

    public void setDefaultMetricTags(List<MetricTag> defaultMetricTags) {
        this.defaultMetricTags = defaultMetricTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket4JBootProperties)) {
            return false;
        }
        Bucket4JBootProperties other = (Bucket4JBootProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFilterConfigCachingEnabled() != other.isFilterConfigCachingEnabled()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$cacheToUse = this.getCacheToUse();
        String other$cacheToUse = other.getCacheToUse();
        if (this$cacheToUse == null ? other$cacheToUse != null : !this$cacheToUse.equals(other$cacheToUse)) {
            return false;
        }
        List<MethodProperties> this$methods = this.getMethods();
        List<MethodProperties> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        String this$filterConfigCacheName = this.getFilterConfigCacheName();
        String other$filterConfigCacheName = other.getFilterConfigCacheName();
        if (this$filterConfigCacheName == null ? other$filterConfigCacheName != null : !this$filterConfigCacheName.equals(other$filterConfigCacheName)) {
            return false;
        }
        List<Bucket4JConfiguration> this$filters = this.getFilters();
        List<Bucket4JConfiguration> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        List<MetricTag> this$defaultMetricTags = this.getDefaultMetricTags();
        List<MetricTag> other$defaultMetricTags = other.getDefaultMetricTags();
        return !(this$defaultMetricTags == null ? other$defaultMetricTags != null : !((Object)this$defaultMetricTags).equals(other$defaultMetricTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bucket4JBootProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFilterConfigCachingEnabled() ? 79 : 97);
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $cacheToUse = this.getCacheToUse();
        result = result * 59 + ($cacheToUse == null ? 43 : $cacheToUse.hashCode());
        List<MethodProperties> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        String $filterConfigCacheName = this.getFilterConfigCacheName();
        result = result * 59 + ($filterConfigCacheName == null ? 43 : $filterConfigCacheName.hashCode());
        List<Bucket4JConfiguration> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        List<MetricTag> $defaultMetricTags = this.getDefaultMetricTags();
        result = result * 59 + ($defaultMetricTags == null ? 43 : ((Object)$defaultMetricTags).hashCode());
        return result;
    }

    public String toString() {
        return "Bucket4JBootProperties(enabled=" + this.getEnabled() + ", cacheToUse=" + this.getCacheToUse() + ", methods=" + this.getMethods() + ", filterConfigCachingEnabled=" + this.isFilterConfigCachingEnabled() + ", filterConfigCacheName=" + this.getFilterConfigCacheName() + ", filters=" + this.getFilters() + ", defaultMetricTags=" + this.getDefaultMetricTags() + ")";
    }
}

