/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.properties;

import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicateDefinition;
import com.giffing.bucket4j.spring.boot.starter.context.constraintvalidations.ValidBandWidthIds;
import com.giffing.bucket4j.spring.boot.starter.context.properties.BandWidth;
import io.github.bucket4j.TokensInheritanceStrategy;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@ValidBandWidthIds
public class RateLimit
implements Serializable {
    private String executeCondition;
    private String postExecuteCondition;
    @Valid
    private List<ExecutePredicateDefinition> executePredicates = new ArrayList<ExecutePredicateDefinition>();
    private String skipCondition;
    @Valid
    private List<ExecutePredicateDefinition> skipPredicates = new ArrayList<ExecutePredicateDefinition>();
    @NotBlank
    private String cacheKey = "1";
    @NotNull
    @Min(value=1L)
    private @NotNull @Min(value=1L) Integer numTokens = 1;
    @NotEmpty
    @Valid
    private List<BandWidth> bandwidths = new ArrayList<BandWidth>();
    @NotNull
    private TokensInheritanceStrategy tokensInheritanceStrategy = TokensInheritanceStrategy.RESET;

    public RateLimit copy() {
        RateLimit copy = new RateLimit();
        copy.setExecuteCondition(this.executeCondition);
        copy.setPostExecuteCondition(this.postExecuteCondition);
        copy.setExecutePredicates(this.executePredicates);
        copy.setSkipCondition(this.skipCondition);
        copy.setSkipPredicates(this.skipPredicates);
        copy.setCacheKey(this.cacheKey);
        copy.setNumTokens(this.numTokens);
        copy.setBandwidths(this.bandwidths);
        copy.setTokensInheritanceStrategy(this.tokensInheritanceStrategy);
        return copy;
    }

    public void consumeNotNullValues(RateLimit toConsume) {
        if (toConsume == null) {
            return;
        }
        if (toConsume.getExecuteCondition() != null && !toConsume.getExecuteCondition().isEmpty()) {
            this.setExecuteCondition(toConsume.getExecuteCondition());
        }
        if (toConsume.getPostExecuteCondition() != null && !toConsume.getPostExecuteCondition().isEmpty()) {
            this.setPostExecuteCondition(toConsume.getPostExecuteCondition());
        }
        if (toConsume.getExecutePredicates() != null && !toConsume.getExecutePredicates().isEmpty()) {
            this.setExecutePredicates(toConsume.getExecutePredicates());
        }
        if (toConsume.getSkipCondition() != null && !toConsume.getSkipCondition().isEmpty()) {
            this.setSkipCondition(toConsume.getSkipCondition());
        }
        if (toConsume.getSkipPredicates() != null && !toConsume.getSkipPredicates().isEmpty()) {
            this.setSkipPredicates(toConsume.getSkipPredicates());
        }
        if (toConsume.getCacheKey() != null && !toConsume.getCacheKey().equals("1") && !toConsume.getCacheKey().isEmpty()) {
            this.setCacheKey(toConsume.getCacheKey());
        }
        if (toConsume.getNumTokens() != null && toConsume.getNumTokens() != 1) {
            this.setNumTokens(toConsume.getNumTokens());
        }
        if (toConsume.getBandwidths() != null && !toConsume.getBandwidths().isEmpty()) {
            this.setBandwidths(toConsume.getBandwidths());
        }
        if (toConsume.getTokensInheritanceStrategy() != null) {
            this.setTokensInheritanceStrategy(toConsume.getTokensInheritanceStrategy());
        }
    }

    public String getExecuteCondition() {
        return this.executeCondition;
    }

    public String getPostExecuteCondition() {
        return this.postExecuteCondition;
    }

    public List<ExecutePredicateDefinition> getExecutePredicates() {
        return this.executePredicates;
    }

    public String getSkipCondition() {
        return this.skipCondition;
    }

    public List<ExecutePredicateDefinition> getSkipPredicates() {
        return this.skipPredicates;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public Integer getNumTokens() {
        return this.numTokens;
    }

    public List<BandWidth> getBandwidths() {
        return this.bandwidths;
    }

    public TokensInheritanceStrategy getTokensInheritanceStrategy() {
        return this.tokensInheritanceStrategy;
    }

    public void setExecuteCondition(String executeCondition) {
        this.executeCondition = executeCondition;
    }

    public void setPostExecuteCondition(String postExecuteCondition) {
        this.postExecuteCondition = postExecuteCondition;
    }

    public void setExecutePredicates(List<ExecutePredicateDefinition> executePredicates) {
        this.executePredicates = executePredicates;
    }

    public void setSkipCondition(String skipCondition) {
        this.skipCondition = skipCondition;
    }

    public void setSkipPredicates(List<ExecutePredicateDefinition> skipPredicates) {
        this.skipPredicates = skipPredicates;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setNumTokens(Integer numTokens) {
        this.numTokens = numTokens;
    }

    public void setBandwidths(List<BandWidth> bandwidths) {
        this.bandwidths = bandwidths;
    }

    public void setTokensInheritanceStrategy(TokensInheritanceStrategy tokensInheritanceStrategy) {
        this.tokensInheritanceStrategy = tokensInheritanceStrategy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimit)) {
            return false;
        }
        RateLimit other = (RateLimit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$numTokens = this.getNumTokens();
        Integer other$numTokens = other.getNumTokens();
        if (this$numTokens == null ? other$numTokens != null : !((Object)this$numTokens).equals(other$numTokens)) {
            return false;
        }
        String this$executeCondition = this.getExecuteCondition();
        String other$executeCondition = other.getExecuteCondition();
        if (this$executeCondition == null ? other$executeCondition != null : !this$executeCondition.equals(other$executeCondition)) {
            return false;
        }
        String this$postExecuteCondition = this.getPostExecuteCondition();
        String other$postExecuteCondition = other.getPostExecuteCondition();
        if (this$postExecuteCondition == null ? other$postExecuteCondition != null : !this$postExecuteCondition.equals(other$postExecuteCondition)) {
            return false;
        }
        List<ExecutePredicateDefinition> this$executePredicates = this.getExecutePredicates();
        List<ExecutePredicateDefinition> other$executePredicates = other.getExecutePredicates();
        if (this$executePredicates == null ? other$executePredicates != null : !((Object)this$executePredicates).equals(other$executePredicates)) {
            return false;
        }
        String this$skipCondition = this.getSkipCondition();
        String other$skipCondition = other.getSkipCondition();
        if (this$skipCondition == null ? other$skipCondition != null : !this$skipCondition.equals(other$skipCondition)) {
            return false;
        }
        List<ExecutePredicateDefinition> this$skipPredicates = this.getSkipPredicates();
        List<ExecutePredicateDefinition> other$skipPredicates = other.getSkipPredicates();
        if (this$skipPredicates == null ? other$skipPredicates != null : !((Object)this$skipPredicates).equals(other$skipPredicates)) {
            return false;
        }
        String this$cacheKey = this.getCacheKey();
        String other$cacheKey = other.getCacheKey();
        if (this$cacheKey == null ? other$cacheKey != null : !this$cacheKey.equals(other$cacheKey)) {
            return false;
        }
        List<BandWidth> this$bandwidths = this.getBandwidths();
        List<BandWidth> other$bandwidths = other.getBandwidths();
        if (this$bandwidths == null ? other$bandwidths != null : !((Object)this$bandwidths).equals(other$bandwidths)) {
            return false;
        }
        TokensInheritanceStrategy this$tokensInheritanceStrategy = this.getTokensInheritanceStrategy();
        TokensInheritanceStrategy other$tokensInheritanceStrategy = other.getTokensInheritanceStrategy();
        return !(this$tokensInheritanceStrategy == null ? other$tokensInheritanceStrategy != null : !this$tokensInheritanceStrategy.equals(other$tokensInheritanceStrategy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimit;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $numTokens = this.getNumTokens();
        result = result * 59 + ($numTokens == null ? 43 : ((Object)$numTokens).hashCode());
        String $executeCondition = this.getExecuteCondition();
        result = result * 59 + ($executeCondition == null ? 43 : $executeCondition.hashCode());
        String $postExecuteCondition = this.getPostExecuteCondition();
        result = result * 59 + ($postExecuteCondition == null ? 43 : $postExecuteCondition.hashCode());
        List<ExecutePredicateDefinition> $executePredicates = this.getExecutePredicates();
        result = result * 59 + ($executePredicates == null ? 43 : ((Object)$executePredicates).hashCode());
        String $skipCondition = this.getSkipCondition();
        result = result * 59 + ($skipCondition == null ? 43 : $skipCondition.hashCode());
        List<ExecutePredicateDefinition> $skipPredicates = this.getSkipPredicates();
        result = result * 59 + ($skipPredicates == null ? 43 : ((Object)$skipPredicates).hashCode());
        String $cacheKey = this.getCacheKey();
        result = result * 59 + ($cacheKey == null ? 43 : $cacheKey.hashCode());
        List<BandWidth> $bandwidths = this.getBandwidths();
        result = result * 59 + ($bandwidths == null ? 43 : ((Object)$bandwidths).hashCode());
        TokensInheritanceStrategy $tokensInheritanceStrategy = this.getTokensInheritanceStrategy();
        result = result * 59 + ($tokensInheritanceStrategy == null ? 43 : $tokensInheritanceStrategy.hashCode());
        return result;
    }

    public String toString() {
        return "RateLimit(executeCondition=" + this.getExecuteCondition() + ", postExecuteCondition=" + this.getPostExecuteCondition() + ", executePredicates=" + this.getExecutePredicates() + ", skipCondition=" + this.getSkipCondition() + ", skipPredicates=" + this.getSkipPredicates() + ", cacheKey=" + this.getCacheKey() + ", numTokens=" + this.getNumTokens() + ", bandwidths=" + this.getBandwidths() + ", tokensInheritanceStrategy=" + this.getTokensInheritanceStrategy() + ")";
    }
}

