/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.metrics;

import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagResult;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricType;
import io.github.bucket4j.BucketListener;
import java.util.List;

public class MetricBucketListener
implements BucketListener {
    private final String name;
    private final List<MetricTagResult> tags;
    private final List<MetricHandler> metricHandlers;
    private final List<MetricType> allowedTypes;

    public MetricBucketListener(String name, List<MetricHandler> metricHandlers, List<MetricType> allowedTypes, List<MetricTagResult> tags) {
        this.name = name;
        this.metricHandlers = metricHandlers;
        this.allowedTypes = allowedTypes;
        this.tags = tags;
    }

    public void onConsumed(long tokens) {
        if (this.allowedTypes.contains((Object)MetricType.CONSUMED_COUNTER)) {
            this.metricHandlers.forEach(metricHandler -> metricHandler.handle(MetricType.CONSUMED_COUNTER, this.name, tokens, this.tags));
        }
    }

    public void onRejected(long tokens) {
        if (this.allowedTypes.contains((Object)MetricType.REJECTED_COUNTER)) {
            this.metricHandlers.forEach(metricHandler -> metricHandler.handle(MetricType.REJECTED_COUNTER, this.name, tokens, this.tags));
        }
    }

    public void onParked(long nanos) {
        if (this.allowedTypes.contains((Object)MetricType.PARKED_COUNTER)) {
            this.metricHandlers.forEach(metricHandler -> metricHandler.handle(MetricType.PARKED_COUNTER, this.name, 1L, this.tags));
        }
    }

    public void onInterrupted(InterruptedException e) {
        if (this.allowedTypes.contains((Object)MetricType.INTERRUPTED_COUNTER)) {
            this.metricHandlers.forEach(metricHandler -> metricHandler.handle(MetricType.INTERRUPTED_COUNTER, this.name, 1L, this.tags));
        }
    }

    public void onDelayed(long nanos) {
        if (this.allowedTypes.contains((Object)MetricType.DELAYED_COUNTER)) {
            this.metricHandlers.forEach(metricHandler -> metricHandler.handle(MetricType.DELAYED_COUNTER, this.name, 1L, this.tags));
        }
    }

    public String getName() {
        return this.name;
    }
}

