/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.constraintvalidations.ValidPredicateNames;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Metrics;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

@ValidPredicateNames
public class Bucket4JConfiguration
implements Serializable {
    @NotBlank
    private String cacheName = "buckets";
    @NotNull
    private FilterMethod filterMethod = FilterMethod.SERVLET;
    @NotNull
    private RateLimitConditionMatchingStrategy strategy = RateLimitConditionMatchingStrategy.FIRST;
    @NotBlank
    private String url = ".*";
    @NotNull
    private Integer filterOrder = -2147483638;
    @NotEmpty
    @Valid
    private List<RateLimit> rateLimits = new ArrayList<RateLimit>();
    private String httpContentType;
    private HttpStatus httpStatusCode;
    private String httpResponseBody;
    @NotNull
    private Boolean hideHttpResponseHeaders = Boolean.FALSE;
    private Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    @Valid
    private Metrics metrics = new Metrics();
    private String id;
    @Min(value=1L)
    @Max(value=92000000L)
    private @Min(value=1L) @Max(value=92000000L) long majorVersion = 1L;
    @Min(value=1L)
    @Max(value=99999999999L)
    private @Min(value=1L) @Max(value=99999999999L) long minorVersion = 1L;

    @AssertTrue(message="Invalid filter URL regex pattern.")
    @JsonIgnore
    public @AssertTrue(message="Invalid filter URL regex pattern.") boolean isUrlValid() {
        try {
            Pattern.compile(this.url);
            return !this.url.equals("/*");
        }
        catch (PatternSyntaxException e) {
            return false;
        }
    }

    public void setId(String id) {
        if (StringUtils.hasText((String)id)) {
            this.id = id.trim();
        }
    }

    @JsonIgnore
    public long getBucket4JVersionNumber() {
        return this.majorVersion * 100000000000L + this.minorVersion;
    }

    @Generated
    public Bucket4JConfiguration() {
    }

    @Generated
    public String getCacheName() {
        return this.cacheName;
    }

    @Generated
    public FilterMethod getFilterMethod() {
        return this.filterMethod;
    }

    @Generated
    public RateLimitConditionMatchingStrategy getStrategy() {
        return this.strategy;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Integer getFilterOrder() {
        return this.filterOrder;
    }

    @Generated
    public List<RateLimit> getRateLimits() {
        return this.rateLimits;
    }

    @Generated
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Generated
    public HttpStatus getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Generated
    public String getHttpResponseBody() {
        return this.httpResponseBody;
    }

    @Generated
    public Boolean getHideHttpResponseHeaders() {
        return this.hideHttpResponseHeaders;
    }

    @Generated
    public Map<String, String> getHttpResponseHeaders() {
        return this.httpResponseHeaders;
    }

    @Generated
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getMajorVersion() {
        return this.majorVersion;
    }

    @Generated
    public long getMinorVersion() {
        return this.minorVersion;
    }

    @Generated
    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    @Generated
    public void setFilterMethod(FilterMethod filterMethod) {
        this.filterMethod = filterMethod;
    }

    @Generated
    public void setStrategy(RateLimitConditionMatchingStrategy strategy) {
        this.strategy = strategy;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setFilterOrder(Integer filterOrder) {
        this.filterOrder = filterOrder;
    }

    @Generated
    public void setRateLimits(List<RateLimit> rateLimits) {
        this.rateLimits = rateLimits;
    }

    @Generated
    public void setHttpContentType(String httpContentType) {
        this.httpContentType = httpContentType;
    }

    @Generated
    public void setHttpStatusCode(HttpStatus httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    @Generated
    public void setHttpResponseBody(String httpResponseBody) {
        this.httpResponseBody = httpResponseBody;
    }

    @Generated
    public void setHideHttpResponseHeaders(Boolean hideHttpResponseHeaders) {
        this.hideHttpResponseHeaders = hideHttpResponseHeaders;
    }

    @Generated
    public void setHttpResponseHeaders(Map<String, String> httpResponseHeaders) {
        this.httpResponseHeaders = httpResponseHeaders;
    }

    @Generated
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    @Generated
    public void setMajorVersion(long majorVersion) {
        this.majorVersion = majorVersion;
    }

    @Generated
    public void setMinorVersion(long minorVersion) {
        this.minorVersion = minorVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket4JConfiguration)) {
            return false;
        }
        Bucket4JConfiguration other = (Bucket4JConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMajorVersion() != other.getMajorVersion()) {
            return false;
        }
        if (this.getMinorVersion() != other.getMinorVersion()) {
            return false;
        }
        Integer this$filterOrder = this.getFilterOrder();
        Integer other$filterOrder = other.getFilterOrder();
        if (this$filterOrder == null ? other$filterOrder != null : !((Object)this$filterOrder).equals(other$filterOrder)) {
            return false;
        }
        Boolean this$hideHttpResponseHeaders = this.getHideHttpResponseHeaders();
        Boolean other$hideHttpResponseHeaders = other.getHideHttpResponseHeaders();
        if (this$hideHttpResponseHeaders == null ? other$hideHttpResponseHeaders != null : !((Object)this$hideHttpResponseHeaders).equals(other$hideHttpResponseHeaders)) {
            return false;
        }
        String this$cacheName = this.getCacheName();
        String other$cacheName = other.getCacheName();
        if (this$cacheName == null ? other$cacheName != null : !this$cacheName.equals(other$cacheName)) {
            return false;
        }
        FilterMethod this$filterMethod = this.getFilterMethod();
        FilterMethod other$filterMethod = other.getFilterMethod();
        if (this$filterMethod == null ? other$filterMethod != null : !((Object)((Object)this$filterMethod)).equals((Object)other$filterMethod)) {
            return false;
        }
        RateLimitConditionMatchingStrategy this$strategy = this.getStrategy();
        RateLimitConditionMatchingStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)((Object)this$strategy)).equals((Object)other$strategy)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<RateLimit> this$rateLimits = this.getRateLimits();
        List<RateLimit> other$rateLimits = other.getRateLimits();
        if (this$rateLimits == null ? other$rateLimits != null : !((Object)this$rateLimits).equals(other$rateLimits)) {
            return false;
        }
        String this$httpContentType = this.getHttpContentType();
        String other$httpContentType = other.getHttpContentType();
        if (this$httpContentType == null ? other$httpContentType != null : !this$httpContentType.equals(other$httpContentType)) {
            return false;
        }
        HttpStatus this$httpStatusCode = this.getHttpStatusCode();
        HttpStatus other$httpStatusCode = other.getHttpStatusCode();
        if (this$httpStatusCode == null ? other$httpStatusCode != null : !this$httpStatusCode.equals(other$httpStatusCode)) {
            return false;
        }
        String this$httpResponseBody = this.getHttpResponseBody();
        String other$httpResponseBody = other.getHttpResponseBody();
        if (this$httpResponseBody == null ? other$httpResponseBody != null : !this$httpResponseBody.equals(other$httpResponseBody)) {
            return false;
        }
        Map<String, String> this$httpResponseHeaders = this.getHttpResponseHeaders();
        Map<String, String> other$httpResponseHeaders = other.getHttpResponseHeaders();
        if (this$httpResponseHeaders == null ? other$httpResponseHeaders != null : !((Object)this$httpResponseHeaders).equals(other$httpResponseHeaders)) {
            return false;
        }
        Metrics this$metrics = this.getMetrics();
        Metrics other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bucket4JConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $majorVersion = this.getMajorVersion();
        result = result * 59 + (int)($majorVersion >>> 32 ^ $majorVersion);
        long $minorVersion = this.getMinorVersion();
        result = result * 59 + (int)($minorVersion >>> 32 ^ $minorVersion);
        Integer $filterOrder = this.getFilterOrder();
        result = result * 59 + ($filterOrder == null ? 43 : ((Object)$filterOrder).hashCode());
        Boolean $hideHttpResponseHeaders = this.getHideHttpResponseHeaders();
        result = result * 59 + ($hideHttpResponseHeaders == null ? 43 : ((Object)$hideHttpResponseHeaders).hashCode());
        String $cacheName = this.getCacheName();
        result = result * 59 + ($cacheName == null ? 43 : $cacheName.hashCode());
        FilterMethod $filterMethod = this.getFilterMethod();
        result = result * 59 + ($filterMethod == null ? 43 : ((Object)((Object)$filterMethod)).hashCode());
        RateLimitConditionMatchingStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)((Object)$strategy)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<RateLimit> $rateLimits = this.getRateLimits();
        result = result * 59 + ($rateLimits == null ? 43 : ((Object)$rateLimits).hashCode());
        String $httpContentType = this.getHttpContentType();
        result = result * 59 + ($httpContentType == null ? 43 : $httpContentType.hashCode());
        HttpStatus $httpStatusCode = this.getHttpStatusCode();
        result = result * 59 + ($httpStatusCode == null ? 43 : $httpStatusCode.hashCode());
        String $httpResponseBody = this.getHttpResponseBody();
        result = result * 59 + ($httpResponseBody == null ? 43 : $httpResponseBody.hashCode());
        Map<String, String> $httpResponseHeaders = this.getHttpResponseHeaders();
        result = result * 59 + ($httpResponseHeaders == null ? 43 : ((Object)$httpResponseHeaders).hashCode());
        Metrics $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bucket4JConfiguration(cacheName=" + this.getCacheName() + ", filterMethod=" + this.getFilterMethod() + ", strategy=" + this.getStrategy() + ", url=" + this.getUrl() + ", filterOrder=" + this.getFilterOrder() + ", rateLimits=" + this.getRateLimits() + ", httpContentType=" + this.getHttpContentType() + ", httpStatusCode=" + this.getHttpStatusCode() + ", httpResponseBody=" + this.getHttpResponseBody() + ", hideHttpResponseHeaders=" + this.getHideHttpResponseHeaders() + ", httpResponseHeaders=" + this.getHttpResponseHeaders() + ", metrics=" + this.getMetrics() + ", id=" + this.getId() + ", majorVersion=" + this.getMajorVersion() + ", minorVersion=" + this.getMinorVersion() + ")";
    }
}

