/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.properties;

import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MethodProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MetricTag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="bucket4j")
@Validated
public class Bucket4JBootProperties {
    public static final String PROPERTY_PREFIX = "bucket4j";
    @NotNull
    private Boolean enabled = true;
    private String cacheToUse;
    @Valid
    private List<MethodProperties> methods = new ArrayList<MethodProperties>();
    private boolean filterConfigCachingEnabled = false;
    @NotBlank
    private String filterConfigCacheName = "filterConfigCache";
    @Valid
    private List<Bucket4JConfiguration> filters = new ArrayList<Bucket4JConfiguration>();
    @Valid
    private List<MetricTag> defaultMetricTags = new ArrayList<MetricTag>();
    @Valid
    private List<MetricTag> defaultMethodMetricTags = new ArrayList<MetricTag>();
    @NotBlank
    private String defaultHttpContentType = "application/json";
    @NotNull
    private HttpStatus defaultHttpStatusCode = HttpStatus.TOO_MANY_REQUESTS;
    private String defaultHttpResponseBody = "{ \"message\": \"Too many requests!\" }";

    @AssertTrue(message="FilterConfiguration caching is enabled, but not all filters have an identifier configured")
    public @AssertTrue(message="FilterConfiguration caching is enabled, but not all filters have an identifier configured") boolean isValidFilterIds() {
        return !this.filterConfigCachingEnabled || this.filters.stream().noneMatch(filter -> filter.getId() == null);
    }

    public static String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    @Generated
    public Bucket4JBootProperties() {
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getCacheToUse() {
        return this.cacheToUse;
    }

    @Generated
    public List<MethodProperties> getMethods() {
        return this.methods;
    }

    @Generated
    public boolean isFilterConfigCachingEnabled() {
        return this.filterConfigCachingEnabled;
    }

    @Generated
    public String getFilterConfigCacheName() {
        return this.filterConfigCacheName;
    }

    @Generated
    public List<Bucket4JConfiguration> getFilters() {
        return this.filters;
    }

    @Generated
    public List<MetricTag> getDefaultMetricTags() {
        return this.defaultMetricTags;
    }

    @Generated
    public List<MetricTag> getDefaultMethodMetricTags() {
        return this.defaultMethodMetricTags;
    }

    @Generated
    public String getDefaultHttpContentType() {
        return this.defaultHttpContentType;
    }

    @Generated
    public HttpStatus getDefaultHttpStatusCode() {
        return this.defaultHttpStatusCode;
    }

    @Generated
    public String getDefaultHttpResponseBody() {
        return this.defaultHttpResponseBody;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setCacheToUse(String cacheToUse) {
        this.cacheToUse = cacheToUse;
    }

    @Generated
    public void setMethods(List<MethodProperties> methods) {
        this.methods = methods;
    }

    @Generated
    public void setFilterConfigCachingEnabled(boolean filterConfigCachingEnabled) {
        this.filterConfigCachingEnabled = filterConfigCachingEnabled;
    }

    @Generated
    public void setFilterConfigCacheName(String filterConfigCacheName) {
        this.filterConfigCacheName = filterConfigCacheName;
    }

    @Generated
    public void setFilters(List<Bucket4JConfiguration> filters) {
        this.filters = filters;
    }

    @Generated
    public void setDefaultMetricTags(List<MetricTag> defaultMetricTags) {
        this.defaultMetricTags = defaultMetricTags;
    }

    @Generated
    public void setDefaultMethodMetricTags(List<MetricTag> defaultMethodMetricTags) {
        this.defaultMethodMetricTags = defaultMethodMetricTags;
    }

    @Generated
    public void setDefaultHttpContentType(String defaultHttpContentType) {
        this.defaultHttpContentType = defaultHttpContentType;
    }

    @Generated
    public void setDefaultHttpStatusCode(HttpStatus defaultHttpStatusCode) {
        this.defaultHttpStatusCode = defaultHttpStatusCode;
    }

    @Generated
    public void setDefaultHttpResponseBody(String defaultHttpResponseBody) {
        this.defaultHttpResponseBody = defaultHttpResponseBody;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bucket4JBootProperties)) {
            return false;
        }
        Bucket4JBootProperties other = (Bucket4JBootProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFilterConfigCachingEnabled() != other.isFilterConfigCachingEnabled()) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        String this$cacheToUse = this.getCacheToUse();
        String other$cacheToUse = other.getCacheToUse();
        if (this$cacheToUse == null ? other$cacheToUse != null : !this$cacheToUse.equals(other$cacheToUse)) {
            return false;
        }
        List<MethodProperties> this$methods = this.getMethods();
        List<MethodProperties> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        String this$filterConfigCacheName = this.getFilterConfigCacheName();
        String other$filterConfigCacheName = other.getFilterConfigCacheName();
        if (this$filterConfigCacheName == null ? other$filterConfigCacheName != null : !this$filterConfigCacheName.equals(other$filterConfigCacheName)) {
            return false;
        }
        List<Bucket4JConfiguration> this$filters = this.getFilters();
        List<Bucket4JConfiguration> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        List<MetricTag> this$defaultMetricTags = this.getDefaultMetricTags();
        List<MetricTag> other$defaultMetricTags = other.getDefaultMetricTags();
        if (this$defaultMetricTags == null ? other$defaultMetricTags != null : !((Object)this$defaultMetricTags).equals(other$defaultMetricTags)) {
            return false;
        }
        List<MetricTag> this$defaultMethodMetricTags = this.getDefaultMethodMetricTags();
        List<MetricTag> other$defaultMethodMetricTags = other.getDefaultMethodMetricTags();
        if (this$defaultMethodMetricTags == null ? other$defaultMethodMetricTags != null : !((Object)this$defaultMethodMetricTags).equals(other$defaultMethodMetricTags)) {
            return false;
        }
        String this$defaultHttpContentType = this.getDefaultHttpContentType();
        String other$defaultHttpContentType = other.getDefaultHttpContentType();
        if (this$defaultHttpContentType == null ? other$defaultHttpContentType != null : !this$defaultHttpContentType.equals(other$defaultHttpContentType)) {
            return false;
        }
        HttpStatus this$defaultHttpStatusCode = this.getDefaultHttpStatusCode();
        HttpStatus other$defaultHttpStatusCode = other.getDefaultHttpStatusCode();
        if (this$defaultHttpStatusCode == null ? other$defaultHttpStatusCode != null : !this$defaultHttpStatusCode.equals(other$defaultHttpStatusCode)) {
            return false;
        }
        String this$defaultHttpResponseBody = this.getDefaultHttpResponseBody();
        String other$defaultHttpResponseBody = other.getDefaultHttpResponseBody();
        return !(this$defaultHttpResponseBody == null ? other$defaultHttpResponseBody != null : !this$defaultHttpResponseBody.equals(other$defaultHttpResponseBody));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bucket4JBootProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFilterConfigCachingEnabled() ? 79 : 97);
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        String $cacheToUse = this.getCacheToUse();
        result = result * 59 + ($cacheToUse == null ? 43 : $cacheToUse.hashCode());
        List<MethodProperties> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        String $filterConfigCacheName = this.getFilterConfigCacheName();
        result = result * 59 + ($filterConfigCacheName == null ? 43 : $filterConfigCacheName.hashCode());
        List<Bucket4JConfiguration> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        List<MetricTag> $defaultMetricTags = this.getDefaultMetricTags();
        result = result * 59 + ($defaultMetricTags == null ? 43 : ((Object)$defaultMetricTags).hashCode());
        List<MetricTag> $defaultMethodMetricTags = this.getDefaultMethodMetricTags();
        result = result * 59 + ($defaultMethodMetricTags == null ? 43 : ((Object)$defaultMethodMetricTags).hashCode());
        String $defaultHttpContentType = this.getDefaultHttpContentType();
        result = result * 59 + ($defaultHttpContentType == null ? 43 : $defaultHttpContentType.hashCode());
        HttpStatus $defaultHttpStatusCode = this.getDefaultHttpStatusCode();
        result = result * 59 + ($defaultHttpStatusCode == null ? 43 : $defaultHttpStatusCode.hashCode());
        String $defaultHttpResponseBody = this.getDefaultHttpResponseBody();
        result = result * 59 + ($defaultHttpResponseBody == null ? 43 : $defaultHttpResponseBody.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Bucket4JBootProperties(enabled=" + this.getEnabled() + ", cacheToUse=" + this.getCacheToUse() + ", methods=" + String.valueOf(this.getMethods()) + ", filterConfigCachingEnabled=" + this.isFilterConfigCachingEnabled() + ", filterConfigCacheName=" + this.getFilterConfigCacheName() + ", filters=" + String.valueOf(this.getFilters()) + ", defaultMetricTags=" + String.valueOf(this.getDefaultMetricTags()) + ", defaultMethodMetricTags=" + String.valueOf(this.getDefaultMethodMetricTags()) + ", defaultHttpContentType=" + this.getDefaultHttpContentType() + ", defaultHttpStatusCode=" + String.valueOf(this.getDefaultHttpStatusCode()) + ", defaultHttpResponseBody=" + this.getDefaultHttpResponseBody() + ")";
    }
}

