/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context.metrics;

import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagResult;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricType;
import io.github.bucket4j.BucketListener;
import java.util.List;

public class MetricBucketListener
implements BucketListener {
    private final String name;
    private final List<MetricTagResult> tags;
    private final MetricHandler metricHandler;
    private final List<MetricType> allowedTypes;

    public MetricBucketListener(String name, MetricHandler metricHandler, List<MetricType> allowedTypes, List<MetricTagResult> tags) {
        this.name = name;
        this.metricHandler = metricHandler;
        this.allowedTypes = allowedTypes;
        this.tags = tags;
    }

    public void onConsumed(long tokens) {
        if (this.allowedTypes.contains((Object)MetricType.CONSUMED_COUNTER)) {
            this.metricHandler.handle(MetricType.CONSUMED_COUNTER, this.name, tokens, this.tags);
        }
    }

    public void onRejected(long tokens) {
        if (this.allowedTypes.contains((Object)MetricType.REJECTED_COUNTER)) {
            this.metricHandler.handle(MetricType.REJECTED_COUNTER, this.name, tokens, this.tags);
        }
    }

    public void onParked(long nanos) {
    }

    public long getConsumed() {
        return 0L;
    }

    public long getRejected() {
        return 0L;
    }

    public long getParkedNanos() {
        return 0L;
    }

    public long getInterrupted() {
        return 0L;
    }

    public void onInterrupted(InterruptedException e) {
    }

    public void onDelayed(long nanos) {
    }

    public String getName() {
        return this.name;
    }
}

