/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config;

import com.giffing.bucket4j.spring.boot.starter.config.metrics.DummyMetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.BandWidthConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Condition;
import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricBucketListener;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricTagStrategy;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.exception.MissingKeyFilterExpressionException;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.grid.ProxyManager;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.util.StringUtils;

public abstract class Bucket4JBaseConfiguration<R> {
    @Autowired(required=false)
    private List<MetricTagStrategy<R>> metricTagStrategies = new ArrayList<MetricTagStrategy<R>>();

    @Bean
    public MetricHandler dummyMetricHandler() {
        return new DummyMetricHandler();
    }

    public FilterConfiguration<R> buildFilterConfig(Bucket4JConfiguration config, ProxyManager<String> buckets, ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory) {
        FilterConfiguration filterConfig = new FilterConfiguration();
        filterConfig.setUrl(config.getUrl());
        filterConfig.setOrder(config.getFilterOrder());
        filterConfig.setStrategy(config.getStrategy());
        filterConfig.setHttpResponseBody(config.getHttpResponseBody());
        config.getRateLimits().forEach(rl -> {
            ConfigurationBuilder configBuilder = Bucket4j.configurationBuilder();
            for (BandWidthConfig bandWidth : rl.getBandwidths()) {
                Bandwidth bucket4jBandWidth = Bandwidth.simple((long)bandWidth.getCapacity(), (Duration)Duration.of(bandWidth.getTime(), bandWidth.getUnit()));
                if (bandWidth.getFixedRefillInterval() > 0L) {
                    bucket4jBandWidth.withFixedRefillInterval(Duration.of(bandWidth.getFixedRefillInterval(), bandWidth.getFixedRefillIntervalUnit()));
                }
                configBuilder = configBuilder.addLimit(bucket4jBandWidth);
            }
            ConfigurationBuilder configBuilderToUse = configBuilder;
            RateLimitCheck rlc = (servletRequest, async) -> {
                boolean skipRateLimit = false;
                if (rl.getSkipCondition() != null) {
                    skipRateLimit = this.skipCondition((RateLimit)rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
                }
                if (rl.getExecuteCondition() != null && !skipRateLimit) {
                    boolean bl = skipRateLimit = !this.executeCondition((RateLimit)rl, expressionParser, (BeanFactory)beanFactory).evalute(servletRequest);
                }
                if (!skipRateLimit) {
                    String key = this.getKeyFilter(filterConfig.getUrl(), (RateLimit)rl, expressionParser, (BeanFactory)beanFactory).key(servletRequest);
                    BucketConfiguration bucketConfiguration = configBuilderToUse.build();
                    MetricHandler metricHandler = (MetricHandler)beanFactory.getBean(MetricHandler.class);
                    Optional tagResult = this.metricTagStrategies.stream().filter(strategy -> config.getMetricTagsStrategyKeys().contains(strategy.key())).filter(strategy -> strategy.supports(servletRequest)).map(strategy -> strategy.getTags(servletRequest)).map(metricResult -> new ArrayList<String>(Arrays.asList(metricResult.getKey(), metricResult.getValue()))).collect(Collectors.reducing((a, b) -> {
                        a.addAll(b);
                        return a;
                    }));
                    MetricBucketListener metricBucketListener = new MetricBucketListener(config.getCacheName(), metricHandler, ((List)tagResult.orElse(new ArrayList())).toArray(new String[0]));
                    Bucket bucket = buckets.getProxy((Serializable)((Object)key), bucketConfiguration).toListenable((BucketListener)metricBucketListener);
                    if (async) {
                        return new ConsumptionProbeHolder(bucket.asAsync().tryConsumeAndReturnRemaining(1L));
                    }
                    return new ConsumptionProbeHolder(bucket.tryConsumeAndReturnRemaining(1L));
                }
                return null;
            };
            filterConfig.getRateLimitChecks().add(rlc);
        });
        return filterConfig;
    }

    protected abstract ProxyManager<String> createProxyManager(Bucket4JConfiguration var1);

    public KeyFilter<R> getKeyFilter(String url, RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        switch (rateLimit.getFilterKeyType()) {
            case IP: {
                return request -> {
                    if (request instanceof HttpServletRequest) {
                        return url + "-" + ((HttpServletRequest)request).getRemoteAddr();
                    }
                    if (request instanceof ServerHttpRequest) {
                        return url + "-" + ((ServerHttpRequest)request).getRemoteAddress().getHostName();
                    }
                    throw new IllegalStateException("Unsupported request type");
                };
            }
            case EXPRESSION: {
                String expression = rateLimit.getExpression();
                if (StringUtils.isEmpty((Object)expression)) {
                    throw new MissingKeyFilterExpressionException();
                }
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
                return request -> {
                    Expression expr = expressionParser.parseExpression(rateLimit.getExpression());
                    String value = (String)expr.getValue((EvaluationContext)context, request, String.class);
                    return url + "-" + value;
                };
            }
        }
        return request -> url + "-1";
    }

    public Condition<R> skipCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getSkipCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getSkipCondition());
                Boolean value = (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
                return value;
            };
        }
        return null;
    }

    public Condition<R> executeCondition(RateLimit rateLimit, ExpressionParser expressionParser, BeanFactory beanFactory) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (rateLimit.getExecuteCondition() != null) {
            return request -> {
                Expression expr = expressionParser.parseExpression(rateLimit.getExecuteCondition());
                Boolean value = (Boolean)expr.getValue((EvaluationContext)context, request, Boolean.class);
                return value;
            };
        }
        return null;
    }
}

