/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.servlet;

import com.giffing.bucket4j.spring.boot.starter.config.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.metrics.Bucket4jMetricConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBoot1ActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBoot2ActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.servlet.ServletRequestFilter;
import io.github.bucket4j.grid.ProxyManager;
import io.github.bucket4j.grid.jcache.JCache;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@ConditionalOnClass(value={Filter.class, JCache.class})
@ConditionalOnProperty(prefix="bucket4j", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={SyncCacheResolver.class})
@Import(value={Bucket4jCacheConfiguration.class, Bucket4jMetricConfiguration.class, SpringBoot1ActuatorConfig.class, SpringBoot2ActuatorConfig.class})
public class Bucket4JAutoConfigurationServletFilter
extends Bucket4JBaseConfiguration<HttpServletRequest> {
    private Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationServletFilter.class);
    @Autowired
    private Bucket4JBootProperties properties;
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    @Autowired
    private SyncCacheResolver cacheResolver;

    @Bean
    @Qualifier(value="SERVLET")
    public Bucket4jConfigurationHolder servletConfigurationHolder() {
        return new Bucket4jConfigurationHolder();
    }

    @Bean
    public ExpressionParser servletFilterExpressionParser() {
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        SpelExpressionParser parser = new SpelExpressionParser(config);
        return parser;
    }

    @Bean
    @Conditional(value={ConfigCondition1.class})
    public FilterRegistrationBean bucket4JFilter1() {
        return this.getFilterRegistrationBean(0);
    }

    @Bean
    @Conditional(value={ConfigCondition2.class})
    public FilterRegistrationBean bucket4JFilter2() {
        return this.getFilterRegistrationBean(1);
    }

    @Bean
    @Conditional(value={ConfigCondition3.class})
    public FilterRegistrationBean bucket4JFilter3() {
        return this.getFilterRegistrationBean(2);
    }

    @Bean
    @Conditional(value={ConfigCondition4.class})
    public FilterRegistrationBean bucket4JFilter4() {
        return this.getFilterRegistrationBean(3);
    }

    @Bean
    @Conditional(value={ConfigCondition5.class})
    public FilterRegistrationBean bucket4JFilter5() {
        return this.getFilterRegistrationBean(4);
    }

    @Bean
    @Conditional(value={ConfigCondition6.class})
    public FilterRegistrationBean bucket4JFilter6() {
        return this.getFilterRegistrationBean(5);
    }

    @Bean
    @Conditional(value={ConfigCondition7.class})
    public FilterRegistrationBean bucket4JFilter7() {
        return this.getFilterRegistrationBean(6);
    }

    @Bean
    @Conditional(value={ConfigCondition8.class})
    public FilterRegistrationBean bucket4JFilter8() {
        return this.getFilterRegistrationBean(7);
    }

    @Bean
    @Conditional(value={ConfigCondition9.class})
    public FilterRegistrationBean bucket4JFilter9() {
        return this.getFilterRegistrationBean(8);
    }

    @Bean
    @Conditional(value={ConfigCondition10.class})
    public FilterRegistrationBean bucket4JFilter10() {
        return this.getFilterRegistrationBean(9);
    }

    @Bean
    @Conditional(value={ConfigCondition11.class})
    public FilterRegistrationBean bucket4JFilter11() {
        return this.getFilterRegistrationBean(10);
    }

    @Bean
    @Conditional(value={ConfigCondition12.class})
    public FilterRegistrationBean bucket4JFilter12() {
        return this.getFilterRegistrationBean(11);
    }

    @Bean
    @Conditional(value={ConfigCondition13.class})
    public FilterRegistrationBean bucket4JFilter13() {
        return this.getFilterRegistrationBean(12);
    }

    @Bean
    @Conditional(value={ConfigCondition14.class})
    public FilterRegistrationBean bucket4JFilter14() {
        return this.getFilterRegistrationBean(13);
    }

    @Bean
    @Conditional(value={ConfigCondition15.class})
    public FilterRegistrationBean bucket4JFilter15() {
        return this.getFilterRegistrationBean(14);
    }

    @Bean
    @Conditional(value={ConfigCondition16.class})
    public FilterRegistrationBean bucket4JFilter16() {
        return this.getFilterRegistrationBean(15);
    }

    @Bean
    @Conditional(value={ConfigCondition17.class})
    public FilterRegistrationBean bucket4JFilter17() {
        return this.getFilterRegistrationBean(16);
    }

    @Bean
    @Conditional(value={ConfigCondition18.class})
    public FilterRegistrationBean bucket4JFilter18() {
        return this.getFilterRegistrationBean(17);
    }

    @Bean
    @Conditional(value={ConfigCondition19.class})
    public FilterRegistrationBean bucket4JFilter19() {
        return this.getFilterRegistrationBean(18);
    }

    @Bean
    @Conditional(value={ConfigCondition20.class})
    public FilterRegistrationBean bucket4JFilter20() {
        return this.getFilterRegistrationBean(19);
    }

    private FilterRegistrationBean getFilterRegistrationBean(int position) {
        Integer filterCount = 0;
        if (this.properties.getFilters().size() >= position + 1) {
            Bucket4JConfiguration filter = (Bucket4JConfiguration)this.properties.getFilters().get(position);
            Integer n = filterCount;
            Integer n2 = filterCount = Integer.valueOf(filterCount + 1);
            FilterConfiguration filterConfig = this.buildFilterConfig(filter, this.createProxyManager(filter), this.servletFilterExpressionParser(), this.beanFactory);
            this.servletConfigurationHolder().addFilterConfiguration(filter);
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setName("bucket4JRequestFilter" + position);
            registration.setFilter((Filter)new ServletRequestFilter(filterConfig));
            registration.addUrlPatterns(new String[]{filter.getUrl()});
            registration.setOrder(filter.getFilterOrder());
            this.log.info("create-servlet-filter;{};{};{}", new Object[]{position, filter.getCacheName(), filter.getUrl()});
            return registration;
        }
        return null;
    }

    @Override
    protected ProxyManager<String> createProxyManager(Bucket4JConfiguration config) {
        return this.cacheResolver.resolve(config.getCacheName());
    }

    public static class ConfigCondition20
    extends AllNestedConditions {
        public ConfigCondition20() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[19].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[19].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition19
    extends AllNestedConditions {
        public ConfigCondition19() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[18].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[18].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition18
    extends AllNestedConditions {
        public ConfigCondition18() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[17].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[17].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition17
    extends AllNestedConditions {
        public ConfigCondition17() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[16].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[16].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition16
    extends AllNestedConditions {
        public ConfigCondition16() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[15].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[15].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition15
    extends AllNestedConditions {
        public ConfigCondition15() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[14].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[14].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition14
    extends AllNestedConditions {
        public ConfigCondition14() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[13].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[13].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition13
    extends AllNestedConditions {
        public ConfigCondition13() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[12].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[12].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition12
    extends AllNestedConditions {
        public ConfigCondition12() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[11].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[11].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition11
    extends AllNestedConditions {
        public ConfigCondition11() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[10].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[10].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition10
    extends AllNestedConditions {
        public ConfigCondition10() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[9].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[9].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition9
    extends AllNestedConditions {
        public ConfigCondition9() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[8].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[8].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition8
    extends AllNestedConditions {
        public ConfigCondition8() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[7].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[7].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition7
    extends AllNestedConditions {
        public ConfigCondition7() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[6].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[6].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition6
    extends AllNestedConditions {
        public ConfigCondition6() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[5].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[5].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition5
    extends AllNestedConditions {
        public ConfigCondition5() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[4].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[4].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition4
    extends AllNestedConditions {
        public ConfigCondition4() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[3].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[3].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition3
    extends AllNestedConditions {
        public ConfigCondition3() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[2].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[2].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition2
    extends AllNestedConditions {
        public ConfigCondition2() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[1].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[1].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition1
    extends AllNestedConditions {
        public ConfigCondition1() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[0].filter-method"}, havingValue="servlet", matchIfMissing=true)
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[0].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }
}

