/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.zuul;

import com.giffing.bucket4j.spring.boot.starter.config.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.metrics.Bucket4jMetricConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBoot1ActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.config.springboot.SpringBoot2ActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.zuul.ZuulRateLimitFilter;
import com.netflix.zuul.ZuulFilter;
import io.github.bucket4j.grid.ProxyManager;
import io.github.bucket4j.grid.jcache.JCache;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@ConditionalOnProperty(prefix="bucket4j", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ZuulFilter.class, JCache.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={SyncCacheResolver.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@Import(value={Bucket4jCacheConfiguration.class, Bucket4jMetricConfiguration.class, SpringBoot1ActuatorConfig.class, SpringBoot2ActuatorConfig.class})
public class Bucket4JAutoConfigurationZuul
extends Bucket4JBaseConfiguration<HttpServletRequest> {
    private Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationZuul.class);
    @Autowired
    private Bucket4JBootProperties properties;
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    @Autowired
    private SyncCacheResolver cacheResolver;

    @Bean
    @Qualifier(value="ZUUL")
    public Bucket4jConfigurationHolder zuulConfigurationHolder() {
        return new Bucket4jConfigurationHolder();
    }

    @Bean
    public ExpressionParser zuulExpressionParser() {
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        SpelExpressionParser parser = new SpelExpressionParser(config);
        return parser;
    }

    @Bean
    @Conditional(value={ConfigCondition1.class})
    public ZuulFilter zuulFilter1() {
        return this.createZuulFilter(0);
    }

    @Bean
    @Conditional(value={ConfigCondition2.class})
    public ZuulFilter zuulFilter2() {
        return this.createZuulFilter(1);
    }

    @Bean
    @Conditional(value={ConfigCondition3.class})
    public ZuulFilter zuulFilter3() {
        return this.createZuulFilter(2);
    }

    @Bean
    @Conditional(value={ConfigCondition4.class})
    public ZuulFilter zuulFilter4() {
        return this.createZuulFilter(3);
    }

    @Bean
    @Conditional(value={ConfigCondition5.class})
    public ZuulFilter zuulFilter5() {
        return this.createZuulFilter(4);
    }

    @Bean
    @Conditional(value={ConfigCondition6.class})
    public ZuulFilter zuulFilter6() {
        return this.createZuulFilter(5);
    }

    @Bean
    @Conditional(value={ConfigCondition7.class})
    public ZuulFilter zuulFilter7() {
        return this.createZuulFilter(6);
    }

    @Bean
    @Conditional(value={ConfigCondition8.class})
    public ZuulFilter zuulFilter8() {
        return this.createZuulFilter(7);
    }

    @Bean
    @Conditional(value={ConfigCondition9.class})
    public ZuulFilter zuulFilter9() {
        return this.createZuulFilter(8);
    }

    @Bean
    @Conditional(value={ConfigCondition10.class})
    public ZuulFilter zuulFilter10() {
        return this.createZuulFilter(9);
    }

    @Bean
    @Conditional(value={ConfigCondition11.class})
    public ZuulFilter zuulFilter11() {
        return this.createZuulFilter(10);
    }

    @Bean
    @Conditional(value={ConfigCondition12.class})
    public ZuulFilter zuulFilter12() {
        return this.createZuulFilter(11);
    }

    @Bean
    @Conditional(value={ConfigCondition13.class})
    public ZuulFilter zuulFilter13() {
        return this.createZuulFilter(12);
    }

    @Bean
    @Conditional(value={ConfigCondition14.class})
    public ZuulFilter zuulFilter14() {
        return this.createZuulFilter(13);
    }

    @Bean
    @Conditional(value={ConfigCondition15.class})
    public ZuulFilter zuulFilter15() {
        return this.createZuulFilter(14);
    }

    @Bean
    @Conditional(value={ConfigCondition16.class})
    public ZuulFilter zuulFilter16() {
        return this.createZuulFilter(15);
    }

    @Bean
    @Conditional(value={ConfigCondition17.class})
    public ZuulFilter zuulFilter17() {
        return this.createZuulFilter(16);
    }

    @Bean
    @Conditional(value={ConfigCondition18.class})
    public ZuulFilter zuulFilter18() {
        return this.createZuulFilter(17);
    }

    @Bean
    @Conditional(value={ConfigCondition19.class})
    public ZuulFilter zuulFilter19() {
        return this.createZuulFilter(18);
    }

    @Bean
    @Conditional(value={ConfigCondition20.class})
    public ZuulFilter zuulFilter20() {
        return this.createZuulFilter(19);
    }

    private ZuulFilter createZuulFilter(int position) {
        Integer filterCount = 0;
        if (this.properties.getFilters().size() >= position + 1) {
            Bucket4JConfiguration filter = (Bucket4JConfiguration)this.properties.getFilters().get(position);
            Integer n = filterCount;
            Integer n2 = filterCount = Integer.valueOf(filterCount + 1);
            FilterConfiguration filterConfig = this.buildFilterConfig(filter, this.createProxyManager(filter), this.zuulExpressionParser(), this.beanFactory);
            this.zuulConfigurationHolder().addFilterConfiguration(filter);
            this.log.info("create-zuul-filter;{};{};{}", new Object[]{position, filter.getCacheName(), filter.getUrl()});
            return new ZuulRateLimitFilter(filterConfig);
        }
        return null;
    }

    @Override
    protected ProxyManager<String> createProxyManager(Bucket4JConfiguration config) {
        return this.cacheResolver.resolve(config.getCacheName());
    }

    public static class ConfigCondition20
    extends AllNestedConditions {
        public ConfigCondition20() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[19].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[19].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition19
    extends AllNestedConditions {
        public ConfigCondition19() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[18].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[18].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition18
    extends AllNestedConditions {
        public ConfigCondition18() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[17].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[17].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition17
    extends AllNestedConditions {
        public ConfigCondition17() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[16].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[16].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition16
    extends AllNestedConditions {
        public ConfigCondition16() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[15].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[15].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition15
    extends AllNestedConditions {
        public ConfigCondition15() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[14].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[14].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition14
    extends AllNestedConditions {
        public ConfigCondition14() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[13].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[13].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition13
    extends AllNestedConditions {
        public ConfigCondition13() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[12].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[12].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition12
    extends AllNestedConditions {
        public ConfigCondition12() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[11].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[11].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition11
    extends AllNestedConditions {
        public ConfigCondition11() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[10].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[10].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition10
    extends AllNestedConditions {
        public ConfigCondition10() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[9].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[9].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition9
    extends AllNestedConditions {
        public ConfigCondition9() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[8].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[8].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition8
    extends AllNestedConditions {
        public ConfigCondition8() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[7].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[7].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition7
    extends AllNestedConditions {
        public ConfigCondition7() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[6].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[6].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition6
    extends AllNestedConditions {
        public ConfigCondition6() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[5].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[5].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition5
    extends AllNestedConditions {
        public ConfigCondition5() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[4].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[4].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition4
    extends AllNestedConditions {
        public ConfigCondition4() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[3].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[3].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition3
    extends AllNestedConditions {
        public ConfigCondition3() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[2].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[2].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition2
    extends AllNestedConditions {
        public ConfigCondition2() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[1].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[1].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }

    public static class ConfigCondition1
    extends AllNestedConditions {
        public ConfigCondition1() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[0].filter-method"}, havingValue="zuul")
        static class OnServletFilter {
            OnServletFilter() {
            }
        }

        @ConditionalOnProperty(prefix="bucket4j", value={"filters[0].url"})
        static class OnEnabled {
            OnEnabled() {
            }
        }
    }
}

