/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.webflux;

import com.giffing.bucket4j.spring.boot.starter.context.ConsumptionProbeHolder;
import com.giffing.bucket4j.spring.boot.starter.context.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitConditionMatchingStrategy;
import com.giffing.bucket4j.spring.boot.starter.webflux.WebfluxRateLimitException;
import io.github.bucket4j.ConsumptionProbe;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebfluxWebFilter
implements WebFilter {
    private FilterConfiguration<ServerHttpRequest> filterConfig;

    public WebfluxWebFilter(FilterConfiguration<ServerHttpRequest> filterConfig) {
        this.filterConfig = filterConfig;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        if (request.getURI().getPath().matches(this.filterConfig.getUrl())) {
            ArrayList<CompletionStage> rateLimitFutures = new ArrayList<CompletionStage>();
            for (RateLimitCheck rl : this.filterConfig.getRateLimitChecks()) {
                ConsumptionProbeHolder probeHolder = rl.rateLimit((Object)request, true);
                if (probeHolder == null || probeHolder.getConsumptionProbeCompletableFuture() == null) continue;
                CompletableFuture limitCheckingFuture = probeHolder.getConsumptionProbeCompletableFuture();
                rateLimitFutures.add(limitCheckingFuture.thenCompose(probe -> {
                    if (probe.isConsumed()) {
                        return CompletableFuture.completedFuture(probe.getRemainingTokens());
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }
            CompletableFuture reduced = rateLimitFutures.stream().reduce(null, (a1, b1) -> {
                if (a1 == null) {
                    return b1;
                }
                if (this.filterConfig.getStrategy().equals((Object)RateLimitConditionMatchingStrategy.FIRST)) {
                    return a1;
                }
                return a1.thenCombine((CompletionStage)b1, (x, y) -> {
                    if (x == null && y == null) {
                        return null;
                    }
                    if (x != null && y == null) {
                        return x;
                    }
                    if (x == null && y != null) {
                        return y;
                    }
                    return x < y ? x : y;
                });
            });
            Long remainingLimit = null;
            if (reduced != null) {
                remainingLimit = (Long)reduced.join();
            }
            if (remainingLimit == null || remainingLimit <= 0L) {
                throw new WebfluxRateLimitException(this.filterConfig.getHttpResponseBody());
            }
            if (remainingLimit != null) {
                response.getHeaders().set("X-Rate-Limit-Remaining", "" + remainingLimit);
            }
            return chain.filter(exchange);
        }
        return Mono.never();
    }

    private long getRemainingLimit(Long remaining, ConsumptionProbe probe) {
        if (probe != null) {
            if (remaining == null) {
                remaining = probe.getRemainingTokens();
            } else if (probe.getRemainingTokens() < remaining) {
                remaining = probe.getRemainingTokens();
            }
        }
        return remaining;
    }
}

