/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResult;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResultWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricBucketListener;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheResolverTemplate<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheResolverTemplate.class);

    public ProxyManagerWrapper resolve(String cacheName) {
        AbstractProxyManager<T> proxyManager = this.getProxyManager(cacheName);
        return (key, numTokens, estimate, bucketConfiguration, metricsListener, version, replaceStrategy) -> {
            if (this.isAsync()) {
                AsyncBucketProxy bucket = this.getAsyncBucketProxy(key, bucketConfiguration, metricsListener, version, replaceStrategy, proxyManager);
                CompletableFuture<RateLimitResult> result = estimate ? this.getAsyncEstimatedRateLimit(key, numTokens, estimate, bucket) : this.getAsyncRateLimit(numTokens, bucket);
                return new RateLimitResultWrapper(result);
            }
            Bucket bucket = this.getSyncBucket(key, bucketConfiguration, metricsListener, version, replaceStrategy, proxyManager);
            log.debug("execute-rate-limit;sync:{};key:{};numTokens:{};estimate:{}", new Object[]{false, key, numTokens, estimate});
            if (estimate) {
                return this.getSyncEstimatedRateLimit(numTokens, bucket);
            }
            return this.getSyncRateLimit(numTokens, bucket);
        };
    }

    public abstract T castStringToCacheKey(String var1);

    public abstract boolean isAsync();

    public abstract AbstractProxyManager<T> getProxyManager(String var1);

    private RateLimitResultWrapper getSyncRateLimit(Integer numTokens, Bucket bucket) {
        log.debug("consume-token");
        ConsumptionProbe consumptionProbe = bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue());
        RateLimitResult result = this.mapToRateLimitResult(consumptionProbe);
        return new RateLimitResultWrapper(result);
    }

    private RateLimitResultWrapper getSyncEstimatedRateLimit(Integer numTokens, Bucket bucket) {
        EstimationProbe estimatedConsumptionProbe = bucket.estimateAbilityToConsume((long)numTokens.intValue());
        if (estimatedConsumptionProbe.canBeConsumed()) {
            log.debug("estimation-can-consume no token taken");
            RateLimitResult result = this.mapToRateLimitResult(estimatedConsumptionProbe);
            return new RateLimitResultWrapper(result);
        }
        log.debug("estimation-cannot-consume take tokens");
        ConsumptionProbe consumptionProbe = bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue());
        RateLimitResult result = this.mapToRateLimitResult(consumptionProbe);
        return new RateLimitResultWrapper(result);
    }

    private CompletableFuture<RateLimitResult> getAsyncRateLimit(Integer numTokens, AsyncBucketProxy bucket) {
        CompletionStage result = bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()).thenApply(consumptionProbe -> {
            log.debug("consume-token");
            return this.mapToRateLimitResult((ConsumptionProbe)consumptionProbe);
        });
        return result;
    }

    private CompletableFuture<RateLimitResult> getAsyncEstimatedRateLimit(String key, Integer numTokens, boolean estimate, AsyncBucketProxy bucket) {
        CompletionStage result = bucket.estimateAbilityToConsume((long)numTokens.intValue()).thenCompose(ecp -> {
            log.debug("execute-rate-limit;sync:{};key:{};numTokens:{};estimate:{}", new Object[]{true, key, numTokens, estimate});
            if (ecp.canBeConsumed()) {
                log.debug("estimation-can-consume no token taken");
                return CompletableFuture.completedFuture(this.mapToRateLimitResult((EstimationProbe)ecp));
            }
            log.debug("estimation-cannot-consume take tokens");
            return bucket.tryConsumeAndReturnRemaining((long)numTokens.intValue()).thenApply(this::mapToRateLimitResult);
        });
        return result;
    }

    private Bucket getSyncBucket(String key, BucketConfiguration bucketConfiguration, MetricBucketListener metricsListener, long version, TokensInheritanceStrategy replaceStrategy, AbstractProxyManager<T> proxyManager) {
        return proxyManager.builder().withImplicitConfigurationReplacement(version, replaceStrategy).build(this.castStringToCacheKey(key), () -> bucketConfiguration).toListenable((BucketListener)metricsListener);
    }

    private AsyncBucketProxy getAsyncBucketProxy(String key, BucketConfiguration bucketConfiguration, MetricBucketListener metricsListener, long version, TokensInheritanceStrategy replaceStrategy, AbstractProxyManager<T> proxyManager) {
        return proxyManager.asAsync().builder().withImplicitConfigurationReplacement(version, replaceStrategy).build(this.castStringToCacheKey(key), () -> CompletableFuture.completedFuture(bucketConfiguration)).toListenable((BucketListener)metricsListener);
    }

    private RateLimitResult mapToRateLimitResult(EstimationProbe estimatedConsumptionProbe) {
        return RateLimitResult.builder().estimation(true).consumed(estimatedConsumptionProbe.canBeConsumed()).remainingTokens(estimatedConsumptionProbe.getRemainingTokens()).nanosToWaitForReset(0L).nanosToWaitForRefill(estimatedConsumptionProbe.getNanosToWaitForRefill()).build();
    }

    private RateLimitResult mapToRateLimitResult(ConsumptionProbe cp) {
        return RateLimitResult.builder().estimation(false).consumed(cp.isConsumed()).remainingTokens(cp.getRemainingTokens()).nanosToWaitForReset(cp.getNanosToWaitForReset()).nanosToWaitForRefill(cp.getNanosToWaitForRefill()).build();
    }
}

