/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.jcache;

import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.jcache.InfinispanJCacheCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnCache;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnFilterConfigCacheEnabled;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnSynchronousPropertyCondition;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import javax.cache.Caching;
import org.infinispan.manager.CacheContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnSynchronousPropertyCondition
@ConditionalOnClass(value={CacheContainer.class, Caching.class, JCacheCacheManager.class})
@ConditionalOnBean(value={CacheContainer.class})
@ConditionalOnCache(value="jcache-ignite")
public class InfinispanJCacheBucket4jConfiguration {
    private final CacheContainer cacheContainer;
    private final String configCacheName;

    public InfinispanJCacheBucket4jConfiguration(CacheContainer cacheContainer, Bucket4JBootProperties properties) {
        this.cacheContainer = cacheContainer;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    @ConditionalOnMissingBean(value={SyncCacheResolver.class})
    public SyncCacheResolver bucket4jCacheResolver() {
        return new InfinispanJCacheCacheResolver(this.cacheContainer);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnFilterConfigCacheEnabled
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new InfinispanCacheManager<String, Bucket4JConfiguration>(this.cacheContainer.getCache(this.configCacheName));
    }

    @Bean
    @ConditionalOnFilterConfigCacheEnabled
    public InfinispanCacheListener<String, Bucket4JConfiguration> configCacheListener(ApplicationEventPublisher eventPublisher) {
        return new InfinispanCacheListener<String, Bucket4JConfiguration>(this.cacheContainer.getCache(this.configCacheName), eventPublisher);
    }
}

