/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.gateway;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnBucket4jEnabled;
import com.giffing.bucket4j.spring.boot.starter.config.filter.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.gateway.Bucket4JAutoConfigurationSpringCloudGatewayFilterBeans;
import com.giffing.bucket4j.spring.boot.starter.config.filter.reactive.predicate.WebfluxExecutePredicateConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.metrics.actuator.SpringBootActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.config.service.ServiceConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.reactive.gateway.SpringCloudGatewayRateLimitFilter;
import com.giffing.bucket4j.spring.boot.starter.service.RateLimitService;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBucket4jEnabled
@ConditionalOnClass(value={GlobalFilter.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@AutoConfigureBefore(value={GatewayAutoConfiguration.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={AsyncCacheResolver.class})
@Import(value={ServiceConfiguration.class, WebfluxExecutePredicateConfiguration.class, SpringBootActuatorConfig.class, Bucket4JAutoConfigurationSpringCloudGatewayFilterBeans.class})
public class Bucket4JAutoConfigurationSpringCloudGatewayFilter
extends Bucket4JBaseConfiguration<ServerHttpRequest, ServerHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationSpringCloudGatewayFilter.class);
    private final Bucket4JBootProperties properties;
    private final GenericApplicationContext context;
    private final AsyncCacheResolver cacheResolver;
    private final RateLimitService rateLimitService;
    private final Bucket4jConfigurationHolder gatewayConfigurationHolder;

    public Bucket4JAutoConfigurationSpringCloudGatewayFilter(Bucket4JBootProperties properties, GenericApplicationContext context, AsyncCacheResolver cacheResolver, List<MetricHandler> metricHandlers, List<ExecutePredicate<ServerHttpRequest>> executePredicates, Bucket4jConfigurationHolder gatewayConfigurationHolder, RateLimitService rateLimitService, @Autowired(required=false) CacheManager<String, Bucket4JConfiguration> configCacheManager) {
        super(rateLimitService, configCacheManager, metricHandlers, executePredicates.stream().collect(Collectors.toMap(ExecutePredicate::name, Function.identity())));
        this.properties = properties;
        this.context = context;
        this.cacheResolver = cacheResolver;
        this.rateLimitService = rateLimitService;
        this.gatewayConfigurationHolder = gatewayConfigurationHolder;
        this.initFilters();
    }

    public void initFilters() {
        AtomicInteger filterCount = new AtomicInteger(0);
        this.properties.getFilters().stream().filter(filter -> StringUtils.hasText((String)filter.getUrl()) && filter.getFilterMethod().equals((Object)FilterMethod.GATEWAY)).map(filter -> this.properties.isFilterConfigCachingEnabled() ? this.getOrUpdateConfigurationFromCache((Bucket4JConfiguration)filter) : filter).forEach(filter -> {
            this.rateLimitService.addDefaultMetricTags(this.properties, (Bucket4JConfiguration)filter);
            filterCount.incrementAndGet();
            FilterConfiguration filterConfig = this.buildFilterConfig((Bucket4JConfiguration)filter, this.cacheResolver.resolve(filter.getCacheName()));
            this.gatewayConfigurationHolder.addFilterConfiguration(filter);
            Object beanName = filter.getId() != null ? filter.getId() : "bucket4JGatewayFilter" + filterCount;
            this.context.registerBean((String)beanName, GlobalFilter.class, () -> new SpringCloudGatewayRateLimitFilter((FilterConfiguration<ServerHttpRequest, ServerHttpResponse>)filterConfig), new BeanDefinitionCustomizer[0]);
            log.info("create-gateway-filter;{};{};{}", new Object[]{filterCount, filter.getCacheName(), filter.getUrl()});
        });
    }

    @Override
    public void onCacheUpdateEvent(CacheUpdateEvent<String, Bucket4JConfiguration> event) {
        Bucket4JConfiguration newConfig = event.getNewValue();
        if (newConfig.getFilterMethod().equals((Object)FilterMethod.GATEWAY)) {
            try {
                SpringCloudGatewayRateLimitFilter filter = (SpringCloudGatewayRateLimitFilter)this.context.getBean(event.getKey(), SpringCloudGatewayRateLimitFilter.class);
                FilterConfiguration newFilterConfig = this.buildFilterConfig(newConfig, this.cacheResolver.resolve(newConfig.getCacheName()));
                filter.setFilterConfig(newFilterConfig);
            }
            catch (Exception exception) {
                log.warn("Failed to update Gateway Filter configuration. {}", (Object)exception.getMessage());
            }
        }
    }
}

