/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.service;

import com.giffing.bucket4j.spring.boot.starter.context.ExpressionParams;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionService {
    private static final Logger log = LoggerFactory.getLogger(ExpressionService.class);
    private final ExpressionParser expressionParser;
    private final ConfigurableBeanFactory beanFactory;

    public <R> String parseString(String expression, ExpressionParams<R> params) {
        StandardEvaluationContext context = this.getContext(params.getParams());
        Expression expr = this.expressionParser.parseExpression(expression);
        String result = (String)expr.getValue((EvaluationContext)context, params.getRootObject(), String.class);
        log.debug("parse-string-expression;result:{};expression:{};root:{};params:{}", new Object[]{result, expression, params.getRootObject(), params.getParams()});
        return result;
    }

    public <R> Boolean parseBoolean(String expression, ExpressionParams<R> params) {
        StandardEvaluationContext context = this.getContext(params.getParams());
        Expression expr = this.expressionParser.parseExpression(expression);
        boolean result = Boolean.TRUE.equals(expr.getValue((EvaluationContext)context, params.getRootObject(), Boolean.class));
        log.debug("parse-boolean-expression;result:{};expression:{};root:{};params:{}", new Object[]{result, expression, params.getRootObject(), params.getParams()});
        return result;
    }

    private StandardEvaluationContext getContext(Map<String, Object> params) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        params.forEach((arg_0, arg_1) -> ((StandardEvaluationContext)context).setVariable(arg_0, arg_1));
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.beanFactory));
        return context;
    }

    public ExpressionService(ExpressionParser expressionParser, ConfigurableBeanFactory beanFactory) {
        this.expressionParser = expressionParser;
        this.beanFactory = beanFactory;
    }
}

