/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnBucket4jEnabled;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.IgnoreRateLimiting;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimiting;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MethodProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.exception.NoCacheConfiguredException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitUnknownParameterException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackMethodNotFoundException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackMethodParameterMismatchException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackReturnTypesMismatchException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingMethodNameNotConfiguredException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingMultipleFallbackMethodsFoundException;
import com.giffing.bucket4j.spring.boot.starter.utils.RateLimitAopUtils;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.ast.VariableReference;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBucket4jEnabled
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
public class Bucket4jStartupCheckConfiguration {
    private final Bucket4JBootProperties properties;
    @Nullable
    private final SyncCacheResolver syncCacheResolver;
    @Nullable
    private final AsyncCacheResolver asyncCacheResolver;
    private final AbstractApplicationContext context;
    private final ConfigurableListableBeanFactory configurableListableBeanFactory;
    private SpelExpressionParser parser;

    @EventListener
    public void applicationReady(ApplicationReadyEvent event) {
        this.assertCacheConfiguration();
        this.assertValidAnnotationConfiguration();
    }

    private void assertValidAnnotationConfiguration() {
        SpelParserConfiguration config = new SpelParserConfiguration(SpelCompilerMode.IMMEDIATE, this.getClass().getClassLoader());
        this.parser = new SpelExpressionParser(config);
        List<Class<?>> rateLimitingAnnotatedClasses = this.getRateLimitingAnnotatedClasses();
        for (Class<?> rateLimitClass : rateLimitingAnnotatedClasses) {
            for (Method method : rateLimitClass.getMethods()) {
                RateLimiting rateLimitingAnnotation = RateLimitAopUtils.getAnnotationFromMethodOrClass(method, RateLimiting.class);
                if (rateLimitingAnnotation == null) continue;
                this.assertMethodNameExistsInProperties(rateLimitClass, method, rateLimitingAnnotation);
                MethodProperties methodProperties = this.getPropertyFromConfigName(rateLimitingAnnotation.name());
                RateLimit rateLimit = methodProperties.getRateLimit();
                String executeConditionExpression = StringUtils.hasText((String)rateLimitingAnnotation.executeCondition()) ? rateLimitingAnnotation.executeCondition() : rateLimit.getExecuteCondition();
                this.assertValidExpression(rateLimitClass, method, executeConditionExpression);
                String skipConditionExpression = StringUtils.hasText((String)rateLimitingAnnotation.skipCondition()) ? rateLimitingAnnotation.skipCondition() : rateLimit.getSkipCondition();
                this.assertValidExpression(rateLimitClass, method, skipConditionExpression);
                String cacheKeyExpression = StringUtils.hasText((String)rateLimitingAnnotation.cacheKey()) ? rateLimitingAnnotation.cacheKey() : rateLimit.getCacheKey();
                this.assertValidExpression(rateLimitClass, method, cacheKeyExpression);
                Bucket4jStartupCheckConfiguration.assertValidFallbackMethod(rateLimitClass, method, rateLimitingAnnotation);
            }
        }
    }

    private static void assertValidFallbackMethod(Class<?> rateLimitClass, Method method, RateLimiting rateLimitingAnnotation) {
        String fallbackMethodName = rateLimitingAnnotation.fallbackMethodName();
        if (StringUtils.hasText((String)fallbackMethodName)) {
            List<Method> fallbackMethods = Arrays.stream(method.getDeclaringClass().getMethods()).filter(p -> p.getName().equals(fallbackMethodName)).toList();
            if (fallbackMethods.isEmpty()) {
                throw new RateLimitingFallbackMethodNotFoundException(fallbackMethodName, rateLimitClass.getName(), method.getName());
            }
            if (fallbackMethods.size() > 1) {
                throw new RateLimitingMultipleFallbackMethodsFoundException(fallbackMethodName, rateLimitClass.getName(), method.getName());
            }
            Method fallbackMethod = fallbackMethods.get(0);
            if (!method.getReturnType().equals(fallbackMethod.getReturnType())) {
                throw new RateLimitingFallbackReturnTypesMismatchException(fallbackMethodName, rateLimitClass.getName(), method.getName(), method.getReturnType().toGenericString(), fallbackMethod.getReturnType().toGenericString());
            }
            if (!Arrays.equals(method.getParameterTypes(), fallbackMethod.getParameterTypes())) {
                throw new RateLimitingFallbackMethodParameterMismatchException(fallbackMethodName, rateLimitClass.getName(), method.getName(), Bucket4jStartupCheckConfiguration.getParametersAsString(method), Bucket4jStartupCheckConfiguration.getParametersAsString(fallbackMethod));
            }
        }
    }

    @NotNull
    private static String getParametersAsString(Method method) {
        return Arrays.stream(method.getParameters()).map(p -> p.getName() + ":" + p.getType()).collect(Collectors.joining(";"));
    }

    private MethodProperties getPropertyFromConfigName(String configName) {
        return this.properties.getMethods().stream().filter(mc -> mc.getName().equals(configName)).findFirst().orElseThrow(() -> new IllegalStateException("Could not find config with name " + configName));
    }

    private void assertMethodNameExistsInProperties(Class<?> rateLimitClass, Method method, RateLimiting rateLimitingAnnotation) {
        Set<String> methodConfigNames = this.properties.getMethods().stream().map(MethodProperties::getName).collect(Collectors.toSet());
        if (!methodConfigNames.contains(rateLimitingAnnotation.name())) {
            throw new RateLimitingMethodNameNotConfiguredException(rateLimitingAnnotation.name(), methodConfigNames, rateLimitClass.getName(), method.getName());
        }
    }

    private void assertValidExpression(Class<?> rateLimitClass, Method method, String expression) {
        if (StringUtils.hasText((String)expression)) {
            SpelExpression executeConditionExpression = (SpelExpression)this.parser.parseExpression(expression);
            Set<String> parameterInExpression = Bucket4jStartupCheckConfiguration.getParametersFromSpelNode(executeConditionExpression.getAST());
            Set<String> parameterFromMethod = Arrays.stream(method.getParameters()).map(Parameter::getName).collect(Collectors.toSet());
            if (!parameterFromMethod.containsAll(parameterInExpression)) {
                throw new RateLimitUnknownParameterException(expression, rateLimitClass.getName(), method.getName(), parameterFromMethod);
            }
        }
    }

    @NotNull
    private static Set<String> getParametersFromSpelNode(SpelNode spelNode) {
        HashSet<String> params = new HashSet<String>();
        if (spelNode instanceof VariableReference) {
            VariableReference r = (VariableReference)spelNode;
            params.add(r.toStringAST().substring(1));
        }
        for (int childIndex = 0; childIndex < spelNode.getChildCount(); ++childIndex) {
            SpelNode child = spelNode.getChild(childIndex);
            if (child instanceof VariableReference) {
                VariableReference r = (VariableReference)child;
                params.add(r.toStringAST().substring(1));
            }
            params.addAll(Bucket4jStartupCheckConfiguration.getParametersFromSpelNode(child));
        }
        return params;
    }

    private List<? extends Class<?>> getRateLimitingAnnotatedClasses() {
        return Arrays.stream(this.context.getBeanDefinitionNames()).map(arg_0 -> ((ConfigurableListableBeanFactory)this.configurableListableBeanFactory).getBeanDefinition(arg_0)).map(bd -> bd.getResolvableType().resolve()).filter(Objects::nonNull).filter(targetClass -> {
            boolean excludeClassesAnnotatedWithIgnoreRateLimiting = !targetClass.isAnnotationPresent(IgnoreRateLimiting.class);
            boolean methodsWhereTheClassIsAnnotatedWithRateLimiting = targetClass.isAnnotationPresent(RateLimiting.class);
            boolean methodsThatAreAnnotatedWithRateLimitingButWithoutIgnoringRateLimiting = Arrays.stream(targetClass.getMethods()).anyMatch(m -> m.isAnnotationPresent(RateLimiting.class) && !m.isAnnotationPresent(IgnoreRateLimiting.class));
            return excludeClassesAnnotatedWithIgnoreRateLimiting && (methodsWhereTheClassIsAnnotatedWithRateLimiting || methodsThatAreAnnotatedWithRateLimitingButWithoutIgnoringRateLimiting);
        }).toList();
    }

    private void assertCacheConfiguration() {
        if (this.syncCacheResolver == null && this.asyncCacheResolver == null) {
            throw new NoCacheConfiguredException(this.properties.getCacheToUse());
        }
        Set<FilterMethod> filterMethods = this.getAllFilterMethods();
        this.checkCacheResolverForFiltersIsRequired(this.syncCacheResolver == null, filterMethods, Set.of(FilterMethod.SERVLET));
        this.checkCacheResolverForFiltersIsRequired(this.asyncCacheResolver == null, filterMethods, Set.of(FilterMethod.WEBFLUX, FilterMethod.GATEWAY));
    }

    private Set<FilterMethod> getAllFilterMethods() {
        return this.properties.getFilters().stream().map(Bucket4JConfiguration::getFilterMethod).collect(Collectors.toSet());
    }

    private void checkCacheResolverForFiltersIsRequired(boolean cacheResolverNotExists, Set<FilterMethod> filterMethodsToCheck, Set<FilterMethod> configuredFilterMethods) {
        boolean filterFound = configuredFilterMethods.stream().anyMatch(filterMethodsToCheck::contains);
        if (filterFound && cacheResolverNotExists) {
            throw new NoCacheConfiguredException(this.properties.getCacheToUse());
        }
    }

    public Bucket4jStartupCheckConfiguration(Bucket4JBootProperties properties, @Nullable SyncCacheResolver syncCacheResolver, @Nullable AsyncCacheResolver asyncCacheResolver, AbstractApplicationContext context, ConfigurableListableBeanFactory configurableListableBeanFactory) {
        this.properties = properties;
        this.syncCacheResolver = syncCacheResolver;
        this.asyncCacheResolver = asyncCacheResolver;
        this.context = context;
        this.configurableListableBeanFactory = configurableListableBeanFactory;
    }
}

