/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheListener;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.infinispan.InfinispanCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnAsynchronousPropertyCondition;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnCache;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnFilterConfigCacheEnabled;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import org.infinispan.manager.CacheContainer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnAsynchronousPropertyCondition
@ConditionalOnClass(value={CacheContainer.class})
@ConditionalOnBean(value={CacheContainer.class})
@ConditionalOnMissingBean(value={AsyncCacheResolver.class})
@ConditionalOnCache(value="infinispan")
public class InfinispanBucket4jCacheConfiguration {
    private final CacheContainer cacheContainer;
    private final String configCacheName;

    public InfinispanBucket4jCacheConfiguration(CacheContainer cacheContainer, Bucket4JBootProperties properties) {
        this.cacheContainer = cacheContainer;
        this.configCacheName = properties.getFilterConfigCacheName();
    }

    @Bean
    public AsyncCacheResolver infinispanCacheResolver() {
        return new InfinispanCacheResolver(this.cacheContainer);
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheManager.class})
    @ConditionalOnFilterConfigCacheEnabled
    public CacheManager<String, Bucket4JConfiguration> configCacheManager() {
        return new InfinispanCacheManager<String, Bucket4JConfiguration>(this.cacheContainer.getCache(this.configCacheName));
    }

    @Bean
    @ConditionalOnFilterConfigCacheEnabled
    public InfinispanCacheListener<String, Bucket4JConfiguration> configCacheListener(ApplicationEventPublisher eventPublisher) {
        return new InfinispanCacheListener<String, Bucket4JConfiguration>(this.cacheContainer.getCache(this.configCacheName), eventPublisher);
    }
}

