/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.jedis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

public class JedisCacheListener<K, V>
extends JedisPubSub {
    private static final Logger log = LoggerFactory.getLogger(JedisCacheListener.class);
    private final JedisPool jedisPool;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String updateChannel;
    private final JavaType deserializeType;
    private ApplicationEventPublisher eventPublisher;

    public JedisCacheListener(JedisPool jedisPool, String cacheName, Class<K> keyType, Class<V> valueType, ApplicationEventPublisher eventPublisher) {
        this.jedisPool = jedisPool;
        this.updateChannel = cacheName.concat(":update");
        this.deserializeType = this.objectMapper.getTypeFactory().constructParametricType(CacheUpdateEvent.class, new Class[]{keyType, valueType});
        this.eventPublisher = eventPublisher;
        this.subscribe();
    }

    public void subscribe() {
        Thread thread = new Thread(() -> {
            AtomicInteger reconnectBackoffTimeMillis = new AtomicInteger(1000);
            ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("reset-reconnect-backoff-thread"));
            ScheduledFuture<?> resetTask = null;
            while (!Thread.currentThread().isInterrupted() && !this.jedisPool.isClosed()) {
                try {
                    Jedis jedis = this.jedisPool.getResource();
                    try {
                        resetTask = executorService.schedule(() -> reconnectBackoffTimeMillis.set(1000), 10000L, TimeUnit.MILLISECONDS);
                        jedis.subscribe((JedisPubSub)this, new String[]{this.updateChannel});
                    }
                    finally {
                        if (jedis == null) continue;
                        jedis.close();
                    }
                }
                catch (Exception e) {
                    log.error("Failed to connect the Jedis subscriber, attempting to reconnect in {} seconds. Exception was: {}", (Object)(reconnectBackoffTimeMillis.get() / 1000), (Object)e.getMessage());
                    if (resetTask != null) {
                        resetTask.cancel(true);
                        resetTask = null;
                    }
                    try {
                        Thread.sleep(reconnectBackoffTimeMillis.get());
                        reconnectBackoffTimeMillis.set(Math.min(reconnectBackoffTimeMillis.get() * 2, 30000));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "JedisSubscriberThread");
        thread.setDaemon(true);
        thread.start();
    }

    public void onMessage(String channel, String message) {
        if (channel.equals(this.updateChannel)) {
            this.onCacheUpdateEvent(message);
        } else {
            log.debug("Unsupported cache event received of type ");
        }
    }

    private void onCacheUpdateEvent(String message) {
        try {
            CacheUpdateEvent event = (CacheUpdateEvent)this.objectMapper.readValue(message, this.deserializeType);
            this.eventPublisher.publishEvent((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

