/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.cache.redis.lettuce;

import com.giffing.bucket4j.spring.boot.starter.config.cache.AbstractCacheResolverTemplate;
import com.giffing.bucket4j.spring.boot.starter.config.cache.AsyncCacheResolver;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.redis.lettuce.cas.LettuceBasedProxyManager;
import io.lettuce.core.RedisClient;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class LettuceCacheResolver
extends AbstractCacheResolverTemplate<byte[]>
implements AsyncCacheResolver {
    private final RedisClient redisClient;

    public LettuceCacheResolver(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    @Override
    public AbstractProxyManager<byte[]> getProxyManager(String cacheName) {
        return ((LettuceBasedProxyManager.LettuceBasedProxyManagerBuilder)LettuceBasedProxyManager.builderFor((RedisClient)this.redisClient).withExpirationStrategy(ExpirationAfterWriteStrategy.basedOnTimeForRefillingBucketUpToMax((Duration)Duration.ofSeconds(10L)))).build();
    }

    @Override
    public byte[] castStringToCacheKey(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }
}

