/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.condition;

import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnAsynchronousPropertyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Bucket4JBootProperties bucket4jProperties = (Bucket4JBootProperties)Binder.get((Environment)context.getEnvironment()).bind("bucket4j", Bucket4JBootProperties.class).orElse(null);
        if (bucket4jProperties == null) {
            return ConditionOutcome.noMatch((String)"@ConditionalOnAsynchronousPropertyCondition Bucket4jBootProperties not configured");
        }
        boolean reactiveFilterConfigurationExists = bucket4jProperties.getFilters().stream().anyMatch(x -> List.of(FilterMethod.WEBFLUX, FilterMethod.GATEWAY).contains(x.getFilterMethod()));
        if (reactiveFilterConfigurationExists) {
            return ConditionOutcome.match((String)"@ConditionalOnAsynchronousPropertyCondition Found reactive filter");
        }
        return ConditionOutcome.noMatch((String)"@ConditionalOnAsynchronousPropertyCondition No filter configuration with FilterMethod.WEBFLUX org FilterMethod.GATEWAY configured");
    }
}

