/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.failureanalyzer;

import com.giffing.bucket4j.spring.boot.starter.exception.Bucket4jGeneralException;
import com.giffing.bucket4j.spring.boot.starter.exception.ExecutePredicateInstantiationException;
import com.giffing.bucket4j.spring.boot.starter.exception.JCacheNotFoundException;
import com.giffing.bucket4j.spring.boot.starter.exception.NoCacheConfiguredException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitUnknownParameterException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackMethodNotFoundException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackMethodParameterMismatchException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingFallbackReturnTypesMismatchException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingMethodNameNotConfiguredException;
import com.giffing.bucket4j.spring.boot.starter.exception.RateLimitingMultipleFallbackMethodsFoundException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class Bucket4JAutoConfigFailureAnalyzer
extends AbstractFailureAnalyzer<Bucket4jGeneralException> {
    public static final String NEW_LINE = System.lineSeparator();

    protected FailureAnalysis analyze(Throwable rootFailure, Bucket4jGeneralException cause) {
        Bucket4jGeneralException e;
        String descriptionMessage = cause.getMessage();
        Object actionMessage = cause.getMessage();
        if (cause instanceof JCacheNotFoundException) {
            e = (JCacheNotFoundException)cause;
            descriptionMessage = e.getMessage();
            actionMessage = "Cache name: " + ((JCacheNotFoundException)e).getCacheName() + NEW_LINE + "Please configure your caching provider (ehcache, hazelcast, ...)";
        }
        if (cause instanceof ExecutePredicateInstantiationException) {
            e = (ExecutePredicateInstantiationException)cause;
            descriptionMessage = e.getMessage();
            actionMessage = "Please provide a default constructor.";
        }
        if (cause instanceof NoCacheConfiguredException) {
            e = (NoCacheConfiguredException)cause;
            descriptionMessage = "No Bucket4j cache configuration found - cache-to-use: %s".formatted(((NoCacheConfiguredException)e).getCacheToUse());
            actionMessage = "    Please provide a valid cache configuration.\n    Check the documentation to see which caches are supported.\n    Check the example projects.\n    Use the debug=true property to determine which Bucket4j cache configuration has problems.\n    Provide your own SyncCacheResolver or AsyncCacheResolver.\n";
        }
        if (cause instanceof RateLimitUnknownParameterException) {
            e = (RateLimitUnknownParameterException)cause;
            descriptionMessage = "    Your Spring Expression contains parameters which does not exists in your method;\n        your expression: %s\n        available method parameter: %s\n        class name: %s\n        method name: %s\n".formatted(((RateLimitUnknownParameterException)e).getExpression(), String.join((CharSequence)", ", ((RateLimitUnknownParameterException)e).getMethodParameter()), ((RateLimitUnknownParameterException)e).getClassName(), ((RateLimitUnknownParameterException)e).getMethodName());
            actionMessage = "Please update your expression and use one of the available method parameters.\n";
        }
        if (cause instanceof RateLimitingMethodNameNotConfiguredException) {
            e = (RateLimitingMethodNameNotConfiguredException)cause;
            descriptionMessage = "Your name in @RateLimiting(name =\"%s\") is not configured in your properties\n    your name: %s\n    available method configs: %s\n    class name: %s\n    method name: %s\n".formatted(((RateLimitingMethodNameNotConfiguredException)e).getName(), ((RateLimitingMethodNameNotConfiguredException)e).getName(), String.join((CharSequence)",", ((RateLimitingMethodNameNotConfiguredException)e).getAvailableNames()), ((RateLimitingMethodNameNotConfiguredException)e).getClassName(), ((RateLimitingMethodNameNotConfiguredException)e).getMethodName());
            actionMessage = "Please check four property configuration bucket4j.methods[x].name for the reference in your annotation";
        }
        if (cause instanceof RateLimitingFallbackMethodNotFoundException) {
            e = (RateLimitingFallbackMethodNotFoundException)cause;
            descriptionMessage = "Your fallback method name in @RateLimiting(fallbackMethodName=\"%s\") was not found\n    your fallback method name: %s\n    class name: %s\n    method name: %s\n".formatted(((RateLimitingFallbackMethodNotFoundException)e).getFallbakcMethodName(), ((RateLimitingFallbackMethodNotFoundException)e).getFallbakcMethodName(), ((RateLimitingFallbackMethodNotFoundException)e).getClassName(), ((RateLimitingFallbackMethodNotFoundException)e).getMethodName());
            actionMessage = "Ensure that the fallback method exists in the same class";
        }
        if (cause instanceof RateLimitingMultipleFallbackMethodsFoundException) {
            e = (RateLimitingMultipleFallbackMethodsFoundException)cause;
            descriptionMessage = "Multiple fallback method names found. The fallback method name should be unique.\n    your fallback method name: %s\n    class name: %s\n    method name: %s\n".formatted(((RateLimitingMultipleFallbackMethodsFoundException)e).getFallbakcMethodName(), ((RateLimitingMultipleFallbackMethodsFoundException)e).getClassName(), ((RateLimitingMultipleFallbackMethodsFoundException)e).getMethodName());
            actionMessage = "Please provide only one fallback method under the given name.";
        }
        if (cause instanceof RateLimitingFallbackReturnTypesMismatchException) {
            e = (RateLimitingFallbackReturnTypesMismatchException)cause;
            descriptionMessage = "The return type of the fallback method does not match the rate limit method\n    your fallback method name: %s\n    class name: %s\n    method name: %s\n    return type: %s\n    fallback method return type: %s\n".formatted(((RateLimitingFallbackReturnTypesMismatchException)e).getFallbackMethodName(), ((RateLimitingFallbackReturnTypesMismatchException)e).getClassName(), ((RateLimitingFallbackReturnTypesMismatchException)e).getMethodName(), ((RateLimitingFallbackReturnTypesMismatchException)e).getReturnType(), ((RateLimitingFallbackReturnTypesMismatchException)e).getFallbackMethodReturnType());
            actionMessage = "Please update the return type of the fallback method.";
        }
        if (cause instanceof RateLimitingFallbackMethodParameterMismatchException) {
            e = (RateLimitingFallbackMethodParameterMismatchException)cause;
            descriptionMessage = "The parameters of the fallback method does not match the rate limit method parameters\n    your fallback method name: %s\n    class name: %s\n    method name: %s\n    parameters: %s\n    fallback method parameters: %s\n".formatted(((RateLimitingFallbackMethodParameterMismatchException)e).getFallbackMethodName(), ((RateLimitingFallbackMethodParameterMismatchException)e).getClassName(), ((RateLimitingFallbackMethodParameterMismatchException)e).getMethodName(), ((RateLimitingFallbackMethodParameterMismatchException)e).getParameters(), ((RateLimitingFallbackMethodParameterMismatchException)e).getFallbackMethodParameters());
            actionMessage = "Please use the same parameter signature for your fallback method like in the rate limit method.";
        }
        return new FailureAnalysis(descriptionMessage, (String)actionMessage, (Throwable)cause);
    }
}

