/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.predicate;

import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HeaderExecutePredicate<T>
extends ExecutePredicate<T> {
    private static final Logger log = LoggerFactory.getLogger(HeaderExecutePredicate.class);
    private String headername;
    private String headerValueRegex;

    public boolean testHeaderValues(List<String> headerValues) {
        if (headerValues.isEmpty()) {
            return false;
        }
        boolean matches = true;
        if (this.headerValueRegex != null) {
            matches = headerValues.stream().anyMatch(v -> v.matches(this.headerValueRegex));
        }
        log.debug("header-predicate;header:{};value:{},result:{}", new Object[]{this.headername, headerValues, matches});
        return matches;
    }

    public String name() {
        return "HEADER";
    }

    public ExecutePredicate<T> parseSimpleConfig(String simpleConfig) {
        List<String> headerConfig = Arrays.stream(simpleConfig.split(",")).map(String::trim).toList();
        if (headerConfig.size() > 2 || headerConfig.isEmpty()) {
            throw new IllegalArgumentException("Header Configuration failed");
        }
        this.headername = headerConfig.get(0);
        if (headerConfig.size() > 1) {
            this.headerValueRegex = headerConfig.get(1);
        }
        return this;
    }

    public String getHeadername() {
        return this.headername;
    }

    public String getHeaderValueRegex() {
        return this.headerValueRegex;
    }
}

