/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.predicate;

import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.PathContainer;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class PathExecutePredicate<T>
extends ExecutePredicate<T> {
    private static final Logger log = LoggerFactory.getLogger(PathExecutePredicate.class);
    private PathPatternParser pathPatternParser = new PathPatternParser();
    private List<PathPattern> pathPatterns = new ArrayList<PathPattern>();

    public boolean testPath(String servletPath) {
        PathContainer path = PathContainer.parsePath((String)servletPath);
        Optional<PathPattern> matches = this.pathPatterns.stream().filter(p -> p.matches(path)).findFirst();
        log.debug("path-predicate;path:{};value:{};result:{}", new Object[]{servletPath, this.pathPatterns, matches.isPresent()});
        return matches.isPresent();
    }

    public String name() {
        return "PATH";
    }

    public ExecutePredicate<T> parseSimpleConfig(String simpleConfig) {
        this.pathPatterns = Arrays.stream(simpleConfig.split(",")).map(String::trim).map(arg_0 -> ((PathPatternParser)this.pathPatternParser).parse(arg_0)).toList();
        return this;
    }
}

