/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.filter.servlet;

import com.giffing.bucket4j.spring.boot.starter.config.cache.Bucket4jCacheConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheManager;
import com.giffing.bucket4j.spring.boot.starter.config.cache.CacheUpdateEvent;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.config.condition.ConditionalOnBucket4jEnabled;
import com.giffing.bucket4j.spring.boot.starter.config.filter.Bucket4JBaseConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.filter.servlet.Bucket4JAutoConfigurationServletFilterBeans;
import com.giffing.bucket4j.spring.boot.starter.config.filter.servlet.predicate.ServletRequestExecutePredicateConfiguration;
import com.giffing.bucket4j.spring.boot.starter.config.metrics.actuator.SpringBootActuatorConfig;
import com.giffing.bucket4j.spring.boot.starter.config.service.ServiceConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.Bucket4jConfigurationHolder;
import com.giffing.bucket4j.spring.boot.starter.context.ExecutePredicate;
import com.giffing.bucket4j.spring.boot.starter.context.FilterMethod;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JConfiguration;
import com.giffing.bucket4j.spring.boot.starter.context.properties.FilterConfiguration;
import com.giffing.bucket4j.spring.boot.starter.filter.servlet.ServletRequestFilter;
import com.giffing.bucket4j.spring.boot.starter.service.RateLimitService;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnBucket4jEnabled
@ConditionalOnClass(value={Filter.class})
@EnableConfigurationProperties(value={Bucket4JBootProperties.class})
@AutoConfigureBefore(value={ServletWebServerFactoryAutoConfiguration.class})
@AutoConfigureAfter(value={CacheAutoConfiguration.class, Bucket4jCacheConfiguration.class})
@ConditionalOnBean(value={SyncCacheResolver.class})
@Import(value={ServiceConfiguration.class, ServletRequestExecutePredicateConfiguration.class, Bucket4JAutoConfigurationServletFilterBeans.class, Bucket4jCacheConfiguration.class, SpringBootActuatorConfig.class})
public class Bucket4JAutoConfigurationServletFilter
extends Bucket4JBaseConfiguration<HttpServletRequest, HttpServletResponse>
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(Bucket4JAutoConfigurationServletFilter.class);
    private final Bucket4JBootProperties properties;
    private final GenericApplicationContext context;
    private final SyncCacheResolver cacheResolver;
    private final RateLimitService rateLimitService;
    private final Bucket4jConfigurationHolder servletConfigurationHolder;

    public Bucket4JAutoConfigurationServletFilter(Bucket4JBootProperties properties, GenericApplicationContext context, SyncCacheResolver cacheResolver, List<MetricHandler> metricHandlers, List<ExecutePredicate<HttpServletRequest>> executePredicates, Bucket4jConfigurationHolder servletConfigurationHolder, RateLimitService rateLimitService, @Autowired(required=false) CacheManager<String, Bucket4JConfiguration> configCacheManager) {
        super(rateLimitService, configCacheManager, metricHandlers, executePredicates.stream().collect(Collectors.toMap(ExecutePredicate::name, Function.identity())));
        this.properties = properties;
        this.context = context;
        this.cacheResolver = cacheResolver;
        this.rateLimitService = rateLimitService;
        this.servletConfigurationHolder = servletConfigurationHolder;
    }

    public void customize(ConfigurableServletWebServerFactory factory) {
        AtomicInteger filterCount = new AtomicInteger(0);
        this.properties.getFilters().stream().filter(filter -> StringUtils.hasText((String)filter.getUrl()) && filter.getFilterMethod().equals((Object)FilterMethod.SERVLET)).map(filter -> this.properties.isFilterConfigCachingEnabled() ? this.getOrUpdateConfigurationFromCache((Bucket4JConfiguration)filter) : filter).forEach(filter -> {
            this.rateLimitService.addDefaultMetricTags(this.properties, (Bucket4JConfiguration)filter);
            filterCount.incrementAndGet();
            FilterConfiguration filterConfig = this.buildFilterConfig((Bucket4JConfiguration)filter, this.cacheResolver.resolve(filter.getCacheName()));
            this.servletConfigurationHolder.addFilterConfiguration(filter);
            Object beanName = filter.getId() != null ? filter.getId() : "bucket4JServletRequestFilter" + filterCount;
            this.context.registerBean((String)beanName, Filter.class, () -> new ServletRequestFilter((FilterConfiguration<HttpServletRequest, HttpServletResponse>)filterConfig), new BeanDefinitionCustomizer[0]);
            log.info("create-servlet-filter;{};{};{}", new Object[]{filterCount, filter.getCacheName(), filter.getUrl()});
        });
    }

    @Override
    public void onCacheUpdateEvent(CacheUpdateEvent<String, Bucket4JConfiguration> event) {
        Bucket4JConfiguration newConfig = event.getNewValue();
        if (newConfig.getFilterMethod().equals((Object)FilterMethod.SERVLET)) {
            try {
                ServletRequestFilter filter = (ServletRequestFilter)((Object)this.context.getBean(event.getKey(), ServletRequestFilter.class));
                FilterConfiguration newFilterConfig = this.buildFilterConfig(newConfig, this.cacheResolver.resolve(newConfig.getCacheName()));
                filter.setFilterConfig(newFilterConfig);
            }
            catch (Exception exception) {
                log.warn("Failed to update Servlet Filter configuration. {}", (Object)exception.getMessage());
            }
        }
    }
}

