/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.config.aspect;

import com.giffing.bucket4j.spring.boot.starter.config.cache.ProxyManagerWrapper;
import com.giffing.bucket4j.spring.boot.starter.config.cache.SyncCacheResolver;
import com.giffing.bucket4j.spring.boot.starter.context.ExpressionParams;
import com.giffing.bucket4j.spring.boot.starter.context.IgnoreRateLimiting;
import com.giffing.bucket4j.spring.boot.starter.context.KeyFilter;
import com.giffing.bucket4j.spring.boot.starter.context.PostRateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitCheck;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitException;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResult;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimitResultWrapper;
import com.giffing.bucket4j.spring.boot.starter.context.RateLimiting;
import com.giffing.bucket4j.spring.boot.starter.context.metrics.MetricHandler;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Bucket4JBootProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.MethodProperties;
import com.giffing.bucket4j.spring.boot.starter.context.properties.Metrics;
import com.giffing.bucket4j.spring.boot.starter.context.properties.RateLimit;
import com.giffing.bucket4j.spring.boot.starter.service.RateLimitService;
import com.giffing.bucket4j.spring.boot.starter.utils.RateLimitAopUtils;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Aspect
public class RateLimitAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimitAspect.class);
    private final RateLimitService rateLimitService;
    private final Bucket4JBootProperties bucket4JBootProperties;
    private final SyncCacheResolver syncCacheResolver;
    private final List<MetricHandler> metricHandlers;
    private final Map<String, RateLimitService.RateLimitConfigresult<Method, Object>> rateLimitConfigResults = new HashMap<String, RateLimitService.RateLimitConfigresult<Method, Object>>();

    @PostConstruct
    public void init() {
        for (MethodProperties methodProperty : this.bucket4JBootProperties.getMethods()) {
            ProxyManagerWrapper proxyManagerWrapper = this.syncCacheResolver.resolve(methodProperty.getCacheName());
            RateLimitService.RateLimitConfig rateLimitConfig = RateLimitService.RateLimitConfig.builder().rateLimits(List.of(methodProperty.getRateLimit())).metricHandlers(this.metricHandlers).executePredicates(Map.of()).cacheName(methodProperty.getCacheName()).configVersion(0L).keyFunction((rl, sr) -> {
                KeyFilter keyFilter = this.rateLimitService.getKeyFilter(((Method)sr.getRootObject()).getName(), (RateLimit)rl);
                return keyFilter.key(sr);
            }).metrics(new Metrics(this.bucket4JBootProperties.getDefaultMethodMetricTags())).proxyWrapper(proxyManagerWrapper).build();
            RateLimitService.RateLimitConfigresult rateLimitConfigResult = this.rateLimitService.configureRateLimit(rateLimitConfig);
            this.rateLimitConfigResults.put(methodProperty.getName(), rateLimitConfigResult);
        }
    }

    @Pointcut(value="execution(public * *(..))")
    public void publicMethod() {
    }

    @Pointcut(value="@annotation(com.giffing.bucket4j.spring.boot.starter.context.RateLimiting)")
    private void methodsAnnotatedWithRateLimitAnnotation() {
    }

    @Pointcut(value="@within(com.giffing.bucket4j.spring.boot.starter.context.RateLimiting) && publicMethod()")
    private void classAnnotatedWithRateLimitAnnotation() {
    }

    @Around(value="methodsAnnotatedWithRateLimitAnnotation() || classAnnotatedWithRateLimitAnnotation()")
    public Object processMethodsAnnotatedWithRateLimitAnnotation(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        IgnoreRateLimiting ignoreRateLimitAnnotation = RateLimitAopUtils.getAnnotationFromMethodOrClass(method, IgnoreRateLimiting.class);
        if (ignoreRateLimitAnnotation != null) {
            return joinPoint.proceed();
        }
        RateLimiting rateLimitAnnotation = RateLimitAopUtils.getAnnotationFromMethodOrClass(method, RateLimiting.class);
        Method fallbackMethod = null;
        if (StringUtils.hasText((String)rateLimitAnnotation.fallbackMethodName())) {
            List<Method> fallbackMethods = Arrays.stream(method.getDeclaringClass().getMethods()).filter(p -> p.getName().equals(rateLimitAnnotation.fallbackMethodName())).toList();
            if (fallbackMethods.size() > 1) {
                throw new IllegalStateException("Found " + fallbackMethods.size() + " fallbackMethods for " + rateLimitAnnotation.fallbackMethodName());
            }
            if (!fallbackMethods.isEmpty()) {
                fallbackMethod = joinPoint.getTarget().getClass().getMethod(rateLimitAnnotation.fallbackMethodName(), ((MethodSignature)joinPoint.getSignature()).getParameterTypes());
            }
        }
        Map<String, Object> params = RateLimitAspect.collectExpressionParameter(joinPoint.getArgs(), signature.getParameterNames());
        this.assertValidCacheName(rateLimitAnnotation);
        RateLimit annotationRateLimit = RateLimitAspect.buildMainRateLimitConfiguration(rateLimitAnnotation);
        RateLimitService.RateLimitConfigresult<Method, Object> rateLimitConfigResult = this.rateLimitConfigResults.get(rateLimitAnnotation.name());
        RateLimitConsumedResult consumedResult = RateLimitAspect.performRateLimit(rateLimitConfigResult, method, params, annotationRateLimit);
        if (!consumedResult.allConsumed()) {
            if (fallbackMethod != null) {
                return fallbackMethod.invoke(joinPoint.getTarget(), joinPoint.getArgs());
            }
            throw new RateLimitException();
        }
        Object methodResult = joinPoint.proceed();
        RateLimitAspect.performPostRateLimit(rateLimitConfigResult, method, methodResult);
        return methodResult;
    }

    private static void performPostRateLimit(RateLimitService.RateLimitConfigresult<Method, Object> rateLimitConfigResult, Method method, Object methodResult) {
        for (PostRateLimitCheck<Method, Object> rlc : rateLimitConfigResult.getPostRateLimitChecks()) {
            RateLimitResultWrapper result = rlc.rateLimit((Object)method, methodResult);
            if (result == null) continue;
            log.debug("post-rate-limit;remaining-tokens:{}", (Object)result.getRateLimitResult().getRemainingTokens());
        }
    }

    private static RateLimitConsumedResult performRateLimit(RateLimitService.RateLimitConfigresult<Method, Object> rateLimitConfigResult, Method method, Map<String, Object> params, RateLimit annotationRateLimit) {
        boolean allConsumed = true;
        Long remainingLimit = null;
        for (RateLimitCheck<Method> rl : rateLimitConfigResult.getRateLimitChecks()) {
            RateLimitResultWrapper wrapper = rl.rateLimit(new ExpressionParams((Object)method).addParams(params), annotationRateLimit);
            if (wrapper == null || wrapper.getRateLimitResult() == null) continue;
            RateLimitResult rateLimitResult = wrapper.getRateLimitResult();
            if (rateLimitResult.isConsumed()) {
                remainingLimit = RateLimitService.getRemainingLimit(remainingLimit, rateLimitResult);
                continue;
            }
            allConsumed = false;
            break;
        }
        if (allConsumed) {
            log.debug("rate-limit-remaining;limit:{}", remainingLimit);
        }
        return new RateLimitConsumedResult(allConsumed, remainingLimit);
    }

    private static RateLimit buildMainRateLimitConfiguration(RateLimiting rateLimitAnnotation) {
        RateLimit annotationRateLimit = new RateLimit();
        annotationRateLimit.setExecuteCondition(rateLimitAnnotation.executeCondition());
        annotationRateLimit.setCacheKey(rateLimitAnnotation.cacheKey());
        annotationRateLimit.setSkipCondition(rateLimitAnnotation.skipCondition());
        return annotationRateLimit;
    }

    private void assertValidCacheName(RateLimiting rateLimitAnnotation) {
        if (!this.rateLimitConfigResults.containsKey(rateLimitAnnotation.name())) {
            throw new IllegalStateException("Could not find cache " + rateLimitAnnotation.name());
        }
    }

    private static Map<String, Object> collectExpressionParameter(Object[] args, String[] parameterNames) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            log.debug("expresion-params;name:{};arg:{}", (Object)parameterNames[i], args[i]);
            params.put(parameterNames[i], args[i]);
        }
        return params;
    }

    @Generated
    public RateLimitAspect(RateLimitService rateLimitService, Bucket4JBootProperties bucket4JBootProperties, SyncCacheResolver syncCacheResolver, List<MetricHandler> metricHandlers) {
        this.rateLimitService = rateLimitService;
        this.bucket4JBootProperties = bucket4JBootProperties;
        this.syncCacheResolver = syncCacheResolver;
        this.metricHandlers = metricHandlers;
    }

    private record RateLimitConsumedResult(boolean allConsumed, Long remainingLimit) {
    }
}

